package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * 活动细案(ActivityDetailPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
@Component
public class ActivityDetailPlanModifyRepository extends ServiceImpl<ActivityDetailPlanModifyMapper, ActivityDetailPlanModify> {

    @Autowired
    private ActivityDetailPlanModifyMapper activityDetailPlanModifyMapper;

    /**
     * 获取带调整的细案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    public Page<ActivityDetailPlanVo> findToModifyList(Pageable pageable, ActivityDetailPlanDto dto) {
        Page<ActivityDetailPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityDetailPlanVo> pageList = this.activityDetailPlanModifyMapper.findToModifyList(page, dto);
        return pageList;

    }

    public void deleteIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanModify>().lambda();
        updateWrapper.set(ActivityDetailPlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanModify::getId, ids);
        this.update(updateWrapper);
    }

    public void updateProcessStatusAndProcessNo(String modifyBusinessCode, String processStatus, String processNo) {
        if (StringUtils.isEmpty(modifyBusinessCode)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityDetailPlanModify.class)
                .set(ActivityDetailPlanModify::getProcessStatus, processStatus)
                .set(ActivityDetailPlanModify::getProcessNo, processNo)
                .in(ActivityDetailPlanModify::getModifyBusinessCode, modifyBusinessCode)
                .eq(ActivityDetailPlanModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }


    /**
     * 更新流程状态
     * @param businessNo 业务数据编码
     * @param processStatus 流程状态
     */
    public void updateProcessStatus(String businessNo, String processStatus) {
        if (StringUtils.isEmpty(businessNo)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityDetailPlanModify.class)
                .set(ActivityDetailPlanModify::getProcessStatus, processStatus)
                .in(ActivityDetailPlanModify::getModifyBusinessCode, businessNo)
                .eq(ActivityDetailPlanModify::getTenantCode, TenantUtils.getTenantCode())

        );
    }

    public ActivityDetailPlanModify getByCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty(modifyBusinessCode)){
            return null;
        }
        return getOne(Wrappers.<ActivityDetailPlanModify>lambdaQuery()
                .eq(ActivityDetailPlanModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(ActivityDetailPlanModify::getTenantCode,TenantUtils.getTenantCode())
        );
    }

}

