
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanBudgetModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanPlanModifyMapper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * 活动方案表(ActivityDetailPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityDetailPlanPlanModifyRepository extends ServiceImpl<ActivityDetailPlanPlanModifyMapper, ActivityDetailPlanPlanModify> {

    public List<ActivityDetailPlanPlanModify> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanPlanModify.class)
                .eq(ActivityDetailPlanPlanModify::getModifyBusinessCode, modifyBusinessCode)
                .eq(ActivityDetailPlanPlanModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanPlanModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanPlanModify>().lambda();
        updateWrapper.set(ActivityDetailPlanPlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanPlanModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyBusinessCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanPlanModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanPlanModify>().lambda();
        updateWrapper.set(ActivityDetailPlanPlanModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanPlanModify::getModifyBusinessCode, modifyBusinessCodes);
        this.update(updateWrapper);
    }
}

