package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;

import java.util.List;

/**
 * 方案关联预算数据
 * @author wanghaojia
 * @date 2022/12/24 14:28
 */
public interface ActivityDetailPlanBudgetModifyService {

    /**
     * 保存活动方案-关联预算数据
     *
     * @param itemDtoList 方案明细数据
     */
    void saveActivityDetailPlanBudgetList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanItemModifyDto> itemDtoList);

    void deleteByModifyCodes(List<String> modifyCodes);

    /**
     * 扣减预算信息
     * @param modifyCode 方案变更编码
     * @param planCode 方案编码
     * @param doSave 是否执行扣减
     */
    void useMonthBudgetByModifyCode(String modifyCode, String planCode, boolean doSave);

    /**
     * 扣减预算信息
     * @param modifyItemBudgetList 变更的预算信息
     * @param detailPlanCode 细案编码
     * @param doSave 是否执行扣减
     */
    void useMonthBudget(List<ActivityDetailPlanBudgetModifyDto> modifyItemBudgetList, String detailPlanCode, boolean doSave);

    /**
     * 流程驳回处理预算
     * @param modifyCode 变更编码
     * @param planCode 方案编码
     */
    void returnMonthBudgetByModifyCode(String modifyCode, String planCode);

    /**
     * 审批通过，退回减少的预算金额
     * @param activityPlanBudgets 原预算信息
     * @param budgetModifyList 变更后预算信息
     */
    void passReturnMonthBudgetByModifyCode(List<ActivityDetailPlanBudget> activityPlanBudgets, List<ActivityDetailPlanBudgetModify> budgetModifyList);

}
