package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import org.springframework.data.domain.Pageable;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 活动细案变更接口
 * @author wanghaojia
 * @date 2022/12/10 16:42
 */
public interface ActivityDetailPlanItemModifyService extends MnPageCacheService<ActivityDetailPlanItemModifyVo, ActivityDetailPlanItemModifyDto> {

    /**
     * 获取预算汇总信息
     */
    List<ActivityDetailPlanBudgetSumVo> findBudgetCacheSumList(String cacheKey);

    /**
     * 保存活动细案明细数据
     *
     * @param itemCacheList  活动细案明细数据
     * @param createValidate 是否走校验逻辑
     */
    void saveActivityDetailPlanItemList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanItemModifyDto> itemCacheList, boolean createValidate);

    /**
     * 活动细案明细新增批量校验逻辑
     *
     * @param dtoList 活动细案明细数据
     */
    void createValidateList(List<ActivityDetailPlanItemModifyDto> dtoList);


    /**
     * 根据活动细案编码删除活动细案明细数据
     * @param modifyBusinessCodeList 变更编码集合
     */
    void deleteByDetailModifyBusinessCodes(List<String> modifyBusinessCodeList);

    /**
     * 获取缓存调整明细总数
     * @return
     */
    Integer getTotal(Map<String, Object> params);

    /**
     * 明细导出
     * @param params
     * @return
     */
    List<ActivityDetailPlanItemModifyDto> findCacheByDetailPlanCodesForExports(Map<String, Object> params);

    /**
     * 查询细案调整明细
     * @param modifyBusinessCodes
     * @return
     */
    List<ActivityDetailPlanItemModifyDto> findModifyItemByModifyBusinessCodes(List<String> modifyBusinessCodes);

    Page<ActivityDetailPlanItemModifyVo> findByConditions(Pageable pageable, ActivityDetailPlanItemModifyDto dto);

    List<ActivityDetailPlanModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException;

}
