package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.dto.ActivityDetailPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动细案变更接口
 * @author wanghaojia
 * @date 2022/12/10 16:42
 */
public interface ActivityDetailPlanModifyService {

    /**
     * 获取带调整的细案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    Page<ActivityDetailPlanVo> findToModifyList(Pageable pageable, ActivityDetailPlanDto dto);

    void saveActivityDetailPlan(ActivityDetailPlanModifyDto dto, String cacheKey);

    /**
     *
     * @param id
     * @return
     */
    ActivityDetailPlanModifyVo findById(String id);

    ActivityDetailPlanModifyVo findByIdOrCode(String id, String code);

    /**
     * 细案变更提交流程
     * @param dto
     */
    void submit(ActivityDetailPlanModifyApproveSubmitDto dto);

    /**
     * 删除变更数据
     * @param ids
     */
    void delete(List<String> ids);

    void processPass(ProcessStatusDto dto);

    void processRejectAndRecover(ProcessStatusDto dto);

    void doUpdateOriginData(String businessNo);

    /**
     * 流程审批通过退预算
     * @param modifyBusinessCode 变更编码
     */
    void passReturnMonthBudgetByModifyCode(String modifyBusinessCode);

    /**
     * 方案变更后自动变更细案逻辑
     */
    void planModifyUpdateDetailPlan(String planCode);

}
