package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动方案-预算
 * @author wanghaojia
 * @date 2022/12/24 14:40
 */
@Service
public class ActivityDetailPlanBudgetModifyServiceImpl implements ActivityDetailPlanBudgetModifyService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetModifyRepository activityDetailPlanBudgetModifyRepository;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlanBudgetList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanItemModifyDto> itemDtoList) {
        Map<String, List<ActivityDetailPlanBudgetModify>> oldMap = Maps.newHashMap();
        if (update){
//            List<ActivityDetailPlanBudget> oldList = ActivityDetailPlanBudgetRepository.listByPlanCode(entity.getPlanCode());
//            oldMap = oldList.stream().collect(Collectors.toMap(item -> {
//                return item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            }, Function.identity()));
            //直接物理删除新建吧。
            activityDetailPlanBudgetModifyRepository.deletePhysicalByModifyBusinessCode(entity.getModifyBusinessCode());
        }
        for (ActivityDetailPlanItemModifyDto itemDto : itemDtoList) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                itemDto.getBudgetShares().forEach(item -> {
                    item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    item.setDetailPlanCode(itemDto.getDetailPlanCode());
                    item.setModifyBusinessCode(entity.getModifyBusinessCode());
                });
            }
        }
        List<ActivityDetailPlanBudgetModifyDto> budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemModifyDto::getBudgetShares).filter(Objects::nonNull)
                .flatMap(Collection::stream).collect(Collectors.toList());
        List<ActivityDetailPlanBudgetModify> list = (List<ActivityDetailPlanBudgetModify>) nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList,ActivityDetailPlanBudgetModifyDto.class, ActivityDetailPlanBudgetModify.class,HashSet.class,ArrayList.class);

        List<ActivityDetailPlanBudgetModify> saveList = Lists.newArrayList();
        List<ActivityDetailPlanBudgetModify> updateList = Lists.newArrayList();
        for (ActivityDetailPlanBudgetModify item : list) {
//            String key = item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityDetailPlanBudgetModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityDetailPlanBudgetModifyRepository.updateBatchById(updateList);
        }
//        if (oldMap.size() > 0){
//            //待删除的数据
//            List<String> deleteIds = oldMap.values().stream().map(ActivityDetailPlanBudget::getId).collect(Collectors.toList());
//            ActivityDetailPlanBudgetRepository.deleteByIds(deleteIds);
//        }
    }

    @Override
    public void deleteByModifyCodes(List<String> planCodes) {
        activityDetailPlanBudgetModifyRepository.deleteByModifyBusinessCodes(planCodes);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode, String detailPlanCode, boolean doSave) {
        List<ActivityDetailPlanBudgetModifyDto> modifyItemBudgetList = activityDetailPlanBudgetModifyRepository.listDtoByModifyCodeList(Lists.newArrayList(modifyCode));
        useMonthBudget(modifyItemBudgetList,detailPlanCode,doSave);
    }

    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetModifyDto> modifyItemBudgetList,String detailPlanCode,boolean doSave) {
        List<ActivityDetailPlanBudget> originBudgetList = activityDetailPlanBudgetRepository.listByDetailPlanCode(detailPlanCode);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream()
                .filter(item -> null != item.getUseAmount())
                .collect(Collectors.toMap(item -> {
            //方案明细编码+月度预算编码，    应该能确定唯一了吧
            return  item.getDetailPlanItemCode() +item.getRelatePlanItemCode()+ item.getMonthBudgetCode();
        }, ActivityDetailPlanBudget::getUseAmount));

        List<OperateMarketingStrategyBudgetDto> strategyOperateList = Lists.newArrayList();
        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();
        for (ActivityDetailPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getDetailPlanItemCode() +budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0){
                //不变或者是要退
                continue;
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                budgetOperateList.add(new OperateMonthBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    this.setDoSave(doSave);
                }});
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    this.setDoSave(doSave);
                }});
            }
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode,String detailPlanCode) {
        List<ActivityDetailPlanBudgetModify> modifyItemBudgetList = activityDetailPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(modifyCode));
        List<ActivityDetailPlanBudget> originBudgetList = activityDetailPlanBudgetRepository.listByDetailPlanCode(detailPlanCode);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> {
            //占用类型+方案明细编码+关联策略编码+关联总部方案明细编码+月度预算编码，    应该能确定唯一了吧
            return item.getDetailPlanItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode();
        }, ActivityDetailPlanBudget::getUseAmount));

        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();
        for (ActivityDetailPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getDetailPlanItemCode() +budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0){
                //不变或者是要退
                continue;
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                budgetOperateList.add(new OperateMonthBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }});
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount());
                }});
            }
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passReturnMonthBudgetByModifyCode(List<ActivityDetailPlanBudget> originBudgetList, List<ActivityDetailPlanBudgetModify> modifyItemBudgetList) {
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream()
                .filter(item -> null != item.getUseAmount())
                .collect(Collectors.toMap(item -> {
                    //占用类型+方案明细编码+关联策略编码+关联总部方案明细编码+月度预算编码，    应该能确定唯一了吧
                    return item.getDetailPlanItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode();
                }, ActivityDetailPlanBudget::getUseAmount));

        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();
        for (ActivityDetailPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getDetailPlanItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) >= 0){
                //不变或者是要扣
                continue;
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                budgetOperateList.add(new OperateMonthBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }});
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }});
            }
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
    }
}
