package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案变更分页缓存实现
 * @author wanghaojia
 * @date 2022/12/16 11:34
 */
@Component
public class ActivityDetailPlanItemModifyPageCacheHelper extends MnPageCacheHelper<ActivityDetailPlanItemModifyVo, ActivityDetailPlanItemModifyDto> {


    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_CACHE_MODIFY_KEY_PREFIX;
    }

    @Override
    public Class<ActivityDetailPlanItemModifyDto> getDtoClass() {
        return ActivityDetailPlanItemModifyDto.class;
    }

    @Override
    public Class<ActivityDetailPlanItemModifyVo> getVoClass() {
        return ActivityDetailPlanItemModifyVo.class;
    }

    @Override
    public List<ActivityDetailPlanItemModifyDto> findDtoListFromRepository(ActivityDetailPlanItemModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getModifyBusinessCode()) && StringUtils.isEmpty(dto.getDetailPlanCode())){
            return Lists.newArrayList();
        }
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        List<ActivityDetailPlanItemDto> planItemDtos = activityDetailPlanItemRepository.findDtoAndAttachListByDetailPlanCode(dto.getDetailPlanCode());
        List<ActivityDetailPlanItemModifyDto> allDtoList = null;
        if (StringUtils.isNotEmpty(dto.getModifyBusinessCode())){
            allDtoList = activityDetailPlanItemModifyRepository.findDtoListByModifyCode(dto.getModifyBusinessCode());
            Map<String, ActivityDetailPlanItemDto> planItemDtoMap = planItemDtos.stream().collect(Collectors.toMap(ActivityDetailPlanItemDto::getDetailPlanItemCode, Function.identity()));
            for (ActivityDetailPlanItemModifyDto ActivityDetailPlanItemModifyDto : allDtoList) {
                ActivityDetailPlanItemModify modifyItem = nebulaToolkitService.copyObjectByWhiteList(ActivityDetailPlanItemModifyDto, ActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class);
                BeanUtils.copyProperties(planItemDtoMap.get(ActivityDetailPlanItemModifyDto.getDetailPlanItemCode()),ActivityDetailPlanItemModifyDto);
                BeanUtils.copyProperties(modifyItem,ActivityDetailPlanItemModifyDto);
            }
            activityDetailPlanItemModifyRepository.fillDtoListProperties(allDtoList);
        }else {
            //初次调整，从活动方案里面获取
            allDtoList = Lists.newArrayList();
            for (ActivityDetailPlanItemDto planItemDto : planItemDtos) {
                ActivityDetailPlanItemModifyDto modifyItemDto = nebulaToolkitService.copyObjectByWhiteList(planItemDto, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class);
                if (!CollectionUtils.isEmpty(planItemDto.getBudgetShares())){
//                    modifyItemDto.setBudgetShares((List<ActivityDetailPlanBudgetModifyDto>)(List)nebulaToolkitService.copyCollectionByWhiteList(planItemDto.getBudgetShares(), ActivityDetailPlanBudgetDto.class, ActivityDetailPlanBudgetModifyDto.class,HashSet.class,ArrayList.class));
                }
                allDtoList.add(modifyItemDto);
            }
        }

        allDtoList.sort(Comparator.comparing(ActivityDetailPlanItemModifyDto::getDetailPlanItemCode));
        Map<String, List<ActivityDetailPlanItemModifyDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemModifyDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityDetailPlanItemModifyDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, ActivityDetailPlanItemModifyDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(),  entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        return allMap.get(templateCode);
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public List<ActivityDetailPlanItemModifyDto> newItem(String cacheKey, List<ActivityDetailPlanItemModifyDto> itemList) {
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        ActivityDetailPlanItemModifyDto newItem = new ActivityDetailPlanItemModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<ActivityDetailPlanItemModifyDto> copyItem(String cacheKey, List<ActivityDetailPlanItemModifyDto> itemList) {
        List<ActivityDetailPlanItemModifyDto> newItemList = (List<ActivityDetailPlanItemModifyDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItemModifyDto.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        for (ActivityDetailPlanItemModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setDetailPlanItemCode(null);
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(ActivityDetailPlanItemModifyDto ActivityDetailPlanItemModifyDto) {
        return ActivityDetailPlanItemModifyDto.getId();
    }

    @Override
    public String getCheckedStatus(ActivityDetailPlanItemModifyDto ActivityDetailPlanItemModifyDto) {
        return ActivityDetailPlanItemModifyDto.getChecked();
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

}
