package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.CarGiftGroupEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案变更接口
 * @author wanghaojia
 * @date 2022/12/10 16:42
 */
@Slf4j
@Service
public class ActivityDetailPlanItemModifyServiceImpl extends MnPageCacheServiceImpl<ActivityDetailPlanItemModifyVo, ActivityDetailPlanItemModifyDto> implements ActivityDetailPlanItemModifyService {

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Page<ActivityDetailPlanItemModifyVo> findCachePageList(Pageable pageable, ActivityDetailPlanItemModifyDto dto, String cacheKey) {
        String redisCacheIdKey = helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = helper.getRedisCacheInitKey(cacheKey);
        Page<ActivityDetailPlanItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(Lists.newArrayList());
        List<String> detailPlanItemCodes = null;
        if (Objects.nonNull(dto)) {
            String detailPlanItemCode = dto.getDetailPlanItemCode();
            if (StringUtils.isNotBlank(detailPlanItemCode)) {
                if (detailPlanItemCode.contains(",")) {
                    detailPlanItemCodes = Arrays.asList(detailPlanItemCode.split(","));
                }else {
                    detailPlanItemCodes = Arrays.asList(detailPlanItemCode.split(" "));
                }
            }
        }
        List<ActivityDetailPlanItemModifyDto> dtoList = new ArrayList<>();
        a:if (redisService.hasKey(redisCacheIdKey)) {
            if (!CollectionUtils.isEmpty(detailPlanItemCodes)) {
                List<ActivityDetailPlanItemModifyDto> cacheList = findCacheList(cacheKey);
                if (CollectionUtils.isEmpty(cacheList)) {
                    break a;
                }
                Map<String, List<ActivityDetailPlanItemModifyDto>> map = cacheList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemModifyDto::getDetailPlanItemCode));
                List<String> list = detailPlanItemCodes.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                for (String detailPlanItemCode : list) {
                    List<ActivityDetailPlanItemModifyDto> activityDetailPlanItemModifyDtos = map.get(detailPlanItemCode);
                    if (!CollectionUtils.isEmpty(activityDetailPlanItemModifyDtos)) {
                        dtoList.addAll(activityDetailPlanItemModifyDtos);
                    }
                }
                if (CollectionUtils.isEmpty(dtoList)) {
                    break a;
                }
                addPageData(page, dtoList);
            } else {
                //redis里面有的话直接从redis里面取
                Long total = redisService.lSize(redisCacheIdKey);
                page.setTotal(total);
                List<Object> idList = redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1);
                if (!CollectionUtils.isEmpty(idList)) {
                    List<Object> dataList = redisTemplate.opsForHash().multiGet(redisCacheDataKey, idList);
                    dtoList = (List<ActivityDetailPlanItemModifyDto>) (List) dataList;
                    List<ActivityDetailPlanItemModifyVo> voList = helper.dtoListToVoList(dtoList);
                    page.setRecords(voList);
                }
            }
        } else if (!redisService.hasKey(redisCacheInitKey) && null != dto) {
            //标记为已初始化，不重复初始化
            redisService.set(redisCacheInitKey,BooleanEnum.TRUE,helper.getExpireTime());
            //redis里面没有
            dtoList = helper.findDtoListFromRepository(dto, cacheKey);

            if (CollectionUtils.isEmpty(dtoList)) {
                break a;
            }
            //放到缓存里面
            if (helper.initToCacheFromRepository()) {
                helper.putCache(cacheKey,dtoList);
            }
            if (!CollectionUtils.isEmpty(detailPlanItemCodes)) {
                List<String> finalDetailPlanItemCodes = detailPlanItemCodes.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                dtoList = dtoList.stream().filter(a-> finalDetailPlanItemCodes.contains(a.getDetailPlanItemCode())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(dtoList)) {
                    break a;
                }
            }
            //放到分页里面
            addPageData(page, dtoList);
        }
        //更新下VO里面的字段值
        helper.fillVoListProperties(page.getRecords());
        return page;
    }

    /**
     * 将参数分页返回
     *
     * @param page
     * @param dtoList
     */
    private void addPageData(Page<ActivityDetailPlanItemModifyVo> page, List<ActivityDetailPlanItemModifyDto> dtoList) {
        page.setTotal(dtoList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<ActivityDetailPlanItemModifyDto> recordDtoList = dtoList.subList((int) page.offset(), (int) end);
            List<ActivityDetailPlanItemModifyVo> voList = helper.dtoListToVoList(recordDtoList);
            page.setRecords(voList);
        }
    }

    /**
     * 活动模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Override
    public List<ActivityDetailPlanBudgetSumVo> findBudgetCacheSumList(String cacheKey) {
        List<ActivityDetailPlanItemModifyDto> itemList = this.findCacheList(cacheKey + ":");
        Map<String, ActivityDetailPlanBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemModifyDto item : itemList) {
            if (StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())){
                //预算不为空才处理
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getHeadMonthBudgetCode(), (key) -> new ActivityDetailPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getHeadBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getHeadBudgetItemName());
                if (null != item.getHeadFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getHeadFeeAmountStr().trim())));
                    }catch (Exception e){
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
            if (StringUtils.isNotEmpty(item.getMonthBudgetCode())){
                //预算不为空才处理
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new ActivityDetailPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getBudgetItemName());
                if (null != item.getDepartmentFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getDepartmentFeeAmountStr().trim())));
                    }catch (Exception e){
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0){
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                budgetSumVo.setOrgCode(budgetVo.getOrgCode());
                budgetSumVo.setOrgName(budgetVo.getOrgName());
                if (null != budgetVo.getAccumulatedAvailableBalance()){
                    budgetSumVo.setAccumulatedAvailableBalance(budgetVo.getAccumulatedAvailableBalance());
                }
                if (null != budgetVo.getControlBalanceAmount()){
                    budgetSumVo.setControlBalanceAmount(budgetVo.getControlBalanceAmount());
                }
            }
        }
        List<ActivityDetailPlanBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        return budgetSumList;
    }

    @Override
    public void saveActivityDetailPlanItemList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanItemModifyDto> itemList, boolean createValidate) {
        if (createValidate) {
            createValidateList(itemList);
        }
        Map<String, ActivityDetailPlanItemModify> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityDetailPlanItemModify> oldList = activityDetailPlanItemModifyRepository.findListByModifyBusinessCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityDetailPlanItemModify::getId, Function.identity()));
        }
        List<ActivityDetailPlanItemModify> saveList = Lists.newArrayList();
        List<ActivityDetailPlanItemModify> updateList = Lists.newArrayList();

        for (ActivityDetailPlanItemModifyDto item : itemList) {
            item.setBusinessFormatCode(entity.getBusinessFormatCode());
            item.setBusinessUnitCode(entity.getBusinessUnitCode());

            if (oldMap.containsKey(item.getId())){
                ActivityDetailPlanItemModify oldItemEntity = oldMap.get(item.getId());
                item.setModifyBusinessCode(oldItemEntity.getModifyBusinessCode());
                ActivityDetailPlanItemModify itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class);
                updateList.add(itemEntity);
                oldMap.remove(item.getId());
            }else{
                ActivityDetailPlanItemModify itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class);
                itemEntity.setModifyBusinessCode(entity.getModifyBusinessCode());
                itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemEntity.setTenantCode(entity.getTenantCode());
                saveList.add(itemEntity);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            for (ActivityDetailPlanItemModify activityPlanItem : saveList) {
                BigDecimal offPointAmount = BigDecimal.ZERO;
//                if (null != activityPlanItem.getDepartmentFeeAmount()){
//                    offPointAmount = offPointAmount.add(activityPlanItem.getDepartmentFeeAmount());
//                }
//                if (null != activityPlanItem.getIntraCompanyAmount()){
//                    offPointAmount = offPointAmount.add(activityPlanItem.getIntraCompanyAmount());
//                }
                activityPlanItem.setOffPointAmount(offPointAmount);
                activityPlanItem.setId(null);
            }
            activityDetailPlanItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityDetailPlanItemModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityDetailPlanItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void createValidateList(List<ActivityDetailPlanItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemModifyDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(),"活动细案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()){
            throw new RuntimeException("活动细案明细模板数据有误！");
        }
        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemModifyDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemModifyDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemModifyDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        for (Map.Entry<String, List<ActivityDetailPlanItemModifyDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityDetailPlanItemModifyDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityDetailPlanItemModifyDto dto : thisDtoList) {
                //后端验证必填字段
//                Validate.notBlank(dto.getActivityTypeCode(),templateDetailTitleMap.getOrDefault("activityTypeCode","活动分类")+"不能为空！");
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(),"活动开始时间",true,DateUtil.DEFAULT_YEAR_MONTH_DAY,dto::setActivityBeginDate);
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(),"活动结束时间",true,DateUtil.DEFAULT_YEAR_MONTH_DAY,dto::setActivityEndDate);
//                if (dto.getActivityBeginDate().getYear() != dto.getActivityEndDate().getYear() ||
//                        dto.getActivityBeginDate().getMonth() != dto.getActivityEndDate().getMonth()){
//                    throw new RuntimeException("活动开始结束时间不能跨月!");
//                }
                dto.setFeeYearMonth(new Date(dto.getActivityBeginDate().getYear(),dto.getActivityEndDate().getMonth(),1));

//                Validate.notBlank(dto.getActivityOrgCode(),templateDetailTitleMap.getOrDefault("activityOrgCode","区域编码")+"不能为空！");
//                Validate.notBlank(dto.getProductBrandCode(),templateDetailTitleMap.getOrDefault("productBrandCodeStr","品牌编码")+"不能为空！");
                Validate.notNull(dto.getTotalFeeAmountStr(),templateDetailTitleMap.getOrDefault("totalFeeAmountStr","费用合计")+"不能为空！");

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())){
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())){
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())){
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())){
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }
            }
            //模板验证必填字段
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null != configDetail.getRequired() && configDetail.getRequired()) {
                    if (!propertyMap.containsKey(configDetail.getField())){
                        throw new IllegalArgumentException("模板["+templateConfigVo.getConfigName()+"]属性["+configDetail.getTitle()+"]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(configDetail.getField());
                    if (null != propertyDescriptor) {
                        for (ActivityDetailPlanItemModifyDto dto : thisDtoList) {
                            try {
                                Object invoke = propertyDescriptor.getReadMethod().invoke(dto);
                                if (null == invoke || StringUtils.isEmpty(invoke.toString())) {
                                    throw new IllegalArgumentException("[" + configDetail.getTitle() + "]不能为空！");
                                }
                            } catch (Exception e) {
                                throw new IllegalArgumentException("[" + configDetail.getTitle() + "]读取失败,请检查！");
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("[" + configDetail.getTitle() + "]配置有误，请检查！");
                    }
                }
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(dtoList,ActivityDetailPlanItemModifyDto.class,true,templateDetailTitleMap);
        }
        createValidateListHeadQuarters(dtoList);
    }

    /**
     * 主体活动细案变更明细校验
     */
    public void createValidateListHeadQuarters(List<ActivityDetailPlanItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        String businessUnitCode = dtoList.get(0).getBusinessUnitCode();
        if (!BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)){
            return;
        }
        //活动细案变更，主体活动方案   在方案预算跟踪表中已经确认的数据不能变更
        validateCloseRecord:{
            List<String> relatePlanItemCodeList = dtoList.stream().map(ActivityDetailPlanItemModifyDto::getRelatePlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(relatePlanItemCodeList)){
                break validateCloseRecord;
            }
            List<ActivityPlanItemVo> activityPlanItemVos = activityPlanItemSdkService.listByItemCodeList(relatePlanItemCodeList);
            for (ActivityPlanItemVo activityPlanItemVo : activityPlanItemVos) {
                if (BooleanEnum.TRUE.getCapital().equals(activityPlanItemVo.getWholeAudit())){
                    throw new RuntimeException("关联活动方案明细["+activityPlanItemVo.getPlanItemCode()+"]已进行预算回退，不能调整");
                }
            }
        }

    }

    @Override
    public void deleteByDetailModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        activityDetailPlanItemModifyRepository.deleteByDetailModifyBusinessCodes(modifyBusinessCodeList);
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        List<ActivityDetailPlanItemModifyDto> activityDetailPlanItemModifyDtos = findCacheByDetailPlanCodesForExports(params);
        return activityDetailPlanItemModifyDtos.size();
    }

    @Override
    public List<ActivityDetailPlanItemModifyDto> findCacheByDetailPlanCodesForExports(Map<String, Object> params){
        String cacheKey = (String) params.get("cacheKey");
        if(StringUtils.isEmpty(cacheKey)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItemModifyDto> cacheList = this.findCacheList(cacheKey);
        if(CollectionUtils.isEmpty(cacheList)){
            return Lists.newArrayList();
        }
        String detailPlanItemCodes = (String)params.get("detailPlanItemCode");
        if(StringUtils.isEmpty(detailPlanItemCodes)){
            return cacheList;
        }
        String[] s = detailPlanItemCodes.split("\\s+");
        return cacheList.stream().filter(o-> Arrays.stream(s).anyMatch(i->i.equals(o.getDetailPlanItemCode()))).collect(Collectors.toList());
    }

    /**
     * 查询细案调整明细
     * @param modifyBusinessCodes
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemModifyDto> findModifyItemByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return Lists.newArrayListWithCapacity(0);
        }
        return this.activityDetailPlanItemModifyRepository.findListByModifyBusinessCodes(modifyBusinessCodes);
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanItemModifyVo> findByConditions(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        return activityDetailPlanItemModifyRepository.findByConditions(pageable,dto);
    }

    @Override
    public List<ActivityDetailPlanModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException {
        Pageable tempPageable = PageRequest.of(1, 999999);
        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);

        ActivityDetailPlanItemModifyDto activityPlanItemModifyDto = new ActivityDetailPlanItemModifyDto();
        activityPlanItemModifyDto.setModifyBusinessCodeList(businessNoList);
        Page<ActivityDetailPlanItemModifyVo> itemBeforeModifyPage = findItemBeforeModifyList(tempPageable, activityPlanItemModifyDto);
        Page<ActivityDetailPlanItemModifyVo> itemModifyPage = findByConditions(tempPageable, activityPlanItemModifyDto);
        List<ActivityDetailPlanItemModifyVo> itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List<ActivityDetailPlanItemModifyVo> itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty(itemBeforeModifyList)) {
            return Lists.newArrayList();
        }

        return findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
    }

    private List<ActivityDetailPlanModifyFieldValue> findItemModifyLFieldValueList(List<ActivityDetailPlanItemModifyVo> itemModifyList, List<ActivityDetailPlanItemModifyVo> itemBeforeModifyList) throws InvocationTargetException, IllegalAccessException {
        Map<String, ActivityDetailPlanItemModifyVo> itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityDetailPlanItemModifyVo::getDetailPlanItemCode, Function.identity()));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemModifyVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Map<String,String> modifyFieldMap = Maps.newHashMap();
        Field[] declaredFields = ActivityDetailPlanItemModify.class.getDeclaredFields();
        for (Field declaredField : declaredFields) {
            ApiModelProperty modelProperty = declaredField.getDeclaredAnnotation(ApiModelProperty.class);
            if (null == modelProperty){
                continue;
            }
            modifyFieldMap.put(declaredField.getName(),modelProperty.value());
        }


        List<ActivityDetailPlanModifyFieldValue> modifyFieldValueList = Lists.newArrayList();
        for (ActivityDetailPlanItemModifyVo itemVo : itemBeforeModifyList) {
            ActivityDetailPlanItemModifyVo itemModifyVo = itemModifyMap.get(itemVo.getDetailPlanItemCode());

            for (Map.Entry<String, String> entry : modifyFieldMap.entrySet()) {
                String fieldName = entry.getKey();
                String fieldTitle = entry.getValue();
                PropertyDescriptor propertyDescriptor = propertyMap.get(fieldName);
                Object beforeFieldValue = propertyDescriptor.getReadMethod().invoke(itemVo);
                Object fieldValue = propertyDescriptor.getReadMethod().invoke(itemModifyVo);
                if (null == beforeFieldValue && null == fieldValue){
                    //变更前后都是空，跳过
                    continue;
                }

                ActivityDetailPlanModifyFieldValue modifyFieldValue = new ActivityDetailPlanModifyFieldValue();
                modifyFieldValue.setDetailPlanCode(itemVo.getDetailPlanCode());
                modifyFieldValue.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
                modifyFieldValue.setFieldName(fieldName);
                modifyFieldValue.setFieldTitle(fieldTitle);
                if (null != beforeFieldValue && null != fieldValue){
                    //变更前后都不为空
                    if (beforeFieldValue.equals(fieldValue)){
                        //相等，跳过
                        continue;
                    }else if (propertyDescriptor.getPropertyType() == Integer.class){
                        Integer beforeFieldValueInt = (Integer) beforeFieldValue;
                        Integer fieldValueInt = (Integer) fieldValue;
                        if (beforeFieldValueInt.compareTo(fieldValueInt) == 0){
                            continue;//相等，跳过
                        }
                    }else if (propertyDescriptor.getPropertyType() == BigDecimal.class){
                        BigDecimal beforeFieldValueBigDecimal = (BigDecimal) beforeFieldValue;
                        BigDecimal fieldValueBigDecimal = (BigDecimal) fieldValue;
                        if (beforeFieldValueBigDecimal.compareTo(fieldValueBigDecimal) == 0){
                            continue;//相等，跳过
                        }
                    }
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }else if (null != beforeFieldValue){
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                }else {
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }
                modifyFieldValueList.add(modifyFieldValue);
            }
        }

        //数据字典转换    结案形式
        List<String> dictTypeCodeList = Lists.newArrayList();
        dictTypeCodeList.add("tpm_audit_form");
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictTypeCodeList);
        Map<String, Map<String, String>> dictMapMap = !CollectionUtils.isEmpty(dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n)) : new HashMap<>();

        Map<String, String> auditFormMap = dictMapMap.get("tpm_audit_form");
        for (ActivityDetailPlanModifyFieldValue fieldValue : modifyFieldValueList) {
            if ("auditForm".equals(fieldValue.getFieldName())){
                if (StringUtils.isNotEmpty(fieldValue.getBeforeFieldValue())){
                    fieldValue.setBeforeFieldValue(auditFormMap.getOrDefault(fieldValue.getBeforeFieldValue(),fieldValue.getBeforeFieldValue()));
                }
                if (StringUtils.isNotEmpty(fieldValue.getFieldValue())){
                    fieldValue.setFieldValue(auditFormMap.getOrDefault(fieldValue.getFieldValue(),fieldValue.getFieldValue()));
                }
            }
        }

        return modifyFieldValueList;
    }

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    public Page<ActivityDetailPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        return activityDetailPlanItemModifyRepository.findItemBeforeModifyList(pageable,dto);
    }

    /**
     * 根据流程编码查询变更编码
     * @param processNo 流程编码
     * @return 策略变更编码
     */
    private List<String> findModifyBusinessNoListByProcessNo(String processNo){
        //查到调整前后的数据一个一个对比吧，对比完了再分页
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)){
            throw new RuntimeException("流程数据有误！");
        }
        return processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

}
