package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.service.ActivityDetailPlanModifySdkService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 细案变更
 * @author wanghaojia
 * @date 2023/10/6 11:06
 */
@Service
public class ActivityDetailPlanModifySdkServiceImpl implements ActivityDetailPlanModifySdkService {

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;

    @Override
    public List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItemModifyDto> list = this.activityDetailPlanItemModifyRepository.findDtoListByModifyCode(modifyBusinessCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

}
