package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.dto.ActivityDetailPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanPlanModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanModifyLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.log.ActivityDetailPlanLogEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.materialPurchaingOrder.MaterialPurchasingOrderEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.dto.ActivityDetailPlanPlanModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.pojo.ActivityPlanItemModifySelf;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.service.ActivityPlanModifySdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetSdkService;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案变更接口
 * @author wanghaojia
 * @date 2022/12/10 16:42
 */
@Service
@Slf4j
public class ActivityDetailPlanModifyServiceImpl implements ActivityDetailPlanModifyService {

    @Autowired(required = false)
    private ActivityDetailPlanModifyRepository activityDetailPlanModifyRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;

    @Autowired(required = false)
    private ActivityDetailPlanPlanModifyRepository activityDetailPlanPlanModifyRepository;
    @Autowired(required = false)
    private ActivityDetailPlanBudgetModifyRepository activityDetailPlanBudgetModifyRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemModifyService activityDetailPlanItemModifyService;
    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemExtendFieldRepository activityDetailPlanItemExtendFieldRepository;
    @Autowired(required = false)
    private ActivityDetailPlanPlanRepository activityDetailPlanPlanRepository;
    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanBudgetSdkService activityPlanBudgetSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanPlanModifyService activityDetailPlanPlanModifyService;
    
    @Autowired(required = false)
    private ActivityDetailPlanBudgetModifyService activityDetailPlanBudgetModifyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private ActivityPlanModifySdkService activityPlanModifySdkService;


    /**
     * 获取带调整的细案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    @Override
    public Page<ActivityDetailPlanVo> findToModifyList(Pageable pageable, ActivityDetailPlanDto dto) {
        return activityDetailPlanModifyRepository.findToModifyList(pageable,dto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlan(ActivityDetailPlanModifyDto dto, String cacheKey) {
        List<ActivityDetailPlanItemModifyDto> itemCacheList = activityDetailPlanItemModifyService.findCacheList(cacheKey);
        saveActivityDetailPlan(dto,itemCacheList);
        activityDetailPlanItemModifyService.clearCache(cacheKey);
    }

    /**
     * 活动方案新增编辑
     * @param itemDtoList 活动方案明细数据
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlan(ActivityDetailPlanModifyDto dto, List<ActivityDetailPlanItemModifyDto> itemDtoList) {
        ActivityDetailPlanModify entity = null;
        ActivityDetailPlanModifyDto oldDto = null;

        List<ActivityDetailPlanItemDto> originItemList = activityDetailPlanItemRepository.findDtoAndAttachListByDetailPlanCode(dto.getDetailPlanCode());
        Map<String, ActivityDetailPlanItemDto> originItemMap = originItemList.stream().collect(Collectors.toMap(ActivityDetailPlanItemDto::getDetailPlanItemCode, Function.identity()));

        createValidate(dto,itemDtoList,originItemMap);
        boolean update = !StringUtils.isBlank(dto.getId());
        if (!update){
            entity = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityDetailPlanModify.class, HashSet.class, ArrayList.class);
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
//            String ruleCode = StringUtils.join(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_MODIFY_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
            String code = this.generateCodeService.generateCode(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_MODIFY_RULE_CODE_PRE, 1, 6, 2, TimeUnit.DAYS).get(0);
            entity.setModifyBusinessCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            activityDetailPlanModifyRepository.save(entity);
        }else{
            ActivityDetailPlanModify oldEntity = activityDetailPlanModifyRepository.getById(dto.getId());
            if (!ProcessStatusEnum.PREPARE.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(oldEntity.getProcessStatus())) {
                throw new RuntimeException("只能编辑待提交、驳回、追回状态的数据！");
            }
            oldDto = nebulaToolkitService.copyObjectByWhiteList(oldEntity,ActivityDetailPlanModifyDto.class, HashSet.class, ArrayList.class);
            dto.setDetailPlanCode(oldEntity.getDetailPlanCode());
            dto.setModifyBusinessCode(oldEntity.getModifyBusinessCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityDetailPlanModify.class,HashSet.class,ArrayList.class);
            activityDetailPlanModifyRepository.updateById(entity);
        }
        //保存活动细案方案-方案关联
        activityDetailPlanPlanModifyService.saveActivityDetailPlanPlanList(entity,update,dto.getRelatePlanList());


        //保存方案明细
        activityDetailPlanItemModifyService.saveActivityDetailPlanItemList(entity,update,itemDtoList,false);

        //保存方案关联预算
        activityDetailPlanBudgetModifyService.saveActivityDetailPlanBudgetList(entity,update,itemDtoList);

        //备份一份数据
        backupInitVersionData(entity.getDetailPlanCode());

        //新增修改业务日志
        ActivityDetailPlanModifyLogEventDto logEventDto = new ActivityDetailPlanModifyLogEventDto();
        dto.setId(entity.getId());
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanModifyLogEventDto> onCreate =
                    ActivityDetailPlanLogEventListener::onCreateModify;
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanModifyLogEventDto> onUpdate =
                    ActivityDetailPlanLogEventListener::onUpdateModify;
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onUpdate);
        }
    }

    /**
     * 策略新增保存逻辑
     * @param dto 策略数据
     * @param itemCacheList 策略行数据
     */
    private void createValidate(ActivityDetailPlanModifyDto dto, List<ActivityDetailPlanItemModifyDto> itemCacheList,Map<String, ActivityDetailPlanItemDto> originItemMap) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
//        方案编码：提交时系统自动生成，可不显示。
        Validate.notBlank(dto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "新增时，业务单元不能为空！");

        itemCacheList.forEach(item->{
            item.setBusinessUnitCode(dto.getBusinessUnitCode());
            item.setBusinessFormatCode(dto.getBusinessFormatCode());
        });

        Validate.isTrue(!CollectionUtils.isEmpty(itemCacheList),"新增时，细案明细不能为空");
        activityDetailPlanItemModifyService.createValidateList(itemCacheList);
        List<ActivityDetailPlanBudgetModifyDto> budgetDtos = matchActivityPlanBudgetRelate(dto,itemCacheList,originItemMap);
        activityDetailPlanBudgetModifyService.useMonthBudget(budgetDtos,dto.getDetailPlanCode(),false);

        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            //垂直多选预算，校验预算金额之和要等于行上的费用金额
            for (ActivityDetailPlanItemModifyDto itemDto : itemCacheList) {
                BigDecimal feeAmount = Optional.ofNullable(itemDto.getFeeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal budgetFeeAmount = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                    for (ActivityDetailPlanBudgetModifyDto budgetShare : itemDto.getBudgetShares()) {
                        NumberStringDealUtil.validateNumberStrAndSet(itemDto.getFeeAmountStr(), "新增时，策略明细费用金额", false,dto::setFeeAmount, BigDecimal.class);
                        if (null != budgetShare.getUseAmount()){
                            budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                        }
                    }
                }
                if (feeAmount.compareTo(budgetFeeAmount) != 0){
                    throw new RuntimeException("费用金额["+feeAmount+"]不等于实际预算使用金额["+budgetFeeAmount+"]");
                }
            }
        }

        //设置表头汇总金额
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemModifyDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()){
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()){
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //非垂直，申请金额=总部承担金额+大区承担金额
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()){
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()){
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
            }
            if (null != activityPlanItemDto.getFeeAmount()){
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);

    }
    /**
     * 活动方案预算关联策略、方案
     * @param planDto 方案头数据
     */
    public List<ActivityDetailPlanBudgetModifyDto> matchActivityPlanBudgetRelate(ActivityDetailPlanModifyDto planDto,List<ActivityDetailPlanItemModifyDto> itemList,Map<String, ActivityDetailPlanItemDto> originItemMap){
        List<ActivityDetailPlanPlanModifyDto> relatePlanList = planDto.getRelatePlanList();
        if (!BooleanEnum.TRUE.getCapital().equals(planDto.getIsTemporary())) {
            //不是临时方案必须关联方案
            Validate.isTrue(!CollectionUtils.isEmpty(relatePlanList), "非临时方案必须关联方案!");
        }

        Map<String, List<ActivityPlanBudgetDto>> relatePlanBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudgetDto>> planBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudgetDto>> relatePlanCustomerBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relatePlanList)){
            List<String> planCodeList = relatePlanList.stream().map(ActivityDetailPlanPlanModifyDto::getPlanCode).distinct().collect(Collectors.toList());
            List<ActivityPlanBudgetDto> activityPlanBudgets = activityPlanBudgetSdkService.listDtoByPlanCodeList(planCodeList);
            planBudgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
            relatePlanBudgetMap = activityPlanBudgets.stream().filter(item -> StringUtils.isNotEmpty(item.getMonthBudgetCode())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getMonthBudgetCode));
            relatePlanCustomerBudgetMap = activityPlanBudgets.stream().filter(item -> ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
        }


        for (ActivityDetailPlanItemModifyDto itemDto : itemList) {
            ActivityDetailPlanItemDto originItemDto = originItemMap.get(itemDto.getDetailPlanItemCode());
            //先退还下之前已经扣过的预算
            if (!CollectionUtils.isEmpty(originItemDto.getBudgetShares())) {
                for (ActivityDetailPlanBudgetDto budgetShare : originItemDto.getBudgetShares()) {
                    if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShare.getOccupyType()) &&
                            StringUtils.isNotEmpty(budgetShare.getRelatePlanItemCode())) {
                        List<ActivityPlanBudgetDto> activityPlanBudgets = planBudgetMap.get(budgetShare.getRelatePlanItemCode());
                        //应该不能为空
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)) {
                            ActivityPlanBudgetDto activityPlanBudget = activityPlanBudgets.get(0);
                            activityPlanBudget.setUsedAmount(Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(budgetShare.getUseAmount()));
                        }
                    }
                }
            }

            //预算不允许修改的，重置下
            itemDto.setHeadMonthBudgetCode(originItemDto.getHeadMonthBudgetCode());
            itemDto.setHeadBudgetItemCode(originItemDto.getHeadBudgetItemCode());
            itemDto.setHeadBudgetItemName(originItemDto.getHeadBudgetItemName());
            itemDto.setMonthBudgetCode(originItemDto.getMonthBudgetCode());
            itemDto.setBudgetItemCode(originItemDto.getBudgetItemCode());
            itemDto.setBudgetItemName(originItemDto.getBudgetItemName());

        }

        List<ActivityDetailPlanBudgetModifyDto> budgetDtos = Lists.newArrayList();
        for (ActivityDetailPlanItemModifyDto itemDto : itemList) {
            //业务单元不是垂直，清空掉明细上的预算信息，按明细上的预算信息重新保存
            List<ActivityDetailPlanBudgetModifyDto> budgetList = Lists.newArrayList();
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())){
                //其他业务单元重新组装预算信息
                Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()) || !StringUtils.isEmpty(itemDto.getMonthBudgetCode()), "活动细案总部预算和大区预算不能同时为空!");
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0){
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                }else if (null != itemDto.getHeadFeeAmount() && itemDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0){
                    throw new RuntimeException("未选择总部预算编码，总部承担金额只能为0");
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0){
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                }else if (null != itemDto.getDepartmentFeeAmount() && itemDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0){
                    throw new RuntimeException("未选择大区预算编码，大区承担金额只能为0");
                }

                //1、临时方案
                if (BooleanEnum.TRUE.getCapital().equals(planDto.getIsTemporary())) {
//                    BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
//                    if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
//                        throw new RuntimeException("临时方案客户金额必须为0");
//                    }
                    if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(itemDto.getHeadFeeAmount());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        budgetList.add(monthBudget);
                    }
                    if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setUseAmount(itemDto.getDepartmentFeeAmount());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        budgetList.add(monthBudget);
                    }

                    itemDto.setBudgetShares(budgetList);
                    if (!CollectionUtils.isEmpty(budgetList)){
                        budgetDtos.addAll(budgetList);
                    }
                    continue ;
                }

                //2、非临时方案指定了方案明细编码，按指定的来，校验预算必须在范围内
                String relatePlanCode = itemDto.getRelatePlanCode();
                String relatePlanItemCode = itemDto.getRelatePlanItemCode();
                if (StringUtils.isNotEmpty(relatePlanItemCode)){
                    List<ActivityPlanBudgetDto> planItemBudgetList = planBudgetMap.get(relatePlanItemCode);
                    Set<String> planBudgetItemSet = Sets.newHashSet();
                    if (!CollectionUtils.isEmpty(planItemBudgetList)){
                        planBudgetItemSet = planItemBudgetList.stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                    }
                    if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                        if(!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())){
                            throw new RuntimeException("总部预算编码["+itemDto.getHeadMonthBudgetCode()+"]不属于方案明细["+relatePlanItemCode+"]");
                        }
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(itemDto.getHeadFeeAmount());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        budgetList.add(monthBudget);
                    }
                    if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                        if(!planBudgetItemSet.contains(itemDto.getMonthBudgetCode())) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }

                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setUseAmount(itemDto.getDepartmentFeeAmount());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        budgetList.add(monthBudget);
                    }

                    BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                    customer:if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
                        List<ActivityPlanBudgetDto> customerBudgetList = relatePlanCustomerBudgetMap.get(relatePlanItemCode);
                        if (CollectionUtils.isEmpty(customerBudgetList)){
//                            throw new RuntimeException("未获取到匹配方案的客户承担金额");
                            break customer;
                        }
                        BigDecimal usableCustomerAmount = customerBudgetList.stream().map(item -> {
                            return item.getUseAmount().subtract(item.getUsedAmount());
                        }).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (usableCustomerAmount.compareTo(customerFeeAmount) < 0){
//                            throw new RuntimeException("客户承担金额【"+customerFeeAmount+"】超过方案明细["+relatePlanItemCode+"]剩余可用客户承担金额["+usableCustomerAmount+"]");
                        }
                        //有客户承担金额的话也生成一条数据
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                        monthBudget.setUseAmount(customerFeeAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                        budgetList.add(monthBudget);
                    }
                    itemDto.setBudgetShares(budgetList);
                    if (!CollectionUtils.isEmpty(budgetList)){
                        budgetDtos.addAll(budgetList);
                    }
                    continue ;
                }

                //3、导入的预算，没有指定关联的方案明细，匹配预算信息
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    BigDecimal leaveAmount = headFeeAmount;
                    //非临时方案，占预算
                    List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                    if (CollectionUtils.isEmpty(activityPlanBudgets)){
                        throw new RuntimeException("总部预算["+itemDto.getHeadMonthBudgetCode()+"]不属于关联方案内");
                    }
                    for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                        if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                            break;
                        }
                        BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usableAmount = useAmount.subtract(usedAmount);
                        if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                            continue;
                        }
                        if (StringUtils.isNotEmpty(relatePlanItemCode)){
                            if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())){
                                //选中一个了就一个到底
                                continue;
                            }
                        }else{
                            relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                            relatePlanCode = activityPlanBudget.getPlanCode();
                        }
                        BigDecimal thisAmount = leaveAmount;
                        if (usableAmount.compareTo(thisAmount) < 0){
                            thisAmount = usableAmount;
                        }
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                        monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setUseAmount(thisAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        budgetList.add(monthBudget);
                        leaveAmount = leaveAmount.subtract(thisAmount);
                        activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0){
                        throw new RuntimeException("大区方案占用总部方案金额["+headFeeAmount+"]超过实际可用余额");
                    }
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    BigDecimal leaveAmount = departmentFeeAmount;
                    //非临时方案，占预算
                    List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getMonthBudgetCode());
                    for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                        if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                            break;
                        }
                        BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usableAmount = useAmount.subtract(usedAmount);
                        if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                            continue;
                        }
                        if (StringUtils.isNotEmpty(relatePlanItemCode)){
                            if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())){
                                //选中一个了就一个到底
                                continue;
                            }
                        }else{
                            relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                            relatePlanCode = activityPlanBudget.getPlanCode();
                        }

                        BigDecimal thisAmount = leaveAmount;
                        if (usableAmount.compareTo(thisAmount) < 0){
                            thisAmount = usableAmount;
                        }
                        ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                        monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                        monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                        monthBudget.setUseAmount(thisAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        budgetList.add(monthBudget);
                        leaveAmount = leaveAmount.subtract(thisAmount);
                        activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0){
                        throw new RuntimeException("活动细案占用方案金额["+departmentFeeAmount+"]超过实际可用余额");
                    }
                }
                BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                customer:if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
                    if (StringUtils.isEmpty(relatePlanItemCode)){
//                        throw new RuntimeException("客户金额不为空，未匹配到可用的方案明细");
                        break customer;
                    }
                    List<ActivityPlanBudgetDto> customerBudgetList = relatePlanCustomerBudgetMap.get(relatePlanItemCode);
                    if (CollectionUtils.isEmpty(customerBudgetList)){
//                        throw new RuntimeException("未获取到匹配方案的客户承担金额");
                        break customer;
                    }
                    BigDecimal usableCustomerAmount = customerBudgetList.stream().map(item -> {
                        return item.getUseAmount().subtract(item.getUsedAmount());
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (usableCustomerAmount.compareTo(customerFeeAmount) < 0){
//                        throw new RuntimeException("客户承担金额【"+customerFeeAmount+"】超过方案明细["+relatePlanItemCode+"]剩余可用客户承担金额["+usableCustomerAmount+"]");
                    }
                    //有客户承担金额的话也生成一条数据，供细案占用处理
                    ActivityDetailPlanBudgetModifyDto monthBudget = new ActivityDetailPlanBudgetModifyDto();
                    monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                    monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    monthBudget.setRelatePlanCode(relatePlanCode);
                    monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                    monthBudget.setUseAmount(customerFeeAmount);
                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                    budgetList.add(monthBudget);
                }
                itemDto.setRelatePlanCode(relatePlanCode);
                itemDto.setRelatePlanItemCode(relatePlanItemCode);
            }else{
                //垂直预算的逻辑
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                    for (ActivityDetailPlanBudgetModifyDto budgetDto : itemDto.getBudgetShares()) {
                        BigDecimal useAmount = budgetDto.getUseAmount();
                        BigDecimal leaveAmount = useAmount;
                        List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)){
                            for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                                    break;
                                }
                                BigDecimal planBudgetUseAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = planBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0){
                                    thisAmount = usableAmount;
                                }
                                ActivityDetailPlanBudgetModifyDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto,ActivityDetailPlanBudgetModifyDto.class,HashSet.class,ArrayList.class);
                                monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                                monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0){
                            //还有没处理的就直接扣预算了
                            ActivityDetailPlanBudgetModifyDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto,ActivityDetailPlanBudgetModifyDto.class,HashSet.class,ArrayList.class);
                            monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                            monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                            monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                            monthBudget.setUseAmount(leaveAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            budgetList.add(monthBudget);
                        }
                    }
                }
            }
            itemDto.setBudgetShares(budgetList);
            if (!CollectionUtils.isEmpty(budgetList)){
                budgetDtos.addAll(budgetList);
            }
        }

        return budgetDtos;
    }

    @Override
    public ActivityDetailPlanModifyVo findById(String id) {
        return findByIdOrCode(id,null);
    }

    @Override
    public ActivityDetailPlanModifyVo findByIdOrCode(String id,String code) {
        if (StringUtils.isEmpty(id) && StringUtils.isEmpty(code)) {
            return null;
        }
        ActivityDetailPlanModify entity = null;
        if (StringUtils.isNotEmpty(id)){
            entity = activityDetailPlanModifyRepository.getById(id);
        }else{
            entity = activityDetailPlanModifyRepository.getByCode(code);
        }
        if (null != entity) {
            ActivityDetailPlanModifyVo vo = nebulaToolkitService.copyObjectByWhiteList(entity, ActivityDetailPlanModifyVo.class, HashSet.class, ArrayList.class);
            //再查下大区方案关联的总部方案
            List<ActivityDetailPlanPlanVo> relatePlanList = activityDetailPlanPlanRepository.findListVoByDetailPlanCode(vo.getDetailPlanCode());
            vo.setRelatePlanList(relatePlanList);
            return vo;
        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submit(ActivityDetailPlanModifyApproveSubmitDto dto) {
        Validate.notNull(dto.getId(),"ID不能为空");
        ActivityDetailPlanModify entity = this.activityDetailPlanModifyRepository.getById(dto.getId());
        Validate.notNull(entity,"实例对象不存在！！");
        //待提交、驳回、追回的数据才能提交
        if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) &&
                !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) &&
                !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())){
            throw new RuntimeException("方案变更["+entity.getModifyBusinessCode()+"]不处于待提交、驳回、追回状态，不能提交审批！");
        }
        dto.setModifyBusinessCode(entity.getModifyBusinessCode());
        // 预占用预算
        activityDetailPlanBudgetModifyService.useMonthBudgetByModifyCode(entity.getModifyBusinessCode(),entity.getDetailPlanCode(),true);
        this.commitProcess(dto);
    }

    /**
     * 提交工作流进行审批，提交成功返回流程实例ID，提交失败则抛出异常
     */
    private void commitProcess(ActivityDetailPlanModifyApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull(processBusiness, "提交工作流时，未传工作流对象信息!");
        processBusiness.setBusinessNo(dto.getModifyBusinessCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(dto));
        processBusiness.setBusinessCode(ActivityDetailPlanConstant.PROCESS_NAME_ACTIVITY_DETAIL_PLAN_MODIFY);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        // 修改物料采购单状态
        pushChangeToMaterialPurchaseOrder(dto.getModifyBusinessCode());

        //提交成功
        activityDetailPlanModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyBusinessCode(),ProcessStatusEnum.COMMIT.getKey(),processBusinessVo.getProcessNo());

    }

    private void pushChangeToMaterialPurchaseOrder(String modifyBusinessCode) {
        ActivityDetailPlanModify entity = this.activityDetailPlanModifyRepository.getByCode(modifyBusinessCode);
        Validate.notNull(entity, "提交工作流时，未传工作流对象信息!");
        String detailPlanCode = entity.getDetailPlanCode();
        MaterialPurchasingEventDto eventDto = new MaterialPurchasingEventDto();
        eventDto.setActivityDetailPlanCode(detailPlanCode);
        eventDto.setModifyBusinessCode(modifyBusinessCode);
        eventDto.setProcessStatus(ProcessStatusEnum.COMMIT.getKey());
        SerializableBiConsumer<MaterialPurchasingOrderEventListener, MaterialPurchasingEventDto> onActivityDetailPlanModify =
                MaterialPurchasingOrderEventListener::onActivityDetailPlanModify;
        this.nebulaNetEventClient.publish(eventDto, MaterialPurchasingOrderEventListener.class, onActivityDetailPlanModify);
    }

    /**i
     * 流程审批通过
     * @param dto 流程数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processPass(ProcessStatusDto dto) {
        activityDetailPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(),dto.getProcessStatus());
        // 修改物料采购单状态
        ActivityDetailPlanModify entity = this.activityDetailPlanModifyRepository.getByCode(dto.getBusinessNo());
        Validate.notNull(entity, "提交工作流时，未传工作流对象信息!");
        MaterialPurchasingEventDto eventDto = new MaterialPurchasingEventDto();
        eventDto.setActivityDetailPlanCode(entity.getDetailPlanCode());
        eventDto.setModifyBusinessCode(entity.getModifyBusinessCode());
        eventDto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
        SerializableBiConsumer<MaterialPurchasingOrderEventListener, MaterialPurchasingEventDto> onActivityDetailPlanModify =
                MaterialPurchasingOrderEventListener::onActivityDetailPlanModify;
        this.nebulaNetEventClient.publish(eventDto, MaterialPurchasingOrderEventListener.class,onActivityDetailPlanModify);

    }
    /**
     * 流程审批追回/驳回
     * @param dto 流程数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processRejectAndRecover(ProcessStatusDto dto) {
        ActivityDetailPlanModify entity = activityDetailPlanModifyRepository.getByCode(dto.getBusinessNo());
        // 修改物料采购单状态
        Validate.notNull(entity, "提交工作流时，未传工作流对象信息!");
        MaterialPurchasingEventDto eventDto = new MaterialPurchasingEventDto();
        eventDto.setActivityDetailPlanCode(entity.getDetailPlanCode());
        eventDto.setProcessStatus(ProcessStatusEnum.REJECT.getKey());
        eventDto.setModifyBusinessCode(dto.getBusinessNo());
        SerializableBiConsumer<MaterialPurchasingOrderEventListener, MaterialPurchasingEventDto> onActivityDetailPlanModify =
                MaterialPurchasingOrderEventListener::onActivityDetailPlanModify;
        this.nebulaNetEventClient.publish(eventDto, MaterialPurchasingOrderEventListener.class,onActivityDetailPlanModify);

        activityDetailPlanBudgetModifyService.returnMonthBudgetByModifyCode(dto.getBusinessNo(),entity.getDetailPlanCode());
        activityDetailPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(),dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doUpdateOriginData(String businessNo) {
        ActivityDetailPlanModify modifyEntity = activityDetailPlanModifyRepository.getByCode(businessNo);
        Validate.notNull(modifyEntity,"活动细案变更审批通过，更据变更编码【"+businessNo+"】,未找到活动细案变更数据");
        List<ActivityDetailPlan> byDetailPlanCodeList = activityDetailPlanRepository.findByDetailPlanCodeList(Lists.newArrayList(modifyEntity.getDetailPlanCode()));
        Validate.notEmpty(byDetailPlanCodeList,"活动细案变更审批通过，更据变更编码【"+businessNo+"】,未找到对应的变更目标->活动细案数据");
        ActivityDetailPlan planEntity = byDetailPlanCodeList.get(0);

        //方案信息直接覆盖过去吧
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        List<String> ignoreFieldList = Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList());
        ignoreFieldList.add("processStatus");
        ignoreFieldList.add("processNo");
        String[] ignoreFieldArr = ignoreFieldList.toArray(new String[]{});
        BeanUtils.copyProperties(modifyEntity,planEntity,ignoreFieldArr);
        planEntity.setCurrModifyBusinessCode(modifyEntity.getModifyBusinessCode());
        activityDetailPlanRepository.updateById(planEntity);


        List<ActivityDetailPlanItemModify> itemModifyList = activityDetailPlanItemModifyRepository.findListByModifyBusinessCode(businessNo);
        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findListByDetailPlanCodeList(Lists.newArrayList(modifyEntity.getDetailPlanCode()));
        Map<String, ActivityDetailPlanItemModify> itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityDetailPlanItemModify::getDetailPlanItemCode, Function.identity()));
        for (ActivityDetailPlanItem activityPlanItem : itemList) {
            ActivityDetailPlanItemModify modifyItem = itemModifyMap.get(activityPlanItem.getDetailPlanItemCode());
            BeanUtils.copyProperties(modifyItem,activityPlanItem,ignoreFieldArr);
            activityPlanItem.setCurrModifyBusinessCode(modifyItem.getModifyBusinessCode());
        }
        activityDetailPlanItemRepository.updateBatchById(itemList);


        //关联方案也更新下
        activityDetailPlanPlanRepository.deleteByDetailPlanCode(planEntity.getDetailPlanCode());
        List<ActivityDetailPlanPlanModify> relatePlanModifyList = activityDetailPlanPlanModifyRepository.findListByModifyBusinessCode(businessNo);
        if (!CollectionUtils.isEmpty(relatePlanModifyList)){
            Collection<ActivityDetailPlanPlan> budgetShareList = nebulaToolkitService.copyCollectionByBlankList(relatePlanModifyList, ActivityDetailPlanPlanModify.class, ActivityDetailPlanPlan.class, HashSet.class, ArrayList.class);
            activityDetailPlanPlanRepository.saveBatch(budgetShareList);
        }

        //先退下减少的预算
        List<ActivityDetailPlanBudgetModify> budgetModifyList = activityDetailPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(businessNo));
        List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanCode(planEntity.getDetailPlanCode());
        activityDetailPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets,budgetModifyList);

        //预算也更新下
        activityDetailPlanBudgetRepository.deletePhysicalByDetailPlanCode(planEntity.getDetailPlanCode());
        if (!CollectionUtils.isEmpty(budgetModifyList)){
            Collection<ActivityDetailPlanBudget> budgetList = nebulaToolkitService.copyCollectionByBlankList(budgetModifyList, ActivityDetailPlanBudgetModify.class, ActivityDetailPlanBudget.class, HashSet.class, ArrayList.class);
            activityDetailPlanBudgetRepository.saveBatch(budgetList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passReturnMonthBudgetByModifyCode(String modifyBusinessCode) {
        ActivityDetailPlanModify modifyEntity = activityDetailPlanModifyRepository.getByCode(modifyBusinessCode);
        Validate.notNull(modifyEntity,"更据变更编码【"+modifyBusinessCode+"】,未找到细案变更信息");
        List<ActivityDetailPlan> byDetailPlanCodeList = activityDetailPlanRepository.findByDetailPlanCodeList(Lists.newArrayList(modifyEntity.getModifyBusinessCode()));
        Validate.notEmpty(byDetailPlanCodeList,"更据变更编码【"+modifyBusinessCode+"】,未找到变更目标->活动细案信息");
        ActivityDetailPlan planEntity = byDetailPlanCodeList.get(0);
        List<ActivityDetailPlanBudgetModify> budgetModifyList = activityDetailPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(modifyBusinessCode));
        List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanCode(planEntity.getDetailPlanCode());
        activityDetailPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets,budgetModifyList);
    }

    /**
     * 方案变更后自动变更细案
     * @param modifyBusinessCode 活动方案变更编码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void planModifyUpdateDetailPlan(String modifyBusinessCode) {
        ActivityPlanModifyVo planModifyVo = activityPlanModifySdkService.findByIdOrCode(null, modifyBusinessCode);
        Validate.notNull(planModifyVo,"方案变更后自动变更细案,更据活动方案变更编码【"+modifyBusinessCode+"】,未找到对应活动细案变更数据");

        //先查下有没有自动生成的细案
        List<ActivityDetailPlan> activityDetailPlanVoList = activityDetailPlanService.findByPlanCode(planModifyVo.getPlanCode());
        Validate.notEmpty(activityDetailPlanVoList,"方案变更后自动变更细案,更据活动方案变更编码【"+modifyBusinessCode+"】,未找到对应变更目标->活动细案数据");
        //应该只有一个的
        ActivityDetailPlan activityDetailPlan = activityDetailPlanVoList.get(0);
        //方案明细的变更
        List<ActivityPlanItemModifyDto> itemModifyList = activityPlanModifySdkService.findItemDtoAndAttachListByModifyCode(modifyBusinessCode);
        List<String> planItemCodeList = itemModifyList.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
        Map<String, ActivityPlanItemModifyDto> planItemMap = itemModifyList.stream().collect(Collectors.toMap(ActivityPlanItemModifyDto::getPlanItemCode, Function.identity()));

        //方案门店明细的变更
        List<ActivityPlanItemTerminalModifyDto> terminalModifyList = activityPlanModifySdkService.findTerminalListByModifyBusinessCode(modifyBusinessCode);

        //方案信息直接覆盖过去吧
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        String[] ignoreFieldArr = Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).toArray(String[]::new);

        ActivityDetailPlanItemDto itemDto = new ActivityDetailPlanItemDto();
        itemDto.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
        itemDto.setRelatePlanItemCodeList(planItemCodeList);
        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findList(itemDto);
        List<ActivityDetailPlanItem> updateActivityDetailPlanItems = new ArrayList<>();
        if (!CollectionUtils.isEmpty(terminalModifyList)){

            Map<String, ActivityPlanItemTerminalModifyDto> terminalEmployeeMap = terminalModifyList.stream().collect(Collectors.toMap(item -> {
                return item.getPlanItemCode()+item.getTerminalCode() + item.getEmployeeCode();
            }, Function.identity(), (o, n) -> n));

            //垂直促销人员变更
            List<String> existsKeyList = Lists.newArrayList();
            Map<String,ActivityDetailPlanItem> templateMap = Maps.newHashMap();
            for (ActivityDetailPlanItem activityDetailPlanItem : itemList) {
                ActivityPlanItemModifyDto activityPlanItemModifyDto = planItemMap.get(activityDetailPlanItem.getRelatePlanItemCode());
                if (null == activityPlanItemModifyDto){
                    continue;
                }
                String key = activityDetailPlanItem.getRelatePlanItemCode()+activityDetailPlanItem.getTerminalCode() + activityDetailPlanItem.getEmployeeCode();
                existsKeyList.add(key);

                ActivityPlanItemTerminalModifyDto terminalEmployee = terminalEmployeeMap.get(key);

                if (null != terminalEmployee){
                    ActivityPlanItemModifySelf activityPlanItemModifySelf = new ActivityPlanItemModifySelf();
                    BeanUtils.copyProperties(activityPlanItemModifyDto,activityPlanItemModifySelf);
                    BeanUtils.copyProperties(activityPlanItemModifySelf,activityDetailPlanItem);
                    BeanUtils.copyProperties(terminalEmployee,activityDetailPlanItem,ignoreFieldArr);
                    activityDetailPlanItem.setTotalFeeAmount(terminalEmployee.getAmount());
                    activityDetailPlanItem.setFeeAmount(terminalEmployee.getAmount());
                    activityDetailPlanItem.setActivityBeginDate(terminalEmployee.getBeginDate());
                    activityDetailPlanItem.setActivityEndDate(terminalEmployee.getEndDate());
                    activityDetailPlanItem.setNameOfShoppingGuide(terminalEmployee.getName());
                    activityDetailPlanItem.setTelephone(terminalEmployee.getPhone());
                    activityDetailPlanItem.setQuantity(Optional.ofNullable(terminalEmployee.getQuantity()).orElse(BigDecimal.ZERO).intValue());
                    updateActivityDetailPlanItems.add(activityDetailPlanItem);
                }
                templateMap.put(activityDetailPlanItem.getRelatePlanItemCode(),activityDetailPlanItem);
            }


            List<ActivityDetailPlanItem> activityDetailPlanItems = new ArrayList<>();
            List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = new ArrayList<>();
            List<ActivityDetailPlanItemExtendField> extendFieldSaveList = new ArrayList<>();

            for (Map.Entry<String, ActivityPlanItemTerminalModifyDto> entry : terminalEmployeeMap.entrySet()) {
                if (existsKeyList.contains(entry.getKey())) {
                    continue;
                }

                ActivityPlanItemTerminalModifyDto terminalModifyDto = entry.getValue();
                ActivityPlanItemModifyDto activityPlanItemModifyDto = planItemMap.get(terminalModifyDto.getPlanItemCode());
                if (null == activityPlanItemModifyDto) {
                    continue;
                }
                //1033120 【所有环境】垂直活动方案自动生成细案时，把费用金额是0的过滤掉，就不要生成细案了；门店分摊的时候分摊成0的也不要
                if (BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode())){
                    if(null == terminalModifyDto.getAmount() || terminalModifyDto.getAmount().compareTo(BigDecimal.ZERO) == 0){
                        continue;
                    }
                }
                ActivityDetailPlanItem templateItem = templateMap.get(terminalModifyDto.getPlanItemCode());
                ActivityDetailPlanItem activityDetailPlanItem = activityDetailPlanItemService.buildByActivityItemTerminal(activityDetailPlan,
                        activityPlanItemModifyDto,terminalModifyDto,
                        templateItem.getTemplateConfigCode(),null,extendFieldSaveList);
                activityDetailPlanItem.setId(null);
                activityDetailPlanItem.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
                activityDetailPlanItem.setActivityBeginDate(terminalModifyDto.getBeginDate());
                activityDetailPlanItem.setActivityEndDate(terminalModifyDto.getEndDate());
                activityDetailPlanItem.setNameOfShoppingGuide(terminalModifyDto.getName());
                activityDetailPlanItem.setTelephone(terminalModifyDto.getPhone());
                activityDetailPlanItem.setQuantity(Optional.ofNullable(terminalModifyDto.getQuantity()).orElse(BigDecimal.ZERO).intValue());
                if (StringUtils.isEmpty(activityDetailPlanItem.getCustomerCode())){
                    activityDetailPlanItem.setCustomerCode(templateItem.getCustomerCode());
                    activityDetailPlanItem.setCustomerName(templateItem.getCustomerName());
                }
                activityDetailPlanItems.add(activityDetailPlanItem);
            }

            if (!CollectionUtils.isEmpty(activityDetailPlanItems)){
                activityDetailPlanItemRepository.saveBatch(activityDetailPlanItems);
            }
            if (!CollectionUtils.isEmpty(extendFieldSaveList)){
                activityDetailPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
            }
        }else{
            for (ActivityDetailPlanItem activityDetailPlanItem : itemList) {
                //变更细案明细
                ActivityPlanItemModifyDto activityPlanItemModifyDto = planItemMap.get(activityDetailPlanItem.getRelatePlanItemCode());
                if (null == activityPlanItemModifyDto){
                    continue;
                }
                ActivityPlanItemModifySelf activityPlanItemModifySelf = new ActivityPlanItemModifySelf();
                BeanUtils.copyProperties(activityPlanItemModifyDto,activityPlanItemModifySelf);
                BeanUtils.copyProperties(activityPlanItemModifySelf,activityDetailPlanItem);
                updateActivityDetailPlanItems.add(activityDetailPlanItem);
            }
        }
        if (!CollectionUtils.isEmpty(updateActivityDetailPlanItems)){
            activityDetailPlanItemRepository.updateBatchById(updateActivityDetailPlanItems);
        }
    }

    private void backupInitVersionData(String detailPlanCode) {
        List<ActivityDetailPlan> noModifyList = activityDetailPlanRepository.list(
                Wrappers.<ActivityDetailPlan>lambdaQuery()
                        .eq(ActivityDetailPlan::getDetailPlanCode, detailPlanCode)
                        .and(w -> {
                            w.eq(ActivityDetailPlan::getHasModify, BooleanEnum.FALSE.getCapital());
                            w.or();
                            w.isNull(ActivityDetailPlan::getHasModify);
                        })
        );
        if (CollectionUtils.isEmpty(noModifyList)){
            //不是第一次变更，已经备份过了
            return;
        }
        ActivityDetailPlan planEntity = activityDetailPlanRepository.findByDetailPlanCodeList(Lists.newArrayList(detailPlanCode)).get(0);
        ActivityDetailPlanModify activityPlanModify = nebulaToolkitService.copyObjectByWhiteList(planEntity, ActivityDetailPlanModify.class, HashSet.class, ArrayList.class);
        activityDetailPlanModifyRepository.save(activityPlanModify);

        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findListByDetailPlanCodeList(Lists.newArrayList(detailPlanCode));
        List<ActivityDetailPlanItemModify> itemModifyList = (List<ActivityDetailPlanItemModify>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class);
        activityDetailPlanItemModifyRepository.saveBatch(itemModifyList);

        List<ActivityDetailPlanPlan> relatePlanList = activityDetailPlanPlanRepository.findListByDetailPlanCode(detailPlanCode);
        List<ActivityDetailPlanPlanModify> relatePlanModifyList = (List<ActivityDetailPlanPlanModify>) nebulaToolkitService.copyCollectionByBlankList(relatePlanList, ActivityDetailPlanPlan.class, ActivityDetailPlanPlanModify.class, HashSet.class, ArrayList.class);
        activityDetailPlanPlanModifyRepository.saveBatch(relatePlanModifyList);

        List<ActivityDetailPlanBudget> budgetList = activityDetailPlanBudgetRepository.listByDetailPlanCode(detailPlanCode);
        List<ActivityDetailPlanBudgetModify> budgetModifyList = (List<ActivityDetailPlanBudgetModify>) nebulaToolkitService.copyCollectionByBlankList(budgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetModify.class, HashSet.class, ArrayList.class);
        activityDetailPlanBudgetModifyRepository.saveBatch(budgetModifyList);

        activityDetailPlanRepository.update(
                Wrappers.<ActivityDetailPlan>lambdaUpdate()
                        .set(ActivityDetailPlan::getHasModify,BooleanEnum.TRUE.getCapital())
                        .eq(ActivityDetailPlan::getDetailPlanCode, detailPlanCode)
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        List<ActivityDetailPlanModify> entities = activityDetailPlanModifyRepository.listByIds(ids);
        for (ActivityDetailPlanModify entity : entities) {
            Validate.isTrue(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) ||
                            ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) ||
                            ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()),
                    "方案变更["+entity.getModifyBusinessCode()+"]不是待提交、驳回或追回状态，不能删除！");
        }
        activityDetailPlanModifyRepository.deleteIds(ids);
        List<String> modifyCodes = entities.stream().map(ActivityDetailPlanModify::getModifyBusinessCode).collect(Collectors.toList());
        activityDetailPlanPlanModifyService.deleteByModifyCodes(modifyCodes);
        activityDetailPlanItemModifyService.deleteByDetailModifyBusinessCodes(modifyCodes);
        activityDetailPlanBudgetModifyService.deleteByModifyCodes(modifyCodes);

        //删除业务日志
        Collection<ActivityDetailPlanModifyDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(entities,
                ActivityDetailPlanModify.class, ActivityDetailPlanModifyDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanModifyLogEventDto> onDelete =
                ActivityDetailPlanLogEventListener::onDeleteModify;
        for (ActivityDetailPlanModifyDto dto : dtoList) {
            ActivityDetailPlanModifyLogEventDto logEventDto = new ActivityDetailPlanModifyLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onDelete);
        }
    }

}
