package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanPlanModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.dto.ActivityDetailPlanPlanModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案-关联策略服务
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityDetailPlanPlanModifyServiceImpl implements ActivityDetailPlanPlanModifyService {

    @Autowired(required = false)
    private ActivityDetailPlanPlanModifyRepository activityDetailPlanPlanModifyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlanPlanList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanPlanModifyDto> relatePlanlist) {
        if (CollectionUtils.isEmpty(relatePlanlist)){
            return;
        }

        Map<String, ActivityDetailPlanPlanModify> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityDetailPlanPlanModify> oldList = activityDetailPlanPlanModifyRepository.findListByModifyBusinessCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityDetailPlanPlanModify::getId, Function.identity()));
        }
        List<ActivityDetailPlanPlanModify> activityPlanStrategies = (List<ActivityDetailPlanPlanModify>) nebulaToolkitService.copyCollectionByWhiteList(relatePlanlist, ActivityDetailPlanPlanModifyDto.class, ActivityDetailPlanPlanModify.class, HashSet.class, ArrayList.class);

        List<ActivityDetailPlanPlanModify> saveList = Lists.newArrayList();
        List<ActivityDetailPlanPlanModify> updateList = Lists.newArrayList();
        for (ActivityDetailPlanPlanModify item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityDetailPlanPlanModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityDetailPlanPlanModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityDetailPlanPlanModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        activityDetailPlanPlanModifyRepository.deleteByModifyCodes(modifyCodes);
    }
}
