package com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/8/10  16:34
 * @Description: TODO
 */
@Data
@CrmExcelExport
public class ActivityDetailPlanItemModifyExportsVo extends CrmExcelVo {

    /**
     * 活动细案明细编码
     */
    @CrmExcelColumn("活动细案明细编码")
    private String detailPlanItemCode;
    /**
     * 活动类型编码
     */
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    /**
     * 活动开始时间
     */
    @ExcelIgnore
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ExcelIgnore
    private Date activityEndDate;
    /**
     * 活动开始时间-字符串，前端用
     */
    @CrmExcelColumn("活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端用
     */
    @CrmExcelColumn("活动结束时间")
    private String activityEndDateStr;
    /**
     * 订单开始时间
     */
    @ExcelIgnore
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ExcelIgnore
    private Date orderEndDate;
    /**
     * 订单开始时间-字符串，前端用
     */
    @CrmExcelColumn("订单开始时间")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @CrmExcelColumn("订单结束时间")
    private String orderEndDateStr;

    /**
     * 总部预算编码
     */
    @CrmExcelColumn("总部统筹预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @CrmExcelColumn("总部预算项目编码")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @CrmExcelColumn("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区统筹预算编码
     */
    @CrmExcelColumn("大区统筹预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @CrmExcelColumn("大区预算项目编码")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @CrmExcelColumn("大区预算项目名称")
    private String budgetItemName;


    /**
     * 区域编码
     */
    @CrmExcelColumn("区域编码")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @CrmExcelColumn("区域名称")
    private String activityOrgName;

    /**
     * 一级管理渠道
     */
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;
    /**
     * 零售商编码
     */
    @CrmExcelColumn("零售商编码")
    private String systemCode;
    /**
     * 零售商名称
     */
    @CrmExcelColumn("零售商名称")
    private String systemName;
    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;
    /**
     * 月销售任务
     */
    @CrmExcelColumn("月销售任务")
    private BigDecimal monthSalesTarget;
    /**
     * 目前铺市率
     */
    @CrmExcelColumn("目前铺市率")
    private BigDecimal currentMarketRate;
    /**
     * 是否发起巡查需求
     */
    @CrmExcelColumn("是否发起巡查需求")
    private String isStartPatrol;
    /**
     * 期间促销量（件）
     */
    @CrmExcelColumn("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    /**
     * 期间渠道促销量（件）
     */
    @CrmExcelColumn("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @CrmExcelColumn("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @CrmExcelColumn("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @CrmExcelColumn("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比
     */
    @CrmExcelColumn("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    /**
     * 费用合计
     */
    @CrmExcelColumn("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 总部承担金额
     */
    @CrmExcelColumn("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @CrmExcelColumn("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 分子公司点内金额
     */
    @CrmExcelColumn("分子公司点内金额")
    private BigDecimal intraCompanyAmount;
    /**
     * 客户承担金额
     */
    @CrmExcelColumn("客户承担金额")
    private BigDecimal customerFeeAmount;

    @CrmExcelColumn("是否扣减费用池")
    private String isDeductionFeePool;
    /**
     * 核销类型
     */
    @CrmExcelColumn("核销类型")
    private String auditType;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @CrmExcelColumn("核销条件名称")
    private String auditConditionName;
    /**
     * 结案形式
     */
    @CrmExcelColumn("结案形式")
    private String auditForm;
    /**
     * 付款方式
     */
    @CrmExcelColumn("付款方式")
    private String paymentMethod;
    /**
     * 是否和价格有关
     */
    @CrmExcelColumn("是否和价格有关")
    private String relateToPrice;
    /**
     * 形式说明
     */
    @CrmExcelColumn("形式说明")
    private String formDescription;
    /**
     * 是否涨价政策
     */
    @CrmExcelColumn("是否涨价政策")
    private String increasePricePromotion;

    /**
     * 是否考核扣款
     */
    @CrmExcelColumn("是否考核扣款")
    private String deductType;

    /**
     * 是否责任利润调整
     */
    @CrmExcelColumn("是否责任利润调整")
    private String dutyProfitAdjust;
    /**
     * 促销对象
     */
    @CrmExcelColumn("促销对象")
    private String promotionObject;

    /**
     * 新品归类
     */
    @CrmExcelColumn("新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @CrmExcelColumn("是否占用划拨预算")
    private String occupyTransferBudget;

    /**
     * 人员编码
     */
    @CrmExcelColumn("人员编码")
    private String personCode;
    /**
     * 人员名称
     */
    @CrmExcelColumn("人员名称")
    private String personName;
    /**
     * 人员类型
     */
    @CrmExcelColumn("人员类型")
    private String personType;
    /**
     * 身份证号码
     */
    @CrmExcelColumn("身份证号码")
    private String personIdCard;
    /**
     * 电话
     */
    @CrmExcelColumn("电话")
    private String telephone;
}
