package com.biz.crm.tpm.business.activity.detail.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class ActivityDetailPlanDataViewRegister implements MnDataviewRegister {

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    @Qualifier("inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    
    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Override
    public String code() {
        return "tpm_activity_detail_plan_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动细案";
    }

    @Override
    public String buildSql() {
        return "select\n" +
                "a.*,'' as parent_department_name,\n" +
                "'' as detail_plan_item_code,\n" +
                "'' as relate_plan_code\n" +
                " from tpm_activity_detail_plan a\n" +
                "where a.tenant_code = :tenantCode\n" +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)) {
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if (ActivityDetailPlanExecuteParameterBuildInterceptor.parent_department_name.equals(databaseExecuteParameter.getTargetFieldName())) {
            return parentDepartmentNameQuery(databaseExecuteParameter, valueStr);
        }else if (ActivityDetailPlanExecuteParameterBuildInterceptor.detail_plan_item_code.equals(databaseExecuteParameter.getTargetFieldName())) {
            return detailPlanItemQuery(databaseExecuteParameter, valueStr);
        }else if (ActivityDetailPlanExecuteParameterBuildInterceptor.relate_plan_code.equals(databaseExecuteParameter.getTargetFieldName())) {
            return relatePlanCodeQuery(databaseExecuteParameter, valueStr);
        }
        return valueStr;
    }

    private Object parentDepartmentNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "department_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> orgCodeList = Lists.newArrayList("_");
        //上级组织查询
        OrgQueryDto orgQueryDto = new OrgQueryDto();
        orgQueryDto.setOrgName(valueStr);
        Set<String> parentCodeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        if (CollectionUtils.isEmpty(parentCodeSet)) {
            return orgCodeList;
        }
        orgQueryDto.setOrgName(null);
        List<String> parentOrgCodeList = Lists.newArrayList(parentCodeSet);
        orgQueryDto.setParentOrgCodeList(parentOrgCodeList);
        Set<String> codeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        orgCodeList.addAll(codeSet);
        return orgCodeList;
    }

    private Object relatePlanCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "detail_plan_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据关联方案编码查询细案编码
        List<String> planCodeList = Lists.newArrayList("_");
        planCodeList.addAll(activityDetailPlanBudgetRepository.findDetailPlanCodeListByRelatePlanCodeList(Arrays.asList(valueStr.split("[, ，]"))));
        return planCodeList;
    }

    private Object detailPlanItemQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "detail_plan_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据细案明细编码查询细案编码
        List<String> planCodeList = Lists.newArrayList("_");
        planCodeList.addAll(activityDetailPlanItemRepository.findDetailPlanCodeListByItemCodeList(Arrays.asList(valueStr.split("[, ，]"))));
        return planCodeList;
    }

}
