package com.biz.crm.tpm.business.activity.detail.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import javax.persistence.Column;
import java.lang.reflect.Field;
import java.util.List;

/**
 * 活动细案(ActivityDetailPlan)数据视图注册器
 *
 * @author xiaoyoujun
 * @since
 */
@Component
public class ActivityDetailReportDataViewRegister implements DataviewRegister {

    private List<String> extendTableFieldList = null;
    @Override
    public String code() {
        return "tpm_activity_detail_report_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动细案报表";
    }

    @Override
    public String buildSql() {
        StringBuilder extendTableFieldBuilder = new StringBuilder();
        List<String> extendTableFieldList = getExtendTableFieldList();
        for (String extendTableField : extendTableFieldList) {
            extendTableFieldBuilder.append("be.").append(extendTableField).append("\n,");
        }
        return "select " +
//            "a.detail_plan_code, " +
                "a.detail_plan_name, " +
//            "a.business_format_code, " +
//            "a.business_unit_code, " +
//            "a.fee_amount, " +
                "a.is_temporary, " +
                "a.department_code, " +
                "a.department_name, " +
                extendTableFieldBuilder +
                "b.*\n" +
                "from tpm_activity_detail_plan a\n" +
                "left join tpm_activity_detail_plan_item b on a.detail_plan_code = b.detail_plan_code\n" +
                "left join tpm_activity_detail_plan_item_extend be on be.detail_plan_code = b.detail_plan_code and be.detail_plan_item_code = b.detail_plan_item_code\n" +
                "where a.tenant_code = :tenantCode\n" +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'\n" +
                "and b.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'\n";
    }

    public synchronized List<String> getExtendTableFieldList() {
        if (null == this.extendTableFieldList){
            List<String> tableFieldList = Lists.newArrayList();
            Field[] declaredFields = ActivityDetailPlanItemExtend.class.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                Column column = declaredField.getDeclaredAnnotation(Column.class);
                if (null == column){
                    continue;
                }
                tableFieldList.add(column.name());
            }
            List<String> excludeFieldList = Lists.newArrayList("id","tenant_code","detail_plan_code","detail_plan_item_code");
            tableFieldList.removeAll(excludeFieldList);
            this.extendTableFieldList = tableFieldList;
        }
        return this.extendTableFieldList;
    }
}
