package com.biz.crm.tpm.business.activity.detail.plan.local.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.LargeDateCallbackDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.LargeDateCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.LargeDateCallbackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: yaoyongming
 * @date: 2023/8/21 15:41
 */
@RestController
@RequestMapping("/v1/largeDateCallback")
@Slf4j
@Api(tags = "大日期回报率")
public class LargeDateCallbackController {

    @Autowired(required = false)
    private LargeDateCallbackService largeDateCallbackService;

    /**
     * 大日期回报率
     *
     * @param pageable 分页对象
     * @param largeDateCallbackDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "大日期回报率查询")
    @GetMapping("findAllConditions")
    public Result<Page<LargeDateCallbackVo>> findAllConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "largeDateCallbackDto", value = "查询实体") LargeDateCallbackDto largeDateCallbackDto) {
        try {
            Page<LargeDateCallbackVo> page =  this.largeDateCallbackService.findAllConditions(pageable, largeDateCallbackDto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
