package com.biz.crm.tpm.business.activity.detail.plan.local.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 行销费用批复表
 *
 * @author xiaoyoujun
 * @since
 */
@RestController
@RequestMapping("/v1/marketingApproval")
@Slf4j
@Api(tags = "行销费用批复表")
public class MarketingApprovalController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private MarketingApprovalService marketingApprovalService;

    /**
     * 行销费用批复表
     *
     * @param pageable 分页对象
     * @param marketingApprovalDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "行销费用批复表")
    @GetMapping("findAllConditions")
    public Result<Page<MarketingApprovalVo>> findAllConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "marketingApprovalDto", value = "查询实体") MarketingApprovalDto marketingApprovalDto) {
        try {
            Page<MarketingApprovalVo> page =  this.marketingApprovalService.findAllConditions(pageable,marketingApprovalDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
