package com.biz.crm.tpm.business.activity.detail.plan.local.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.service.SalesApprovalAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 销售费用批复表
 *
 * @author xiaoyoujun
 * @since
 */
@RestController
@RequestMapping("/v1/salesApproval")
@Slf4j
@Api(tags = "销售费用批复表")
public class SalesApprovalController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private SalesApprovalAsyncService salesApprovalAsyncService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 销售费用批复表
     *
     * @param pageable 分页对象
     * @param salesApprovalDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "销售费用批复表")
    @GetMapping("findAllConditions")
    public Result<Page<SalesApprovalVo>> findAllConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                           @ApiParam(name = "salesApprovalDto", value = "查询实体") SalesApprovalDto salesApprovalDto) {
        try {
            Page<SalesApprovalVo> page =  this.salesApprovalService.findAllConditions(pageable,salesApprovalDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动费用批复表数据生成
     */
    @ApiOperation(value = "活动费用批复表数据生成")
    @PostMapping("updateActivityApprovalData")
    public Result<?> updateActivityApprovalData(@RequestBody UpdateActivityApprovalDataDto dto) {
        try {
            UserIdentity userIdentity = this.loginUserService.getLoginUser();
            this.salesApprovalAsyncService.updateActivityApprovalDataAsync(dto,userIdentity);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 销售费用批复表
     */
    @ApiOperation(value = "销售费用批复表自定义分页")
    @GetMapping("findAllConditionsOtherPage")
    public Result<Page<SalesApprovalVo>> findAllConditionsOtherPage(Integer page,Integer size,
                                                           @ApiParam(name = "salesApprovalDto", value = "查询实体") SalesApprovalDto salesApprovalDto) {
        try {
            Pageable pageable = PageRequest.of(page, size);
            Page<SalesApprovalVo> pageInfo =  this.salesApprovalService.findAllConditions(pageable,salesApprovalDto);
            return Result.ok(pageInfo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
