package com.biz.crm.tpm.business.activity.detail.plan.local.report.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案批复表细案信息
 *
 * @author wanghaojia
 * @date 2023/7/14 17:27
 */
@ApiModel(value = "ActivityDetailPlanApprovalAuditMonth", description = "活动细案批复表细案信息")
@TableName("tpm_activity_detail_plan_approval_activity_info")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_approval_activity_info")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_approval_activity_info", comment = "活动细案批复表细案信息")
@Table(
        name = "tpm_activity_detail_plan_approval_activity_info",
        indexes = {
                @Index(name = "tpm_activity_detail_plan_approval_activity_info_inx1", columnList = "detail_plan_item_code", unique = true),
                @Index(name = "tpm_activity_detail_plan_approval_activity_info_inx3", columnList = "detail_plan_code"),
//                @Index(name = "tpm_activity_detail_plan_approval_activity_info_inx2", columnList = "template_config_code"),
                @Index(name = "tpm_activity_detail_plan_approval_activity_info_inx4", columnList = "department_code"),
                @Index(name = "activity_detail_plan_approval_audit_info_tenant", columnList = "tenant_code")
        }
)
public class ActivityDetailPlanApprovalActivityInfo extends TenantFlagOpEntity {

    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;

    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("关联方案编码")
    @Column(name = "relate_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '关联方案编码'")
    private String relatePlanCode;

    @ApiModelProperty("关联方案明细编码")
    @Column(name = "relate_plan_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '关联方案明细编码'")
    private String relatePlanItemCode;

    /**
     * 是否临时方案
     */
    @ApiModelProperty("是否临时方案")
    @Column(name = "is_temporary", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否临时方案，   Y是N否'")
    private String isTemporary;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '部门编码'")
    private String departmentCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门名称")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "varchar(1024) COMMENT '方案结束时间'")
    private String departmentName;

    @ApiModelProperty("活动细案名称")
    @Column(name = "detail_plan_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '总部批复文件编码'")
    private String detailPlanName;

    @ApiModelProperty("客户类型")
    @Column(name = "customer_type_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '客户类型'")
    private String customerTypeName;

    @ApiModelProperty("大区")
    @Column(name = "region", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '客户类型'")
    private String region;

    @ApiModelProperty("是否20门店")
    @Column(name = "whether_twenty_terminal", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '是否20门店'")
    private String whetherTwentyTerminal;

    @ApiModelProperty("总部中心")
    @Column(name = "headquarters_department_belong_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '总部中心'")
    private String headquartersDepartmentBelongCode;

    @ApiModelProperty("大区中心")
    @Column(name = "region_department_belong_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '大区中心'")
    private String regionDepartmentBelongCode;

    @ApiModelProperty("预算归属业态")
    @Column(name = "business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算归属业态'")
    private String businessCode;

    @ApiModelProperty("RTM模式")
    @Column(name = "rtm_model_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'RTM模式'")
    private String rtmModelCode;

    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '方案编码'")
    private String planCode;

    @ApiModelProperty("方案名称")
    @Column(name = "plan_name", nullable = true, length = 2048, columnDefinition = "varchar(2048) COMMENT '方案名称'")
    private String planName;

    @ApiModelProperty("大区批复文件编码")
    @Column(name = "regional_file_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区批复文件编码'")
    private String regionalFileCode;

    @ApiModelProperty("大区批复文件名称")
    @Column(name = "regional_file_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '大区批复文件名称'")
    private String regionalFileName;

    @ApiModelProperty("总部批复文件编码")
    @Column(name = "headquarters_file_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '总部批复文件编码'")
    private String headquartersFileCode;

    @ApiModelProperty("总部批复文件名称")
    @Column(name = "headquarters_file_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '总部批复文件名称'")
    private String headquartersFileName;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("模板编码")
    @Column(name = "template_config_code", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '模板编码'")
    private String templateConfigCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "总部预算编码", notes = "")
    @Column(name = "head_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String headMonthBudgetCode;

    /**
     * 预算编码名称
     */
    @ApiModelProperty(value = "总部预算名称", notes = "")
    @Column(name = "head_month_budget_name", length = 255, columnDefinition = "varchar(255) COMMENT '总部预算名称'")
    private String headMonthBudgetName;

    /**
     * 大区预算编码
     */
    @ApiModelProperty(value = "预算编码/大区预算编码", notes = "")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;

    /**
     * 大区预算名称
     */
    @ApiModelProperty(value = "预算编码/大区预算编码名称", notes = "")
    @Column(name = "month_budget_name", length = 255, columnDefinition = "varchar(255) COMMENT '大区预算名称'")
    private String monthBudgetName;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 目前铺市率
     */
    @ApiModelProperty("目前铺市率")
    @Column(name = "current_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '目前铺市率'")
    private BigDecimal currentMarketRate;
    /**
     * 月目标铺市率
     */
    @ApiModelProperty("月目标铺市率")
    @Column(name = "month_target_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '月目标铺市率'")
    private BigDecimal monthTargetMarketRate;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;


    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "activity_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String activityOrgName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgErpCode;
    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    @Column(name = "head_budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '总部预算项目名称'")
    private String headBudgetItemName;

    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算项目编码'")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @Column(name = "budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '大区预算项目名称'")
    private String budgetItemName;

    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    @Column(name = "is_start_patrol", length = 32, columnDefinition = "varchar(32) COMMENT '是否发起巡查需求'")
    private String isStartPatrol;

    /**
     * 月销售任务
     */
    @ApiModelProperty("月销售任务")
    @Column(name = "month_sales_target", length = 24, columnDefinition = "decimal(24,6) COMMENT '月销售任务'")
    private BigDecimal monthSalesTarget;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 30, columnDefinition = "varchar(30) COMMENT '核销类型'")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @Column(name = "product_quantity", length = 32, columnDefinition = "int(11) COMMENT '原品数量'")
    private Integer productQuantity;

    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @Column(name = "gift_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品名称'")
    private String giftName;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_quantity", length = 32, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer giftQuantity;

    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    @CrmExcelColumn(value = "形式说明")
    @Column(name = "form_description", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '形式说明'")
    private String formDescription;

    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderEndDate;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    @Column(name = "price", length = 32, columnDefinition = "varchar(32) COMMENT '陈列类型'")
    private BigDecimal price;

    /**
     * 期间促销量（件）
     */
    @ApiModelProperty("期间促销量（件）")
    @Column(name = "period_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销量（件）'")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    @Column(name = "period_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销额（元）'")
    private BigDecimal periodPromoteAmount;

    /**
     * 期间渠道促销量（件）
     */
    @ApiModelProperty("期间渠道促销量（件）")
    @Column(name = "period_ch_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销量（件）'")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @ApiModelProperty("期间渠道促销额（元）")
    @Column(name = "period_ch_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销额（元）'")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @ApiModelProperty("全月回复量（件）")
    @Column(name = "month_return_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复量（件）'")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @ApiModelProperty("全月回复额（元）")
    @Column(name = "month_return_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复额（元）'")
    private BigDecimal monthReturnAmount;

    /**
     * 本月投入产出比
     */
    @ApiModelProperty("本月投入产出比")
    @Column(name = "month_put_output_ratio", length = 24, columnDefinition = "decimal(24,6) COMMENT '本月投入产出比'")
    private BigDecimal monthPutOutputRatio;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品价格")
    @Column(name = "gift_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '赠品价格'")
    private BigDecimal giftPrice;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    @CrmExcelColumn(value = "是否涨价政策")
    @Column(name = "increase_price_promotion", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否涨价政策'")
    private String increasePricePromotion;


    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    @Column(name = "duty_profit_adjust", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否责任利润调整'")
    private String dutyProfitAdjust;

    /**
     * 新品归类
     */
    @ApiModelProperty("新品归类")
    @Column(name = "new_product_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '新品归类'")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    @Column(name = "occupy_transfer_budget", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否占用划拨预算'")
    private String occupyTransferBudget;

    @ApiModelProperty("是否扣减费用池")
    @Column(name = "is_deduction_fee_pool", length = 255, columnDefinition = "varchar(16) COMMENT '是否扣减费用池'")
    private String isDeductionFeePool;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;

    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '零售商名称'")
    private String systemName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionErpCode;
    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @Column(name = "intra_company_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点内金额'")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @Column(name = "off_point_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点外金额'")
    private BigDecimal offPointAmount;

    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    @Column(name = "is_close", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭，   Y是N否'")
    private String isClose;

    /**
     * 承接类型编码 字典编码 accept_type
     */
    @ApiModelProperty("活动承接形式")
    @Column(name = "undertaking_mode", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动承接形式'")
    private String undertakingMode;

    /**
     * 批复表类型
     */
    @ApiModelProperty("批复表类型")
    @Column(name = "approval_report_type", length = 1, columnDefinition = "VARCHAR(1) COMMENT '批复表类型  1销售2行销'")
    private String approvalReportType;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "this_product_production_date", length = 20, columnDefinition = "datetime COMMENT '本品生产日期 '")
    private Date thisProductProductionDate;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    @Column(name = "is_big_date", columnDefinition = "varchar(1) COMMENT '是否大日期'")
    private String isBigDate;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @Column(name = "big_date_qty", length = 24, columnDefinition = "decimal(24,6) COMMENT '大日期盘点数量'")
    private BigDecimal bigDateQty;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    @Column(name = "recipient_address", length = 256, columnDefinition = "VARCHAR(256) COMMENT '收货地址'")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    @Column(name = "recipient_contacts", length = 64, columnDefinition = "VARCHAR(64) COMMENT '收货联系人'")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    @Column(name = "recipient_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '收货联系电话'")
    private String recipientPhone;

}
