package com.biz.crm.tpm.business.activity.detail.plan.local.report.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动细案批复表结案月份信息
 *
 * @author wanghaojia
 * @date 2023/7/14 17:27
 */
@ApiModel(value = "ActivityDetailPlanApprovalAuditMonth", description = "活动细案批复表结案月份信息")
@TableName("tpm_activity_detail_plan_approval_audit_info")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_approval_audit_info")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_approval_audit_info", comment = "活动细案批复表结案月份信息")
@Table(
        name = "tpm_activity_detail_plan_approval_audit_info",
        indexes = {
                @Index(name = "activity_detail_plan_approval_audit_info_inx1", columnList = "detail_plan_item_code,audit_year_month", unique = true),
                @Index(name = "activity_detail_plan_approval_audit_info_tenant", columnList = "tenant_code")
        }
)
public class ActivityDetailPlanApprovalAuditInfo extends TenantEntity {

    @Column(name = "audit_year_month", nullable = true, length = 19, columnDefinition = "varchar(19) COMMENT '结案年月'")
    private String auditYearMonth;

    @Column(name = "detail_plan_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '细案明细编码'")
    private String detailPlanItemCode;


    @Column(name = "audit_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '预核销金额（元）'")
    private BigDecimal auditAmount;

    @Column(name = "this_audit_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '已结案金额（元）'")
    private BigDecimal thisAuditAmount;

    @Column(name = "whole_audit", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    @Column(name = "discount_tax_rate", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '折扣税率'")
    private String discountTaxRate;

    @Column(name = "discount_tax_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '折扣应处理金额（元）'")
    private BigDecimal discountTaxAmount;

    @Column(name = "discount_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '入费用池金额（元）'")
    private BigDecimal discountAmount;

    @Column(name = "reimburse_tax_rate", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '报销税率'")
    private String reimburseTaxRate;

    @Column(name = "reimburse_tax_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '报销金额(含税)（元）'")
    private BigDecimal reimburseTaxAmount;

    @Column(name = "reimburse_amount", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '报销金额(未税)（元）'")
    private BigDecimal reimburseAmount;

    @Column(name = "tax_quota", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '税额（元）'")
    private BigDecimal taxQuota;

    @Column(name = "reimburse_item", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '报销项目编码'")
    private String reimburseItem;

    @Column(name = "reimburse_item_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '报销项目名称'")
    private String reimburseItemName;

    @Column(name = "individual_income_tax", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6)  COMMENT '个人所得税金额（元）'")
    private BigDecimal individualIncomeTax;

    @Column(name = "is_special_ticket", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否专票'")
    private String isSpecialTicket;

    @Column(name = "cost_center", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '成本中心编码'")
    private String costCenter;

    @Column(name = "cost_center_name", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '成本中心名称'")
    private String costCenterName;

    @Column(name = "profit_center", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '利润中心编码'")
    private String profitCenter;

    @Column(name = "profit_center_name", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '利润中心名称'")
    private String profitCenterName;

    @Column(name = "is_push_sap", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否上帐'")
    private String isPushSap;

    @Column(name = "end_case_head_fee_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '结案总是承担金额（元） '")
    private BigDecimal endCaseHeadFeeAmount;

    @Column(name = "end_case_department_fee_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '结案大区承担金额（元） '")
    private BigDecimal endCaseDepartmentFeeAmount;

    @Column(name = "end_case_customer_fee_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '结案客户承担金额（元） '")
    private BigDecimal endCaseCustomerFeeAmount;

    @Column(name = "end_case_intra_company_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '结案分子公司点内金额（元） '")
    private BigDecimal endCaseIntraCompanyAmount;

    @Column(name = "end_case_off_point_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '结案分子公司点外金额（元） '")
    private BigDecimal endCaseOffPointAmount;

    @Column(name = "invoice_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '发票代码'")
    private String invoiceCode;

    @Column(name = "invoice_number", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '发票号码'")
    private String invoiceNumber;

    @Column(name = "audit_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '核销编码'")
    private String auditCode;

    @Column(name = "audit_detail_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '核销明细编码'")
    private String auditDetailCode;

    @Column(name = "up_account_status", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '折扣上帐状态'")
    private String upAccountStatus;

    @Column(name = "reimburse_up_account_status", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '报销上账状态'")
    private String reimburseUpAccountStatus;

    @Column(name = "belnr", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '报销上账会计凭证号'")
    private String belnr;

    @Column(name = "belnr2", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT ''")
    private String belnr2;

}
