package com.biz.crm.tpm.business.activity.detail.plan.local.report.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

/**
 * 活动细案批复表数据更新任务
 */
@Slf4j
@Service
public class ActivityDetailPlanApprovalInfoXxlJob {


    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private LoginUserService loginUserService;
    /**
     * 活动细案批复表数据更新任务 每天自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 2 * * ?", taskDesc = "活动细案批复表数据更新任务")
    public void autoSyncXxlJob() {
        log.info("=====>    活动细案批复表数据更新任务[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        UpdateActivityApprovalDataDto updateActivityApprovalDataDto = new UpdateActivityApprovalDataDto();
        Calendar instance = Calendar.getInstance();
        instance.add(Calendar.DATE,-7);
        updateActivityApprovalDataDto.setUpdateDate(DateUtil.getDateStrByFormat(instance.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        updateActivityApprovalDataDto.setAddDay(8);
        salesApprovalService.updateActivityApprovalData(updateActivityApprovalDataDto);
        log.info("=====>    活动细案批复表数据更新任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }

}
