package com.biz.crm.tpm.business.activity.detail.plan.local.report.register;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author wanghaojia
 * @date 2023/7/19 16:03
 */
@Component
public class SalesApprovalDataViewRegister implements DataviewRegister {


    @Override
    public String code() {
        return "tpm_sales_approval_data_view";
    }

    @Override
    public String desc() {
        return "TPM-销售费用批复表";
    }

    @Override
    public String buildSql() {
        return "select\n" +
                "        t1.*,\n" +
                "        t3.audit_year_month,\n" +
                "        t3.audit_amount,\n" +
                "        t3.this_audit_amount,\n" +
                "        t3.whole_audit,\n" +
                "        t3.discount_tax_rate,\n" +
                "        t3.discount_tax_amount,\n" +
                "        t3.discount_amount,\n" +
                "        t3.reimburse_tax_rate,\n" +
                "        t3.reimburse_tax_amount,\n" +
                "        t3.reimburse_amount,\n" +
                "        t3.tax_quota,\n" +
                "        t3.reimburse_item,\n" +
                "        t3.reimburse_item_name,\n" +
                "        t3.individual_income_tax,\n" +
                "        t3.is_special_ticket,\n" +
                "        t3.cost_center,\n" +
                "        t3.cost_center_name,\n" +
                "        t3.profit_center,\n" +
                "        t3.profit_center_name,\n" +
                "        t3.is_push_sap,\n" +
                "        t3.end_case_head_fee_amount,\n" +
                "        t3.end_case_department_fee_amount,\n" +
                "        t3.end_case_customer_fee_amount,\n" +
                "        t3.end_case_intra_company_amount,\n" +
                "        t3.end_case_off_point_amount,\n" +
                "        t3.invoice_code,\n" +
                "        t3.invoice_number,\n" +
                "        t3.audit_code,\n" +
                "        t3.audit_detail_code,\n" +
                "        t3.up_account_status,\n" +
                "        t3.reimburse_up_account_status,\n" +
                "        t3.belnr,\n" +
                "        t3.belnr2\n" +
                "from tpm_activity_detail_plan_approval_activity_info t1\n" +
                "left join tpm_activity_detail_plan_approval_audit_info t3 on t3.detail_plan_item_code = t1.detail_plan_item_code\n" +
                "where t1.approval_report_type = 1\n";
    }

}
