package com.biz.crm.tpm.business.activity.detail.plan.local.report.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.LargeDateCallbackDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalActivityInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.mapper.ActivityDetailPlanApprovalActivityInfoMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.LargeDateCallbackVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/7/16 17:26
 */
@Component
public class ActivityDetailPlanApprovalActivityInfoRepository extends ServiceImpl<ActivityDetailPlanApprovalActivityInfoMapper, ActivityDetailPlanApprovalActivityInfo> {

    public Page<SalesApprovalVo> findPsmConditions(Pageable pageable, SalesApprovalDto salesApprovalDto) {
        Page<SalesApprovalVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return baseMapper.findPsmConditions(page,salesApprovalDto);
    }


    public Page<LargeDateCallbackVo> findLargeDateCallabckList(Pageable pageable,SalesApprovalDto salesApprovalDto) {
        Page<LargeDateCallbackVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return baseMapper.findLargeDateCallabckList(page,salesApprovalDto);
    }

    public List<SalesApprovalVo> findPsmList(SalesApprovalDto salesApprovalDto) {
        return baseMapper.findPsmList(salesApprovalDto);
    }
    public Page<MarketingApprovalVo> findPsmMarketingConditions(Pageable pageable, MarketingApprovalDto marketingApprovalDto) {
        Page<MarketingApprovalVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return baseMapper.findPsmMarketingConditions(page,marketingApprovalDto);
    }

    public List<SalesApprovalVo> getUpdateActivityApprovalData(UpdateActivityApprovalDataDto dto) {
//        Integer pageSize = Integer.valueOf(dto.getPageSize());
//        Integer pageNum = Integer.parseInt(dto.getPageNum());
//        dto.setOffset(pageSize * pageNum);
//        dto.setLimit(pageSize);
        return baseMapper.getUpdateActivityApprovalData(dto);
    }

    public void deleteByDetailPlanItemCodeList(List<String> detailPlanItemCodeList) {
        this.lambdaUpdate()
                .in(ActivityDetailPlanApprovalActivityInfo::getDetailPlanItemCode,detailPlanItemCodeList)
                .eq(ActivityDetailPlanApprovalActivityInfo::getTenantCode, TenantUtils.getTenantCode())
                .remove()
        ;
    }

    public void updateTenantOp(List<String> detailPlanItemCodeList) {
        baseMapper.updateTenantOp(detailPlanItemCodeList);
    }

}
