package com.biz.crm.tpm.business.activity.detail.plan.local.report.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalActivityInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalAuditInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.mapper.ActivityDetailPlanApprovalAuditInfoMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ApprovalReportAudit;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * 活动细案批复表结案月份信息
 *
 * @author wanghaojia
 * @date 2023/7/14 17:27
 */
@Component
public class ActivityDetailPlanApprovalAuditInfoRepository extends ServiceImpl<ActivityDetailPlanApprovalAuditInfoMapper, ActivityDetailPlanApprovalAuditInfo> {

    public List<String> findApprovalReportAuditDetailPlanItemCodeList(ApprovalReportAudit dto) {
        if (StringUtils.isEmpty(dto.getUpdateDate())){
            //只有根据时间更新的时候才根据销更新时间查细案明细编码
            return Lists.newArrayList();
        }
        return baseMapper.findApprovalReportAuditDetailPlanItemCodeList(dto);
    }

    public List<ApprovalReportAudit> findApprovalReportAuditInfoList(List<String> detailPlanItemCodeList) {
        if (CollectionUtil.isEmpty(detailPlanItemCodeList)) {
            return Lists.newArrayList();
        }
        return baseMapper.findApprovalReportAuditInfoList(detailPlanItemCodeList);
    }


    public void deleteByDetailPlanItemCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtil.isEmpty(detailPlanItemCodeList)) {
            return;
        }
        this.lambdaUpdate()
                .in(ActivityDetailPlanApprovalAuditInfo::getDetailPlanItemCode,detailPlanItemCodeList)
                .eq(ActivityDetailPlanApprovalAuditInfo::getTenantCode, TenantUtils.getTenantCode())
                .remove();
    }

}
