package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.LargeDateCallbackDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.LargeDateCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.LargeDateCallbackVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/8/21 16:09
 */
@Slf4j
@Service("largeDateCallbackServiceImpl")
public class LargeDateCallbackServiceImpl implements LargeDateCallbackService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;

    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    /**
     * 大日期回调率报表
     *
     * @param pageable             分页对象
     * @param largeDateCallbackDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<LargeDateCallbackVo> findAllConditions(Pageable pageable, LargeDateCallbackDto largeDateCallbackDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(largeDateCallbackDto)) {
            largeDateCallbackDto = new LargeDateCallbackDto();
        }
        //年月默认为当前年月
        if (null == largeDateCallbackDto.getYearMonthLy()) {
            largeDateCallbackDto.setYearMonthLy(DateUtil.format(new Date(), "yyyy-MM"));
        }

        SalesApprovalDto salesApprovalDto = nebulaToolkitService.copyObjectByBlankList(largeDateCallbackDto, SalesApprovalDto.class, HashSet.class, ArrayList.class);
        Page<LargeDateCallbackVo> page = activityDetailPlanApprovalActivityInfoRepository.findLargeDateCallabckList(pageable,salesApprovalDto);
        //
        List<LargeDateCallbackVo> records = page.getRecords();
        if (!CollectionUtils.isEmpty(records)){
            setPeriodSale(records);
            BigDecimal bigDecimal100 = new BigDecimal(100);
            for (LargeDateCallbackVo e : records) {
                if (e.getPeriodSale() != null && BigDecimal.ZERO.compareTo(e.getPeriodSale()) != 0) {
                    e.setCallbackRate(e.getBigDateQty().multiply(bigDecimal100).divide(e.getPeriodSale(), 4, BigDecimal.ROUND_HALF_UP)+"%");
                } else {
                    e.setCallbackRate("100%");
                }
            }
        }
        return page;
    }

    private void setPeriodSale(List<LargeDateCallbackVo> records){
        //按业态业务单元分个组
        Map<String, List<LargeDateCallbackVo>> groupMap = records.stream().collect(Collectors.groupingBy(item -> item.getYearMonthLy()+item.getBusinessFormatCode() + item.getBusinessUnitCode()));
        for (Map.Entry<String, List<LargeDateCallbackVo>> entry : groupMap.entrySet()) {
            List<LargeDateCallbackVo> list = entry.getValue();
//            期间销售量：在主体日销售数据中，根据产品日期对应的年月取该客户的该产品的销量数据
            List<String> customerCodeList = list.stream().map(LargeDateCallbackVo::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());;
            List<String> productCodeList = list.stream().map(LargeDateCallbackVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());;
            if (!CollectionUtils.isEmpty(customerCodeList) && !CollectionUtils.isEmpty(productCodeList)){
                LargeDateCallbackVo largeDateCallbackVo = list.get(0);
                MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto.setYearMonthLy(largeDateCallbackVo.getYearMonthLy().replace("-",""));
                mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
                mainOnedaySalesDataDto.setBusinessFormatCode(largeDateCallbackVo.getBusinessFormatCode());
                mainOnedaySalesDataDto.setBusinessUnitCode(largeDateCallbackVo.getBusinessUnitCode());
                List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.listMainOnedaySalesDataForMonthBudget(mainOnedaySalesDataDto);
                if (CollectionUtils.isEmpty(mainOnedaySalesDataVos)){
                    continue;
                }
                Map<String, BigDecimal> saleQuantityMap = mainOnedaySalesDataVos.stream().collect(Collectors.toMap(item -> item.getCustomerCode() + item.getProductCode(), MainOnedaySalesDataVo::getSaleQuantity));
                for (LargeDateCallbackVo record : records) {
                    record.setPeriodSale(saleQuantityMap.get(record.getCustomerCode() + record.getProductCode()));
                }
            }
        }
    }

}
