package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 行销费用批复表
 *
 * @author xiaoyoujun
 * @since
 */
@Slf4j
@Service("marketingApprovalServiceImpl")
public class MarketingApprovalServiceImpl implements MarketingApprovalService {

    private static final String SECOND_CHANNEL_CODE = "C202";

    /**上账状态数据字典 */
    private static final String dict_up_account_status = "up_account_status";
    private static final String YESORNO = "yesOrNo";

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required = false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Page<MarketingApprovalVo> findAllConditions(Pageable pageable, MarketingApprovalDto marketingApprovalDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(marketingApprovalDto)) {
            marketingApprovalDto = new MarketingApprovalDto();
        }
        //分页获取数据
        Page<MarketingApprovalVo> page = activityDetailPlanApprovalActivityInfoRepository.findPsmMarketingConditions(pageable,marketingApprovalDto);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }
//        报销上账状态 是否完全结案 是否上账 折扣上账状态这几个
        List<String> dictCodeList = Lists.newArrayList();
        dictCodeList.add(dict_up_account_status);
        dictCodeList.add(YESORNO);
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
        Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue,(o,n)->n)),(o,n)->n));
        for (MarketingApprovalVo vo : page.getRecords()) {
            //        报销上账状态 是否完全结案 是否上账 折扣上账状态这几个
            if (StringUtils.isNotEmpty(vo.getUpAccountStatus())){
                String[] upAccountStatusArr = vo.getUpAccountStatus().split(",");
                Map<String, String> accountStatusMap = dictMapMap.get(dict_up_account_status);
                List<String> upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus,upAccountStatus));
                }
                vo.setUpAccountStatus(String.join(",",upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty(vo.getReimburseUpAccountStatus())){
                String[] upAccountStatusArr = vo.getReimburseUpAccountStatus().split(",");
                Map<String, String> accountStatusMap = dictMapMap.get(dict_up_account_status);
                List<String> upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus,upAccountStatus));
                }
                vo.setReimburseUpAccountStatus(String.join(",",upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty(vo.getWholeAudit())){
                if (vo.getWholeAudit().contains(BooleanEnum.TRUE.getCapital())){
                    vo.setWholeAudit(BooleanEnum.TRUE.getSure());
                }else{
                    vo.setWholeAudit(BooleanEnum.FALSE.getSure());
                }
            }
            if (StringUtils.isNotEmpty(vo.getIsPushSap())){
                if (vo.getIsPushSap().contains(BooleanEnum.TRUE.getCapital())){
                    vo.setIsPushSap(BooleanEnum.TRUE.getSure());
                }else{
                    vo.setIsPushSap(BooleanEnum.FALSE.getSure());
                }
            }
        }
        return page;
    }

}
