package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.service.SalesApprovalAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * @author wanghaojia
 * @date 2023/8/4 17:26
 */
@Service
public class SalesApprovalAsyncServiceImpl implements SalesApprovalAsyncService {

    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @Async
    public void updateActivityApprovalDataAsync(UpdateActivityApprovalDataDto dto, UserIdentity userIdentity){
        loginUserService.refreshAuthentication(userIdentity);
        salesApprovalService.updateActivityApprovalData(dto);
    }

}
