package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitTypeEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalActivityInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalAuditInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.enums.ActivityApprovalReportTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.register.MarketApprovalDataViewRegister;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalAuditInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.util.SalesApprovalInfoBuilder;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ApprovalReportAudit;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 销售费用批复表
 *
 * @author xiaoyoujun
 * @since
 */
@Slf4j
@Service("salesApprovalServiceImpl")
public class SalesApprovalServiceImpl implements SalesApprovalService {

    private static final String SECOND_CHANNEL_CODE = "C202";

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required = false)
    private ActivityDetailPlanApprovalAuditInfoRepository activityDetailPlanApprovalAuditInfoRepository;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private SalesApprovalInfoBuilder salesApprovalInfoBuilder;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;


    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    /**上账状态数据字典 */
    private static final String dict_up_account_status = "up_account_status";
    private static final String YESORNO = "yesOrNo";

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Override
    public Page<SalesApprovalVo> findAllConditions(Pageable pageable, SalesApprovalDto salesApprovalDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(salesApprovalDto)) {
            salesApprovalDto = new SalesApprovalDto();
        }
        //分页获取数据
        Page<SalesApprovalVo> page = activityDetailPlanApprovalActivityInfoRepository.findPsmConditions(pageable, salesApprovalDto);
        List<SalesApprovalVo> salesApprovalVos = page.getRecords();

//        报销上账状态 是否完全结案 是否上账 折扣上账状态这几个
        List<String> dictCodeList = Lists.newArrayList();
        dictCodeList.add(dict_up_account_status);
        dictCodeList.add(YESORNO);
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
        Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue,(o,n)->n)),(o,n)->n));
        for (SalesApprovalVo vo : salesApprovalVos) {
            //        报销上账状态 是否完全结案 是否上账 折扣上账状态这几个
            if (StringUtils.isNotEmpty(vo.getUpAccountStatus())){
                String[] upAccountStatusArr = vo.getUpAccountStatus().split(",");
                Map<String, String> accountStatusMap = dictMapMap.get(dict_up_account_status);
                List<String> upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus,upAccountStatus));
                }
                vo.setUpAccountStatus(String.join(",",upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty(vo.getReimburseUpAccountStatus())){
                String[] upAccountStatusArr = vo.getReimburseUpAccountStatus().split(",");
                Map<String, String> accountStatusMap = dictMapMap.get(dict_up_account_status);
                List<String> upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus,upAccountStatus));
                }
                vo.setReimburseUpAccountStatus(String.join(",",upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty(vo.getWholeAudit())){
                if (vo.getWholeAudit().contains(BooleanEnum.TRUE.getCapital())){
                    vo.setWholeAudit(BooleanEnum.TRUE.getSure());
                }else{
                    vo.setWholeAudit(BooleanEnum.FALSE.getSure());
                }
            }
            if (StringUtils.isNotEmpty(vo.getIsPushSap())){
                if (vo.getIsPushSap().contains(BooleanEnum.TRUE.getCapital())){
                    vo.setIsPushSap(BooleanEnum.TRUE.getSure());
                }else{
                    vo.setIsPushSap(BooleanEnum.FALSE.getSure());
                }
            }
        }
        return page;
    }

    @Override
    public void updateActivityApprovalData(UpdateActivityApprovalDataDto dto){
        if (ObjectUtils.isEmpty(dto)) {
            dto = new UpdateActivityApprovalDataDto();
        }
        if (StringUtils.isEmpty(dto.getPageSize())) {
            dto.setPageSize(CommonConstant.MAX_PAGE_SIZE_STR);
        }
        defaultUpdate:if (StringUtils.isEmpty(dto.getUpdateDate())) {
            if (StringUtils.isNotEmpty(dto.getDetailPlanCode())){
                break defaultUpdate;
            }
            if (StringUtils.isNotEmpty(dto.getDetailPlanItemCode())){
                break defaultUpdate;
            }
            Calendar now = Calendar.getInstance();
            now.add(Calendar.DATE, -1);
            Date nowTime = now.getTime();
            dto.setUpdateDate(DateUtil.date_yyyy_MM_dd.format(nowTime));
        }
        if (Objects.isNull(dto.getAddDay())) {
            dto.setAddDay(1);
        }
        int addDay = dto.getAddDay();
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String lockKey = dayFormat.format(new Date());
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            Date startDate = null;
            if (null != dto.getUpdateDate()){
                startDate = dayFormat.parse(dto.getUpdateDate());
            }
            for (int i = 0; i < addDay; i++) {
                if (null != startDate){
                    dto.setUpdateDate(dayFormat.format(DateUtil.dateAddDay(startDate, i)));
                }
                salesApprovalService.doUpdateActivityApprovalData(dto);
            }
        } catch (ParseException e) {
            throw new RuntimeException("时间解析异常");
        } finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doUpdateActivityApprovalData(UpdateActivityApprovalDataDto dto){
        //时间和编码必有一个，数据应该不会多，就不分页查了，分页数据会错乱
        dto.setBusinessUnitCodeList(getBusinessUnitCodeList());
        List<SalesApprovalVo> list = activityDetailPlanApprovalActivityInfoRepository.getUpdateActivityApprovalData(dto);
        Set<String> detailPlanItemCodeSet = Sets.newHashSet();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            loadActivityInfo(list);
            detailPlanItemCodeSet.addAll(list.stream().map(SalesApprovalVo::getDetailPlanItemCode).collect(Collectors.toList()));
            log.info("销售费用批复表本次新增"+list.size()+"条活动数据");
        }
        //传了更新时间的话，再按更新时间单独更新下核销数据
        if (!StringUtils.isEmpty(dto.getUpdateDate())){
            //有传更新时间的话要根据更新时间添加下要处理的数据
            ApprovalReportAudit approvalReportAudit = new ApprovalReportAudit();
            approvalReportAudit.setUpdateDate(dto.getUpdateDate());
            approvalReportAudit.setBusinessUnitCodeList(dto.getBusinessUnitCodeList());
            List<String> auditDetailPlanItemCodeList = activityDetailPlanApprovalAuditInfoRepository.findApprovalReportAuditDetailPlanItemCodeList(approvalReportAudit);
            if (!CollectionUtils.isEmpty(auditDetailPlanItemCodeList)){
                detailPlanItemCodeSet.addAll(auditDetailPlanItemCodeList);
            }
        }
        if (CollectionUtils.isEmpty(detailPlanItemCodeSet)){
            return;
        }
        List<ApprovalReportAudit> auditInfoList = activityDetailPlanApprovalAuditInfoRepository.findApprovalReportAuditInfoList(Lists.newArrayList(detailPlanItemCodeSet));
        if (!CollectionUtils.isEmpty(auditInfoList)){
            log.info("销售费用批复表本次新增"+auditInfoList.size()+"条核销数据");
        }
        this.saveOrUpdate(list,auditInfoList);
    }

    private List<String> getBusinessUnitCodeList(){
        List<String> businessUnitCodeList = Lists.newArrayList();
        for (BusinessUnitEnum value : BusinessUnitEnum.values()) {
            if (BusinessUnitTypeEnum.HEADQUARTERS_TYPE.equals(value.getType())){
                businessUnitCodeList.add(value.getCode());
            }
        }
        return businessUnitCodeList;
    }

    private void saveOrUpdate(List<SalesApprovalVo> activityList,List<ApprovalReportAudit> auditList) {
        String tenantCode = TenantUtils.getTenantCode();
        if (!CollectionUtils.isEmpty(activityList)){
            List<String> detailPlanItemCodeList = activityList.stream().map(SalesApprovalVo::getDetailPlanItemCode).collect(Collectors.toList());
            activityDetailPlanApprovalActivityInfoRepository.deleteByDetailPlanItemCodeList(detailPlanItemCodeList);
            Collection<ActivityDetailPlanApprovalActivityInfo> activityEntityList = nebulaToolkitService.copyCollectionByWhiteList(activityList, SalesApprovalVo.class, ActivityDetailPlanApprovalActivityInfo.class, HashSet.class, ArrayList.class);
            for (ActivityDetailPlanApprovalActivityInfo activityDetailPlanApprovalActivityInfo : activityEntityList) {
                if (MarketApprovalDataViewRegister.maReportTemplateConfigCodeList.contains(activityDetailPlanApprovalActivityInfo.getTemplateConfigCode())){
                    activityDetailPlanApprovalActivityInfo.setApprovalReportType(ActivityApprovalReportTypeEnum.MARKETING.getCode());
                }else{
                    activityDetailPlanApprovalActivityInfo.setApprovalReportType(ActivityApprovalReportTypeEnum.SALES.getCode());
                }
                activityDetailPlanApprovalActivityInfo.setTenantCode(tenantCode);
            }
            activityDetailPlanApprovalActivityInfoRepository.saveBatch(activityEntityList);
            activityDetailPlanApprovalActivityInfoRepository.updateTenantOp(detailPlanItemCodeList);
        }
        if (!CollectionUtils.isEmpty(auditList)){
            List<String> detailPlanItemCodeList2 = auditList.stream().map(ApprovalReportAudit::getDetailPlanItemCode).collect(Collectors.toList());
            activityDetailPlanApprovalAuditInfoRepository.deleteByDetailPlanItemCodeList(detailPlanItemCodeList2);
            Collection<ActivityDetailPlanApprovalAuditInfo> auditEntityList = nebulaToolkitService.copyCollectionByWhiteList(auditList, ApprovalReportAudit.class, ActivityDetailPlanApprovalAuditInfo.class, HashSet.class, ArrayList.class);
            for (ActivityDetailPlanApprovalAuditInfo auditInfo : auditEntityList) {
                auditInfo.setTenantCode(tenantCode);
            }
            activityDetailPlanApprovalAuditInfoRepository.saveBatch(auditEntityList);
        }
    }

    /**
     * 活动费用批复表数据更新锁
     **/
    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("活动费用批复表数据更新失败，日期不能为空！");
        }
        return this.redisLockService.tryLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_APPROVE_REPORT + yearMonthDay, TimeUnit.HOURS, 12);
    }

    /**
     * 活动费用批复表数据更新锁
     **/
    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("活动费用批复表数据更新失败，日期不能为空!");
        }
        redisLockService.unlock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_APPROVE_REPORT + yearMonthDay);
    }

    @Override
    public void loadActivityInfo(List<SalesApprovalVo> salesApprovalVos){
        if (CollectionUtils.isEmpty(salesApprovalVos)){
            return;
        }
        Set<String> customerCodeSet = new HashSet<>();
        Set<String> terminalCodeSet = new HashSet<>();
        Set<String> headBudgetItemCodeSet = new HashSet<>();
        Set<String> budgetItemCodeSet = new HashSet<>();
        Set<String> detailPlanCodeSet = new HashSet<>();
        salesApprovalVos.forEach(item -> {
            if (StringUtils.isNotBlank(item.getCustomerCode())) {
                customerCodeSet.add(item.getCustomerCode());
            }
            if (StringUtils.isNotBlank(item.getTerminalCode())) {
                terminalCodeSet.add(item.getTerminalCode());
            }
            if (StringUtils.isNotBlank(item.getHeadBudgetItemCode())) {
                headBudgetItemCodeSet.add(item.getHeadBudgetItemCode());
            }
            if (StringUtils.isNotBlank(item.getBudgetItemCode())) {
                budgetItemCodeSet.add(item.getBudgetItemCode());
            }
            if (StringUtils.isNotBlank(item.getDetailPlanCode())) {
                detailPlanCodeSet.add(item.getDetailPlanCode());
            }
        });

        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(customerCodeSet)) {
            List<CustomerVo> customerVoList = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (CollectionUtil.isNotEmpty(customerVoList)) {
                customerVoMap.putAll(customerVoList.stream()
                        .filter(k -> StringUtils.isNotBlank(k.getCustomerCode()))
                        .collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (newValue, oldValue) -> newValue)));
            }
        }
        Map<String, TerminalVo> terminalVoMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(terminalCodeSet)) {
            List<TerminalVo> terminalVoList = terminalVoService.findMainDetailsByTerminalCodesUsePost(new ArrayList<>(terminalCodeSet));
            if (CollectionUtil.isNotEmpty(terminalVoList)) {
                terminalVoMap.putAll(terminalVoList.stream()
                        .filter(k -> StringUtils.isNotBlank(k.getTerminalCode()))
                        .collect(Collectors.toMap(TerminalVo::getTerminalCode, v -> v, (newValue, oldValue) -> newValue)));
            }
        }
        //预算项目
        Map<String, BudgetItemVo> budgetItemVoMap = salesApprovalInfoBuilder.getBudgetItemDataTypeCodeMap(salesApprovalVos);
        //大区方案
        Map<String, ActivityDetailPlanBudgetVo> planInfoVoMap = salesApprovalInfoBuilder.getPlanInfoMap(salesApprovalVos);

        Map<String, List<ActivityPlanBudgetVo>> activityPlanBudgetVoMap = new HashMap<>();
        if(planInfoVoMap != null){
            /**
             * 大区方案编码
             */
            Set<String> planCodes = planInfoVoMap.values().stream().map(ActivityDetailPlanBudgetVo::getRelatePlanCode).collect(Collectors.toSet());
            List<ActivityPlanBudgetVo> activityPlanBudgetVoList = activityPlanSdkService.findHeadquartersByRegionPlanCodes(planCodes);
            activityPlanBudgetVoMap = activityPlanBudgetVoList.stream().collect(Collectors.groupingBy(ActivityPlanBudgetVo::getPlanCode));
        }

        //数据拼接
        for (SalesApprovalVo vo : salesApprovalVos) {
            if (SECOND_CHANNEL_CODE.equals(vo.getSecondChannelCode())) {
                vo.setWhetherTwentyTerminal(YesOrNoEnum.YES.getCode());
            } else {
                vo.setWhetherTwentyTerminal(YesOrNoEnum.NO.getCode());
            }
            if (vo.getHeadFeeAmount() == null) {
                vo.setHeadFeeAmount(BigDecimal.ZERO);
            }
            if (vo.getDepartmentFeeAmount() == null) {
                vo.setDepartmentFeeAmount(BigDecimal.ZERO);
            }
            if (vo.getCustomerFeeAmount() == null) {
                vo.setCustomerFeeAmount(BigDecimal.ZERO);
            }

            //获取客户信息
            vo.setRegion(vo.getActivityOrgName());
            if (StringUtils.isNotEmpty(vo.getCustomerCode())) {
                CustomerVo customerVo = customerVoMap.get(vo.getCustomerCode());
                if (Objects.nonNull(customerVo)) {
                    vo.setRtmModelCode(customerVo.getRtmModelCode());
                    vo.setCustomerTypeName(customerVo.getCustomerLevel());
                    vo.setRegion(customerVo.getSalesRegionName());
                }
            }
            //获取门店信息
            if (StringUtils.isNotEmpty(vo.getTerminalCode())) {
                TerminalVo terminalVo = terminalVoMap.get(vo.getTerminalCode());
                if (Objects.nonNull(terminalVo)) {
                    if (StringUtils.isNotEmpty(terminalVo.getSecondChannelCode())
                            && SECOND_CHANNEL_CODE.equals(terminalVo.getSecondChannelCode())) {
                        vo.setWhetherTwentyTerminal(YesOrNoEnum.YES.getCode());
                    } else {
                        vo.setWhetherTwentyTerminal(YesOrNoEnum.NO.getCode());
                    }
                }
            }
            //获取预算信息
            //总部
            if (StringUtils.isNotEmpty(vo.getHeadBudgetItemCode()) && budgetItemVoMap.containsKey(vo.getHeadBudgetItemCode())) {
                BudgetItemVo budgetItemVo = budgetItemVoMap.get(vo.getHeadBudgetItemCode());
                if (!ObjectUtils.isEmpty(budgetItemVo)) {
                    vo.setHeadquartersDataTypeCode(budgetItemVo.getDataTypeCode());
                    List<BudgetItemControlConditionVo> conditionVos = budgetItemVo.getControlConditionDtoList();
                    if (!CollectionUtils.isEmpty(conditionVos)) {
                        String collect = conditionVos.stream().map(BudgetItemControlConditionVo::getDepartmentBelongCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                        vo.setHeadquartersDepartmentBelongCode(collect);
                        String formatCode = conditionVos.stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                        vo.setBusinessCode(formatCode);
                    }
                }
            }
            //大区
            if (StringUtils.isNotEmpty(vo.getBudgetItemCode()) && budgetItemVoMap.containsKey(vo.getBudgetItemCode())) {
                BudgetItemVo budgetItem = budgetItemVoMap.get(vo.getBudgetItemCode());
                if (!ObjectUtils.isEmpty(budgetItem)) {
                    vo.setRegionDataTypeCode(budgetItem.getDataTypeCode());
                    List<BudgetItemControlConditionVo> conditionVos = budgetItem.getControlConditionDtoList();
                    if (!CollectionUtils.isEmpty(conditionVos)) {
                        String collect = conditionVos.stream().map(BudgetItemControlConditionVo::getDepartmentBelongCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                        vo.setRegionDepartmentBelongCode(collect);
                        String formatCode = conditionVos.stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                        vo.setBusinessCode(formatCode);
                    }
                }
            }
            if (StringUtils.isNotEmpty(vo.getDetailPlanItemCode()) && planInfoVoMap.containsKey(vo.getDetailPlanItemCode())) {
                ActivityDetailPlanBudgetVo planVo = planInfoVoMap.get(vo.getDetailPlanItemCode());
                if (planVo != null) {
                    //大区方案名称
                    if (StringUtils.isNotEmpty(planVo.getRelatePlanName())) {
                        vo.setRegionalFileName(planVo.getRelatePlanName());
                        vo.setPlanName(planVo.getRelatePlanName());
                    }
                    //大区方案编码
                    if (StringUtils.isNotEmpty(planVo.getRelatePlanCode())) {
                        vo.setRegionalFileCode(planVo.getRelatePlanCode());
                        vo.setPlanCode(planVo.getRelatePlanCode());
                    }
                    //大区方案明细编码
                    vo.setRelatePlanItemCode(planVo.getRelatePlanItemCode());
                }
                List<ActivityPlanBudgetVo> activityPlanBudgetVos = activityPlanBudgetVoMap.get(vo.getPlanCode());
                if (!CollectionUtils.isEmpty(activityPlanBudgetVos)){
                    for (ActivityPlanBudgetVo activityPlanBudgetVo : activityPlanBudgetVos) {
                        String headquartersFileName = StringUtils.isNotEmpty(activityPlanBudgetVo.getRelatePlanName())?activityPlanBudgetVo.getRelatePlanName():activityPlanBudgetVo.getRelateStrategyName();
                        String headquartersFileCode = StringUtils.isNotEmpty(activityPlanBudgetVo.getRelatePlanCode())?activityPlanBudgetVo.getRelatePlanCode():activityPlanBudgetVo.getRelateStrategyCode();
                        //总部方案名称
                        vo.setHeadquartersFileName(headquartersFileName);
                        //总部方案编码
                        vo.setHeadquartersFileCode(headquartersFileCode);
                    }
                }
            }
        }

        //分子HR组织编码
        List<String> subComCustomerCodeList = salesApprovalVos.stream()
                .filter(e -> RtmModelCodeEnum.SON_COMPANY.getCode().equals(e.getRtmModelCode()))
                .map(SalesApprovalVo::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(subComCustomerCodeList)) {
            List<String> subComOrgCodeList = subComCustomerCodeList.stream().map(e -> e.substring(0, 10)).collect(Collectors.toList());
            List<SalesOrgSubComOrgVo> subComOrgVoList = salesOrgSubComOrgService.listBySubComOrgCodeList(subComOrgCodeList);
            Map<String, SalesOrgSubComOrgVo> subComOrgCodeToVoMap = subComOrgVoList.stream()
                    .collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity(), (e1, e2) -> e1));
            salesApprovalVos.stream()
                    .filter(e -> RtmModelCodeEnum.SON_COMPANY.getCode().equals(e.getRtmModelCode()))
                    .forEach(vo -> {
                        String subComOrgCode = vo.getCustomerCode().substring(0, 10);
                        if (subComOrgCodeToVoMap.containsKey(subComOrgCode)) {
                            SalesOrgSubComOrgVo salesOrgSubComOrgVo = subComOrgCodeToVoMap.get(subComOrgCode);
                            vo.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                        }
                    });
        }

    }

}
