package com.biz.crm.tpm.business.activity.detail.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanBudgetMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * 活动细案(ActivityDetailPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
@Component
public class ActivityDetailPlanBudgetRepository extends ServiceImpl<ActivityDetailPlanBudgetMapper, ActivityDetailPlanBudget> {

    /**
     * 根据细案编码查询
     **/
    public List<ActivityDetailPlanBudget> listByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty(detailPlanCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(ActivityDetailPlanBudget::getDetailPlanCode, detailPlanCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 批量查询
     **/
    public List<ActivityDetailPlanBudget> listByDetailPlanItemCodeList(Collection<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanBudget::getDetailPlanItemCode, detailPlanItemCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 批量查询
     **/
    public List<ActivityDetailPlanBudget> listByDetailPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanBudget::getDetailPlanCode, detailPlanCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }


    /**
     * 批量查询
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget>
     * @author huojia
     * @date 2022/11/28 17:08
     **/
    public List<ActivityDetailPlanBudget> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanBudget::getDetailPlanItemCode, itemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据id删除数据
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanBudget> updateWrapper = new UpdateWrapper<ActivityDetailPlanBudget>().lambda();
        updateWrapper.set(ActivityDetailPlanBudget::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanBudget::getId, ids);
        this.update(updateWrapper);
    }

    public List<ActivityDetailPlanBudgetDto> listDtoListByDetailPlanCode(String detailPlanCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(detailPlanCode)) {
            return null;
        }
        return baseMapper.listDtoListByDetailPlanCode(detailPlanCode);
    }

    public void deletePhysicalByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty(detailPlanCode)){
            return;
        }
        LambdaQueryWrapper<ActivityDetailPlanBudget> updateWrapper = new LambdaQueryWrapper<ActivityDetailPlanBudget>();
//        updateWrapper.set(ActivityPlanBudget::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityDetailPlanBudget::getDetailPlanCode, detailPlanCode);
        this.remove(updateWrapper);
    }

    public List<ActivityDetailPlanBudget> findBudgetByCodes(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return null;
        }
        return this.lambdaQuery().in(ActivityDetailPlanBudget::getDetailPlanItemCode,detailPlanItemCodes)
                .list();
    }

    public LinkedList<ActivityDetailPlanBudget> listByOperateCodeListVertical(List<String> operateCodeList) {
        if (CollectionUtils.isEmpty(operateCodeList)) {
            return null;
        }
        return baseMapper.listByOperateCodeListVertical(operateCodeList);
    }

    public void deletePhysicalByDetailPlanCodeAndOccupyType(List<String> delItemCodeList, String occupyType) {
        if (StringUtils.isEmpty(occupyType) || CollectionUtils.isEmpty(delItemCodeList)) {
            return;
        }
        LambdaQueryWrapper<ActivityDetailPlanBudget> updateWrapper = new LambdaQueryWrapper<>();
        updateWrapper.in(ActivityDetailPlanBudget::getDetailPlanCode, delItemCodeList)
                .eq(ActivityDetailPlanBudget::getOccupyType, occupyType);
        this.remove(updateWrapper);
    }

    public List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet) {
        return baseMapper.findByPlanItemCode(itemCodeSet,TenantUtils.getTenantCode());
    }

    public List<String> detailPlanRelatePlanCodeList(Set<String> detailPlanCodeSet) {
        return baseMapper.detailPlanRelatePlanCodeList(detailPlanCodeSet,TenantUtils.getTenantCode());
    }

    public Collection<String> findDetailPlanCodeListByRelatePlanCodeList(List<String> planCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(planCodeList)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanBudget.class)
                .in(ActivityDetailPlanBudget::getRelatePlanCode, planCodeList)
                .eq(ActivityDetailPlanBudget::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanBudget::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .select(ActivityDetailPlanBudget::getDetailPlanCode)
        ).stream().map(ActivityDetailPlanBudget::getDetailPlanCode).distinct().collect(Collectors.toList());
    }

    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> activityDetailCodes) {
        if(CollectionUtils.isEmpty(activityDetailCodes)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes);
    }

    public List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes, String tenantCode) {
        return this.baseMapper.findRegionIsRelateHead(planCodes,tenantCode);
    }

    public List<String> hasRelateDetailPlanCodeList(Set<String> planItemCodeList) {
        return baseMapper.hasRelateDetailPlanCodeList(planItemCodeList,TenantUtils.getTenantCode());
    }
}

