package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtendField;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemExtendFieldMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/3/6 10:02
 */
@Component
public class ActivityDetailPlanItemExtendFieldRepository extends ServiceImpl<ActivityDetailPlanItemExtendFieldMapper, ActivityDetailPlanItemExtendField> {

    /**
     * 根据方案明细编码 删除
     */
    public void deleteByPlanItemCodeList(List<String> detailPlanItemCodeList) {
        if(CollUtil.isEmpty(detailPlanItemCodeList)){
            return;
        }
        this.remove(Wrappers.<ActivityDetailPlanItemExtendField>lambdaQuery()
                .in(ActivityDetailPlanItemExtendField::getDetailPlanItemCode,detailPlanItemCodeList)
                .eq(ActivityDetailPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    /**
     * 根据方案明细编码 删除
     */
    public void deleteByPlanCodeList(List<String> detailPlanCodeList) {
        if(CollUtil.isEmpty(detailPlanCodeList)){
            return;
        }
        this.remove(Wrappers.<ActivityDetailPlanItemExtendField>lambdaQuery()
                .in(ActivityDetailPlanItemExtendField::getDetailPlanCode,detailPlanCodeList)
                .eq(ActivityDetailPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public List<ActivityDetailPlanItemExtendField> listByPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.<ActivityDetailPlanItemExtendField>lambdaQuery()
                .in(ActivityDetailPlanItemExtendField::getDetailPlanCode,detailPlanCode)
                .eq(ActivityDetailPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }
}
