package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemExtendMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/3/31 10:57
 */
@Component
public class ActivityDetailPlanItemExtendRepository  extends ServiceImpl<ActivityDetailPlanItemExtendMapper, ActivityDetailPlanItemExtend> {

    private static final String property_planCode = "detailPlanCode";
    private static final String property_planItemCode = "detailPlanItemCode";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_planCode);
        excludeFieldList.add(property_planItemCode);
    }

    public List<ActivityDetailPlanItemExtend> findByForeignPlanCode(String foreignPlanCode){
        if (StringUtils.isEmpty(foreignPlanCode)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(ActivityDetailPlanItemExtend::getForeignPlanCode,foreignPlanCode)
                .eq(ActivityDetailPlanItemExtend::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }
    public List<ActivityDetailPlanItemExtend> findByForeignPlanItemCodeList(List<String> foreignPlanItemCodeList){
        if (CollectionUtils.isEmpty(foreignPlanItemCodeList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanItemExtend::getForeignPlanItemCode,foreignPlanItemCodeList)
                .eq(ActivityDetailPlanItemExtend::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(ActivityDetailPlanItemExtend entity){
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemExtend.class);
        List<String> excludeFieldList = Lists.newArrayList();
        excludeFieldList.addAll(Arrays.stream(BeanUtils.getPropertyDescriptors(TenantEntity.class)).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_planCode);
        excludeFieldList.add(property_planItemCode);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())){
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())){
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public void addActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes) {
        if(StringUtils.isEmpty(code)){
            return;
        }
        if(CollectionUtils.isEmpty(thisNewActivityDetailCodes)){
            return;
        }
        this.lambdaUpdate().in(ActivityDetailPlanItemExtend::getDetailPlanItemCode,thisNewActivityDetailCodes)
                .set(ActivityDetailPlanItemExtend::getRelatePurchaseOrder,code)
                .update();
    }

    public void delActivityDetailPurchasingOrder(String code, List<String> thisDelActivityDetailCodes) {
        if(StringUtils.isEmpty(code)){
            return;
        }
        if(CollectionUtils.isEmpty(thisDelActivityDetailCodes)){
            return;
        }
        this.lambdaUpdate().in(ActivityDetailPlanItemExtend::getDetailPlanItemCode,thisDelActivityDetailCodes)
                .set(ActivityDetailPlanItemExtend::getRelatePurchaseOrder,null)
                .update();
    }

    public void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus) {
        if(StringUtils.isBlank(processStatus)){
            return;
        }
        if(CollectionUtils.isEmpty(activityDetailItemCodes)){
            return;
        }
        this.lambdaUpdate()
                .in(ActivityDetailPlanItemExtend::getDetailPlanItemCode,activityDetailItemCodes)
                .set(ActivityDetailPlanItemExtend::getPurchaseOrderProcessStatus,processStatus)
                .update();
    }

    public List<String> findListByPlanItemCodes(List<String> detailItemCodes) {
        if(CollectionUtils.isEmpty(detailItemCodes)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItemExtend> list = this.lambdaQuery().in(ActivityDetailPlanItemExtend::getDetailPlanItemCode, detailItemCodes)
                .select(ActivityDetailPlanItemExtend::getDetailPlanItemCode).list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list.stream().map(ActivityDetailPlanItemExtend::getDetailPlanItemCode).collect(Collectors.toList());
    }

    public List<ActivityDetailPlanItemExtend> findByPlanItemCodes(List<String> detailItemCodeList) {
        if (CollectionUtils.isEmpty(detailItemCodeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanItemExtend::getDetailPlanItemCode, detailItemCodeList)
                .list();
    }
}
