package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 18:05
 * @description：活动细案数据库访问层
 */
@Component
public class ActivityDetailPlanItemRepository extends ServiceImpl<ActivityDetailPlanItemMapper, ActivityDetailPlanItem> {

    @Autowired(required = false)
    private ActivityDetailPlanItemMapper activityDetailPlanItemMapper;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendFieldRepository activityDetailPlanItemExtendFieldRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;

    @Autowired(required = false)
    private ActivityDetailPlanProductRepository activityDetailPlanProductRepository;

    @Autowired(required = false)
    private ExtendFieldService extendFieldService;

    /**
     * 根据方案编码查询方案明细数据
     * @param planCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityDetailPlanItemDto> findDtoListByActivityDetailPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> itemList = findListByActivityDetailPlanCode(planCode);
        List<ActivityDetailPlanItemDto> dtoList = (List<ActivityDetailPlanItemDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }

    /**
     * 根据细案编码查询细案明细数据
     * @param detailPlanCodeList 方案编码
     * @return 细案明细dtolist
     */
    public List<ActivityDetailPlanItemVo> findVoListByActivityDetailPlanCode(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)){
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> itemList = findListByDetailPlanCodeList(detailPlanCodeList);
        List<ActivityDetailPlanItemVo> voList = (List<ActivityDetailPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class);
        fillVoListProperties(voList);
        return voList;
    }

    /**
     * 查策略明细信息及其附加其他信息
     * @param detailPlanCode 细案编码
     * @return
     */
    public List<ActivityDetailPlanItemDto> findDtoAndAttachListByDetailPlanCode(String detailPlanCode){
        List<ActivityDetailPlanItemDto> dtoList = findDtoListByActivityDetailPlanCode(detailPlanCode);
        //营销策略就附带一个预算
        List<ActivityDetailPlanBudgetDto> budgetList = activityDetailPlanBudgetRepository.listDtoListByDetailPlanCode(detailPlanCode);
        if (!CollectionUtils.isEmpty(budgetList)){
            convertMonthBudgetProperty(budgetList);
            for (ActivityDetailPlanBudgetDto budgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull(budgetDto.getUseAmount(), budgetDto::setUseAmountStr);
            }
            Map<String, List<ActivityDetailPlanBudgetDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank(item.getDetailPlanItemCode())).collect(Collectors.groupingBy(ActivityDetailPlanBudgetDto::getDetailPlanItemCode));
            for (ActivityDetailPlanItemDto itemDto : dtoList) {
                if (budgetMap.containsKey(itemDto.getDetailPlanItemCode())){
                    itemDto.setBudgetShares(budgetMap.get(itemDto.getDetailPlanItemCode()));
                }
            }
        }
        List<ActivityDetailPlanItemExtendField> itemExtendFields = activityDetailPlanItemExtendFieldRepository.listByPlanCode(detailPlanCode);
        if (!CollectionUtils.isEmpty(itemExtendFields)){
            Map<String, List<ActivityDetailPlanItemExtendField>> extendFieldMap = itemExtendFields.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemExtendField::getDetailPlanItemCode));
            for (ActivityDetailPlanItemDto itemDto : dtoList) {
                extendFieldService.fillExtendField(itemDto,ActivityDetailPlanItemDto.class,extendFieldMap.get(itemDto.getDetailPlanItemCode()));
            }
        }
        return dtoList;
    }

    /**
     * 转换字段
     */
    public void convertMonthBudgetProperty(List<ActivityDetailPlanBudgetDto> list){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        Map<String,String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService){
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(MonthBudgetConstant.DICT_TPM_FEE_BELONG_US);
                if (!CollectionUtils.isEmpty(feeSourceList)){
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode,DictDataVo::getDictValue,(o,n)->o));
                }
            }catch (Exception e){
                log.error("费用归口数据字典查询失败："+e.getMessage());
            }
        }
        for (ActivityDetailPlanBudgetDto vo : list) {
            //费用来源转换
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getFeeBelongCode())){
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(),vo.getFeeBelongCode()));
            }
        }
    }

    /**
     * 查询dto集合
     * @param planItem 查询参数
     * @return
     */
    public List<ActivityDetailPlanItemDto> findDtoList(ActivityDetailPlanItemDto planItem) {
        List<ActivityDetailPlanItem> itemList = findList(planItem);
        return (List<ActivityDetailPlanItemDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据方案编码查询方案明细数据
     * @param detailPlanCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityDetailPlanItem> findListByActivityDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return Collections.emptyList();
        }
        ActivityDetailPlanItemDto activityDetailPlanItem = new ActivityDetailPlanItemDto();
        activityDetailPlanItem.setDetailPlanCode(detailPlanCode);
        return findList(activityDetailPlanItem);
    }

    /**
     * 根据方案明细编码查询细案明细数据
     */
    public List<ActivityDetailPlanItem> findListByRelatePlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return Collections.emptyList();
        }
        ActivityDetailPlanItemDto activityDetailPlanItem = new ActivityDetailPlanItemDto();
        activityDetailPlanItem.setRelatePlanItemCodeList(planItemCodeList);
        return findList(activityDetailPlanItem);
    }

    /**
     * 根据查询条件筛选集合
     * @param planItem 查询参数
     */
    public List<ActivityDetailPlanItem> findList(ActivityDetailPlanItemDto planItem) {
        LambdaQueryWrapper<ActivityDetailPlanItem> wrapper = Wrappers.lambdaQuery(ActivityDetailPlanItem.class)
                .eq(StringUtils.isNotBlank(planItem.getDetailPlanCode()), ActivityDetailPlanItem::getDetailPlanCode, planItem.getDetailPlanCode())
                .eq(StringUtils.isNotBlank(planItem.getTemplateConfigCode()), ActivityDetailPlanItem::getTemplateConfigCode, planItem.getTemplateConfigCode())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        if (!CollectionUtils.isEmpty(planItem.getRelatePlanItemCodeList())){
            wrapper.in(ActivityDetailPlanItem::getRelatePlanItemCode,planItem.getRelatePlanItemCodeList());
        }
        return this.list(wrapper);
    }

    public List<ActivityDetailPlanItem> findListByDetailPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanItem.class)
                .in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    public Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        String detailPlanItemCode = activityDetailPlanItemDto.getDetailPlanItemCode();
        if(StringUtils.isNotBlank(detailPlanItemCode)){
            detailPlanItemCode = detailPlanItemCode.trim().replaceAll("\\s+", " ");
            List<String> detailPlanItemCodeList = Arrays.asList(detailPlanItemCode.trim().split(" "));
            activityDetailPlanItemDto.setDetailPlanItemCode(null);
            activityDetailPlanItemDto.setDetailPlanItemCodeList(detailPlanItemCodeList);
        }
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findByConditions(page, activityDetailPlanItemDto);
        return pageList;
    }


    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItem> updateWrapper = new UpdateWrapper<ActivityDetailPlanItem>().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanItem::getId, ids);
        this.update(updateWrapper);
    }

    /**
     * 根据明细编码批量查询方案明细
     *
     * @author huojia
     * @date 2022/11/27 19:32
     * @param detailItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem>
     **/
    public List<ActivityDetailPlanItem> listByDetailCodeList(List<String> detailItemCodeList) {
        if (CollectionUtils.isEmpty(detailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.list(Wrappers.<ActivityDetailPlanItem>lambdaQuery()
                .in(ActivityDetailPlanItem::getDetailPlanItemCode, detailItemCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()));
//        return this.list(this.lambdaQuery()
//                .in(ActivityDetailPlanItem::getDetailPlanItemCode, detailItemCodeList)
//                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
//                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()));
    }

    public Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(activityDetailPlanItemDto.getDetailPlanItemCode())){
            if (activityDetailPlanItemDto.getDetailPlanItemCode().contains(",") || activityDetailPlanItemDto.getDetailPlanItemCode().contains(" ")){
                activityDetailPlanItemDto.setDetailPlanItemCodeList(Arrays.asList(activityDetailPlanItemDto.getDetailPlanItemCode().split("[, ，]")));
                activityDetailPlanItemDto.setDetailPlanItemCode(null);
            }
        }
//        List<String> conditionCodeList = this.activityDetailPlanItemMapper.findForAuditConditionCodeList(activityDetailPlanItemDto);
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findForAudit(page, activityDetailPlanItemDto);
        return pageList;
    }

    public List<ActivityDetailPlanItemVo> findDetailItemByParams(AutoAuditParamsDto autoAuditParams){
        return this.activityDetailPlanItemMapper.findDetailItemList(autoAuditParams);
    }

    public List<ActivityDetailPlanItemVo> findDetailPlanItemByCodes(List<String> codes, String autoDate, String autoAudit, String wholeAudit){

        return this.activityDetailPlanItemMapper.findPlanItemList(codes, wholeAudit, autoDate, autoAudit);

    }

    public List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails) {
        List<ActivityDetailPlanItem> list = this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanItemCode, activityDetails)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByBlankList(list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
    }

    public List<ActivityDetailPlanItem> findByActivityDetailItemCodes(Set<String> itemCodes, String activityDetailPlanRollbackBudget) {
        LambdaQueryWrapper<ActivityDetailPlanItem> lambdaQueryWrapper =
                Wrappers.lambdaQuery(ActivityDetailPlanItem.class)
                .in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodes)
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode());
        if(StringUtils.isNotBlank(activityDetailPlanRollbackBudget)){
            lambdaQueryWrapper = lambdaQueryWrapper.and(i -> i.ne(ActivityDetailPlanItem::getRollbackBudgetTag, activityDetailPlanRollbackBudget).or().isNull(ActivityDetailPlanItem::getRollbackBudgetTag));
        }
        List<ActivityDetailPlanItem> list = this.list(lambdaQueryWrapper);
        return list;
    }

    /**
     * 根据客户与区域 统计费用合计
     *
     * @param dto 统计参数
     * @return List<ActivityDetailPlanItemStatisticsVo>
     */
    public List<ActivityDetailPlanItemStatisticsVo> statisticsFeeAmountByCusOrgCodes(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisticsFeeAmountByCusOrgCodes(dto);
    }

    /**
     * 根据品牌，零售商，区域统计细案明细的费用合计
     *
     * @param dto 统计参数
     * @return List<ActivityDetailPlanItemStatisticsVo>
     */
    public List<ActivityDetailPlanItemStatisticsVo> statisticsDetailPlanItemTotalFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisticsDetailPlanItemTotalFee(dto);
    }

    /**
     * 根据品牌，零售商，区域统计细案明细数据 key=零售商-区域，value=金额 （下月预计上账费用）分页获取
     *
     * @param dto 统计参数
     * @return List<NextMonthPredictAccountFeeVo>
     */
    public List<NextMonthPredictAccountFeeVo> statisNextMonthPredictAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisNextMonthPredictAccountFee(dto);
    }

    /**
     * 根据零售商，区域统计细案明细数据 key=零售商-区域，value=金额 （折扣上账金额）
     *
     * @param dto 统计参数
     * @return List<DiscountAccountFeeVo>
     */
    public List<DiscountAccountFeeVo> statisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisDiscountAccountFee(dto);
    }

    /**
     * 分页获取预提明细-活动细案部分数据
     * @param pageable 分页参数
     * @param dto 过滤参数
     * @param processStatus 审批状态
     * @param upAccountStatus 上账状态
     * @author jiangyin
     * @date 2023/1/3 17:30
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     */
    public Page<ActivityDetailPlanItemVo> findByProcessStatusAndUpAccountStatus(Pageable pageable, ActivityDetailPlanItemDto dto, String processStatus, String upAccountStatus) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return activityDetailPlanItemMapper.findByProcessStatusAndUpAccountStatus(page, dto, processStatus, upAccountStatus);
    }

    /**
     * 根据活动细案编码删除活动细案明细数据
     * @param detailPlanCodes 活动细案编码集合
     */
    public void deleteByDetailPlanCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItem> updateWrapper = new UpdateWrapper<ActivityDetailPlanItem>().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode());
        updateWrapper.in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodes);
        this.update(updateWrapper);

        LambdaUpdateWrapper<ActivityDetailPlanItemExtend> updateWrapper2 = new UpdateWrapper<ActivityDetailPlanItemExtend>().lambda();
        updateWrapper2.eq(ActivityDetailPlanItemExtend::getTenantCode, TenantUtils.getTenantCode());
        updateWrapper2.in(ActivityDetailPlanItemExtend::getDetailPlanCode, detailPlanCodes);
        activityDetailPlanItemExtendRepository.remove(updateWrapper2);
    }

    /**
     * 关闭活动细案明细
     * @param itemCodeList 活动细案明细编码集合
     */
    public void closeItem(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)){
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityDetailPlanItem.class)
                .set(ActivityDetailPlanItem::getIsClose, BooleanEnum.TRUE.getCapital())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityDetailPlanItem::getDetailPlanItemCode,itemCodeList)
        );
    }

    /**
     * 关闭活动细案明细（垂直）
     * @param itemCodeList 活动细案明细编码集合
     */
    public void closeItemVertical(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)){
            return;
        }
        this.update(Wrappers.lambdaUpdate(ActivityDetailPlanItem.class)
                .set(ActivityDetailPlanItem::getIsClose, BooleanEnum.TRUE.getCapital())
                .set(ActivityDetailPlanItem::getCloseDate, DateUtil.getDate(DateUtil.date_yyyy_MM_dd_HH_mm_ss))
                .set(ActivityDetailPlanItem::getRollbackBudgetTag, ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode())
                .in(ActivityDetailPlanItem::getDetailPlanItemCode,itemCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    /**
     * 根据活动细案编码获取明细集合
     * @param detailPlanCodes 活动细案编码
     * @return 明细集合
     */
    public List<ActivityDetailPlanItemVo> findItemsByActivityDetailItemCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> list = this.lambdaQuery()
                .in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return (List<ActivityDetailPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(list,ActivityDetailPlanItem.class,ActivityDetailPlanItemVo.class,HashSet.class,ArrayList.class);
    }

    /**
     * 根据活动细案明细编码获取可推送的明细集合
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    public List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> list = this.lambdaQuery()
                .in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return (List<ActivityDetailPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(list,ActivityDetailPlanItem.class,ActivityDetailPlanItemVo.class,HashSet.class,ArrayList.class);

    }

    /**
     * 更新推送牛人管家成功的明细状态
     * @param successCodes 明细编码集合
     */
    public void updateDetailPlanCowManagerState(List<String> successCodes) {
        if(CollectionUtils.isEmpty(successCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItem> updateWrapper = new UpdateWrapper<ActivityDetailPlanItem>().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getCowManagerState, InterfacePushStateEnum.SUCCESS.getCode());
        updateWrapper.eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode());
        updateWrapper.in(ActivityDetailPlanItem::getDetailPlanItemCode, successCodes);
        this.update(updateWrapper);
    }

    /**
     * 更新推送Sap成功的明细状态
     * @param code 明细编码
     * @param success 成功标记
     */
    public void updateDetailPlanSapState(String code,boolean success) {
        if(StringUtils.isBlank(code)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItem> updateWrapper = new UpdateWrapper<ActivityDetailPlanItem>().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getSapInterfaceState, success ? InterfacePushStateEnum.SUCCESS.getCode() : InterfacePushStateEnum.FAIL.getCode());
        updateWrapper.eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode());
        updateWrapper.eq(ActivityDetailPlanItem::getDetailPlanItemCode, code);
        this.update(updateWrapper);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<ActivityDetailPlanItemVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        for (ActivityDetailPlanItemVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityDetailPlanItemVo item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityDetailPlanItemVo.class);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoListProperties(List<ActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (ActivityDetailPlanItemDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoProperties(ActivityDetailPlanItemDto item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityDetailPlanItemDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }


    public List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(String beginDate, String endDate, String mainCode, List<String> inConditionList) {
        return activityDetailPlanItemMapper.findSubComActivityDetailByYearMonth(beginDate, endDate, mainCode, inConditionList, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Page<ActivityDetailPlanItemVo> page, List<String> customerCodeInStrList, ActivityDetailPlanItemDto upwardDto, String upAccountStatus, String processStatus, Set<String> excludeActivityTypeCodeSet) {
        upwardDto.setTenantCode(TenantUtils.getTenantCode());
        return activityDetailPlanItemMapper.findUpwardDetailForWithholding(page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, excludeActivityTypeCodeSet);
    }

    public Map<String,String> findItemCodesByDetailPlanCodes(String planCode) {
        List<ActivityDetailPlanItemVo> itemList = activityDetailPlanItemMapper.findItemCodesByDetailPlanCodes(planCode, TenantUtils.getTenantCode());
        Map<String,String> map = new HashMap<>();
        if (CollectionUtils.isEmpty(itemList)) {
            return map;
        }
        itemList.forEach(item -> {
            if (!StringUtils.isBlank(item.getDetailPlanItemCode()) && !StringUtils.isBlank(item.getActivityOrgCode())) {
                map.put(item.getDetailPlanItemCode(),item.getActivityOrgCode());
            }
        });
        return map;
    }


    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {

        return activityDetailPlanItemMapper.redPacketQueryScheme(dto2);
    }
    public BigDecimal findByCode(String detailPlanItemCode) {
        return activityDetailPlanItemMapper.findByCode(detailPlanItemCode, TenantUtils.getTenantCode());
    }

    public List<String> findApprovedDetailItemCodeListByPlanItemCodeList(List<String> planItemCodeList) {
        return activityDetailPlanItemMapper.findApprovedDetailItemCodeListByPlanItemCodeList(planItemCodeList);
    }

    public int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(activityDetailPlanItemDto.getDetailPlanItemCode())){
            if (activityDetailPlanItemDto.getDetailPlanItemCode().contains(",") || activityDetailPlanItemDto.getDetailPlanItemCode().contains(" ")){
                activityDetailPlanItemDto.setDetailPlanItemCodeList(Arrays.asList(activityDetailPlanItemDto.getDetailPlanItemCode().split("[, ，]")));
                activityDetailPlanItemDto.setDetailPlanItemCode(null);
            }
        }
        return this.activityDetailPlanItemMapper.findTotalForAudit(activityDetailPlanItemDto);
    }

    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param itemNos 方案明细编码
     * @return List<String>
     **/
    public List<String> getNoClosePlanItemNo(List<String> itemNos){
        if (CollectionUtils.isEmpty(itemNos)) {
            return Lists.newArrayList();
        }
        return activityDetailPlanItemMapper.getNoClosePlanItemNo(itemNos,TenantUtils.getTenantCode());
    }

    /**
     * 查询可自动核销数据
     * @param autoAuditParams 查询参数
     * @return List
     */
    public Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(Page<ActivityDetailPlanItemVo> page, AutoAuditParamsDto autoAuditParams){

        List<ActivityDetailPlanItemVo> resultList = Lists.newArrayList();

        Page<ActivityDetailPlanItemVo> itemPage = activityDetailPlanItemMapper.findCanAutoAuditItemPage(page, autoAuditParams);
        List<ActivityDetailPlanItemVo> itemList = itemPage.getRecords();
        if (CollUtil.isEmpty(itemList)){
            return itemPage;
        }

        String endCaseForm = autoAuditParams.getEndCaseForm();
        List<String> endCaseFormList = null;
        if (CharSequenceUtil.isNotEmpty(endCaseForm)){
            endCaseFormList = Arrays.asList(endCaseForm.split(","));
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");

        for (ActivityDetailPlanItemVo item : itemList) {
            //根据结案形式进行过滤
            if (CollUtil.isNotEmpty(endCaseFormList)){
                String auditForm = item.getAuditForm();
                if (CharSequenceUtil.isEmpty(auditForm) && CharSequenceUtil.isNotEmpty(autoAuditParams.getEndCaseForm())) {
                    continue;
                }
                List<String> list = Arrays.asList(auditForm.split(","));
                List<String> filterEndCaseFormList = Lists.newArrayList();
                for (String s : list) {
                    if (endCaseFormList.contains(s)){
                        filterEndCaseFormList.add(s);
                    }
                }
                if (CollUtil.isEmpty(filterEndCaseFormList)){
                    continue;
                }
            }

            try {
                item.setFeeYearMonth(format.parse( format.format(item.getFeeYearMonth())));
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }

            resultList.add(item);
        }
        itemPage.setRecords(resultList);

        return itemPage;
    }

    /**
     * 分页查询，方案未关闭，细案已关闭，细案未回退预算的数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    public Page<ActivityDetailPlanItemVo> findNoRollBackByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findNoRollBackByConditions(page, activityDetailPlanItemDto);
        return pageList;
    }

    public Integer getSubRelatedItemTotal(ActivityDetailPlanItemDto dto) {
        return activityDetailPlanItemMapper.getSubRelatedItemTotal(dto);
    }

    public List<ActivityDetailPlanItemVo> getDetailItemList(Integer num,Integer pageSize, ActivityDetailPlanItemDto dto) {
        return activityDetailPlanItemMapper.getDetailItemList(num,pageSize, dto);
    }

    /**
     * 查询 预估核销金额
     * @param set
     * @return
     */
    public List<ActivityDetailPlanItemVo> findByCodes(Set<String> set) {
        return this.activityDetailPlanItemMapper.findByCodes(set);
    }

    public List<ActivityDetailPlanItemVo> listForVariable(ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.listForVariable(dto, TenantUtils.getTenantCode());
    }





    @Override
    public List<ActivityDetailPlanItem> list(Wrapper<ActivityDetailPlanItem> queryWrapper) {
        List<ActivityDetailPlanItem> list = super.list(queryWrapper);
        if (!CollectionUtils.isEmpty(list)){
            List<String> idList = list.stream().map(ActivityDetailPlanItem::getId).collect(Collectors.toList());
            List<ActivityDetailPlanItemExtend> extendEntityList = activityDetailPlanItemExtendRepository.listByIds(idList);
            if (!CollectionUtils.isEmpty(extendEntityList)){
                Map<String, ActivityDetailPlanItemExtend> extendMap = extendEntityList.stream().collect(Collectors.toMap(ActivityDetailPlanItemExtend::getId, Function.identity()));
                String[] ignoreFieldArr = ActivityDetailPlanItemExtendRepository.excludeFieldList.toArray(new String[]{});
                for (ActivityDetailPlanItem activityDetailPlanItem : list) {
                    ActivityDetailPlanItemExtend activityDetailPlanItemExtend = extendMap.get(activityDetailPlanItem.getId());
                    if (null != activityDetailPlanItemExtend){
                        BeanUtil.copyProperties(activityDetailPlanItemExtend,activityDetailPlanItem,ignoreFieldArr);
                    }
                }
            }

            List<String> detailPlanItemCodeList = list.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toList());
            List<ActivityDetailPlanProduct> productList = activityDetailPlanProductRepository.listByDetailPlanItemCodes(detailPlanItemCodeList);
            if (!CollectionUtils.isEmpty(productList)){
                Map<String, List<ActivityDetailPlanProduct>> productMap = productList.stream().collect(Collectors.groupingBy(ActivityDetailPlanProduct::getDetailPlanItemCode));
                for (ActivityDetailPlanItem activityDetailPlanItem : list) {
                    if(!productMap.containsKey(activityDetailPlanItem.getDetailPlanItemCode())){
                        continue;
                    }
                    List<ActivityDetailPlanProduct> itemProductList = productMap.get(activityDetailPlanItem.getDetailPlanItemCode());
                    String productCode = itemProductList.stream().map(ActivityDetailPlanProduct::getProductCode).collect(Collectors.joining(","));
                    activityDetailPlanItem.setProductCode(productCode);
                    String productName = itemProductList.stream().map(ActivityDetailPlanProduct::getProductName).collect(Collectors.joining(","));
                    activityDetailPlanItem.setProductName(productName);
                }
            }
        }
        return list;
    }

    //有副表，重写下几个增删改方法
    @Override
    public boolean save(ActivityDetailPlanItem entity) {
        String productCode = entity.getProductCode();
        String productName = entity.getProductName();
        boolean save = super.save(entity);

        //保存下副表
        ActivityDetailPlanItemExtend extendEntity = BeanUtil.copyProperties(entity,ActivityDetailPlanItemExtend.class);
        extendEntity.setId(null);
        activityDetailPlanItemExtendRepository.save(extendEntity);

        return save;
    }

    @Override
    public boolean saveOrUpdate(ActivityDetailPlanItem entity, Wrapper<ActivityDetailPlanItem> updateWrapper) {
        boolean result = super.saveOrUpdate(entity, updateWrapper);

//        activityDetailPlanItemExtendRepository.removeById(entity.getId());
        //保存下副表
        ActivityDetailPlanItemExtend extendEntity = BeanUtil.copyProperties(entity,ActivityDetailPlanItemExtend.class);
        if (activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)){
            activityDetailPlanItemExtendRepository.saveOrUpdate(extendEntity);
        }

        return result;
    }

    @Override
    public boolean saveBatch(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.saveBatch(entityList, batchSize);

        List<ActivityDetailPlanItemExtend> extendEntityList = org.apache.commons.compress.utils.Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = BeanUtil.copyProperties(entity,ActivityDetailPlanItemExtend.class);
            if (activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) {
                extendEntityList.add(extendEntity);
            }
        }
        if (!CollectionUtils.isEmpty(extendEntityList)){
            //保存下副表
            activityDetailPlanItemExtendRepository.saveBatch(extendEntityList,batchSize);
        }

        return result;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);

        List<ActivityDetailPlanItemExtend> extendEntityList = org.apache.commons.compress.utils.Lists.newArrayList();
        List<String> idList = Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = BeanUtil.copyProperties(entity,ActivityDetailPlanItemExtend.class);
            if (activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)){
                extendEntityList.add(extendEntity);
            }
            idList.add(entity.getId());
        }
//        activityDetailPlanItemExtendRepository.removeByIds(idList);
        if (!CollectionUtils.isEmpty(extendEntityList)){
            //保存下副表
            activityDetailPlanItemExtendRepository.saveOrUpdateBatch(extendEntityList,batchSize);
        }
        return result;
    }

    @Override
    public boolean updateBatchById(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.updateBatchById(entityList, batchSize);

        List<ActivityDetailPlanItemExtend> extendEntityList = org.apache.commons.compress.utils.Lists.newArrayList();
        List<String> idList = Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = BeanUtil.copyProperties(entity,ActivityDetailPlanItemExtend.class);
            if (activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)){
                extendEntityList.add(extendEntity);
            }
            idList.add(entity.getId());
        }
//        activityDetailPlanItemExtendRepository.removeByIds(idList);
        if (!CollectionUtils.isEmpty(extendEntityList)){
            //保存下副表
            activityDetailPlanItemExtendRepository.saveOrUpdateBatch(extendEntityList,batchSize);
        }

        return result;
    }

    public void updateHeadStatus(List<String> itemCodeList) {
        activityDetailPlanItemMapper.updateHeadStatus(itemCodeList);
    }

    public ActivityDetailPlanItemVo getDetailPlanItemByCode(String itemCode) {
        if (CharSequenceUtil.isEmpty(itemCode)) {
            return null;
        }
        return this.baseMapper.getDetailPlanItemByCode(itemCode, TenantUtils.getTenantCode());

    }

    public List<ActivityDetailPlanItem> findByIdList(List<String> ids) {
        return this.lambdaQuery()
                .in(ActivityDetailPlanItem::getId, ids)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public Integer getExtractAuditDetailPlanCheckDataTotal(ActivityDetailPlanItemDto selectDto) {
        return this.baseMapper.getExtractAuditDetailPlanCheckDataTotal(selectDto);

    }

    public List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(ActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize) {
        return this.baseMapper.extractAuditDetailPlanCheckData(selectDto,pageNumber,pageSize);

    }

    /**
     * 根据关联方案明细编码查询细案明细
     * @param planItemCode
     * @return
     */
    public List<ActivityDetailPlanItem> findListByRelatePlanItemCode(String planItemCode) {
        if(StringUtils.isBlank(planItemCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery().eq(ActivityDetailPlanItem::getRelatePlanItemCode,planItemCode)
                .eq(ActivityDetailPlanItem::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode,TenantUtils.getTenantCode())
                .list();
    }

    public List<ActivityDetailPlanItem> findByRegionPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByRegionPlanItemCodes(planItemCodes);
    }

    /**
     * 根据方案明细编码或方案编码查关联细案明细数量
     *
     * @param detailPlanItemCodes
     * @param planCodes
     * @return
     */
    public Integer findByItemCodesOrPlanCods(Set<String> detailPlanItemCodes, Set<String> planCodes) {
        return this.baseMapper.findByItemCodesOrPlanCods(detailPlanItemCodes,planCodes,TenantUtils.getTenantCode());
    }

    /**
     * 根据总部方案编码查关联方案的细案明细
     *
     * @param cods
     * @return
     */
    public List<ActivityDetailPlanItemVo> findByPlanCodes(Set<String> cods) {
        return this.baseMapper.findByPlanCodes(cods,TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanItem> findByPlanItemCode(String planItemCode) {
        if(StringUtils.isBlank(planItemCode)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByPlanItemCode(planItemCode);
    }

    /**
     * 根据活动方案编码查 细案明细
     *
     * @param set
     * @return
     */
    public List<ActivityDetailPlanItemVo> findByPlanItemCodes(Set<String> set) {
        return activityDetailPlanItemMapper.findByPlanItemCodes(set,TenantUtils.getTenantCode());
    }

    public List<String> findDetailItemCodesByPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        return activityDetailPlanItemMapper.findDetailItemCodesByPlanItemCodes(planItemCodes);
    }

    public List<ActivityDetailPlanItemVo> findByRelatePlanItemCodes(Set<String> set) {
        List<ActivityDetailPlanItem> list = this.lambdaQuery().in(ActivityDetailPlanItem::getRelatePlanItemCode, set)
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .list();

        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(list,ActivityDetailPlanItem.class,ActivityDetailPlanItemVo.class,HashSet.class,ArrayList.class));
    }

    public List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return this.activityDetailPlanItemMapper.findByConditionsList(activityDetailPlanItemDto);
    }

    public Page<ActivityDetailPlanItemsExportsVo> findExportListByDetailPlanCodes(Pageable pageable,List<String> detailPlanCodes){
        Page<ActivityDetailPlanItemsExportsVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (CollectionUtils.isEmpty(detailPlanCodes)){
            page.setTotal(0);
            return page;
        }
        return this.activityDetailPlanItemMapper.findExportListByDetailPlanCodes(page,TenantUtils.getTenantCode(),detailPlanCodes);
    }

    public void updateAuditStatusByActivityDetailCodes(List<String> newActivityDetailCodes, List<String> delActivityDetailCodes, ProcessStatusEnum processStatus) {
        if(!CollectionUtils.isEmpty(newActivityDetailCodes)){
            this.lambdaUpdate().eq(ActivityDetailPlanItem::getDetailPlanItemCode,newActivityDetailCodes)
                    .eq(ActivityDetailPlanItem::getTenantCode,TenantUtils.getTenantCode())
                    .set(ActivityDetailPlanItem::getAuditProcessStatus,processStatus.getDictCode())
                    .update();
        }
        if(!CollectionUtils.isEmpty(delActivityDetailCodes)){
            this.lambdaUpdate().eq(ActivityDetailPlanItem::getDetailPlanItemCode,newActivityDetailCodes)
                    .eq(ActivityDetailPlanItem::getTenantCode,TenantUtils.getTenantCode())
                    .set(ActivityDetailPlanItem::getAuditProcessStatus,null)
                    .update();
        }
    }

    public List<ActivityDetailPlanItemDto> findListByDetailCodesForRedPayLedger(List<String> businessNoList) {
        if(CollectionUtils.isEmpty(businessNoList)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItems = this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanCode, businessNoList)
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTemplateConfigCode, "HDMBPZ0062")
                .list();
        if(CollectionUtils.isEmpty(activityDetailPlanItems)){
            return Lists.newArrayList();
        }
        Collection<ActivityDetailPlanItemDto> activityDetailPlanItemDtos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemDto>) activityDetailPlanItemDtos;
    }

    public Collection<String> findDetailPlanCodeListByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanItem.class)
                .in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodeList)
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .select(ActivityDetailPlanItem::getDetailPlanCode)
        ).stream().map(ActivityDetailPlanItem::getDetailPlanCode).distinct().collect(Collectors.toList());
    }

    /**
     * 查询对应的分组数据，ect系统用
     * @param dto
     * @param pageable
     * @return
     */
    public Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        Page<DiscountAccountFeeGroupVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DiscountAccountFeeGroupVo> pageList = this.activityDetailPlanItemMapper.findPageStatisDiscountAccountFee(page, dto);
        return pageList;
    }


    public Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Page<ActivityDetailPlanItemVo> page,ActivityDetailPlanItemDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.findConditionByPlanCodes(page,dto);
    }

    /**
     * 细案明细编查询（物料采购单用）
     * @param pageable
     * @param activityDetailPlanItemDto
     * @return
     */
    public Page<ActivityDetailPlanItemVo> findItemForMaterialPurchasing(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if(Objects.isNull(activityDetailPlanItemDto) && StringUtils.isBlank(activityDetailPlanItemDto.getMaterialCode())){
            return new Page<>();
        }
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findItemForMaterialPurchasing(page, activityDetailPlanItemDto);
        return pageList;
    }

    public List<ActivityDetailPlanItem> findByDetailPlanCodes(List<String> detailPlanCode) {
        if (CollectionUtils.isEmpty(detailPlanCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanItem::getDetailPlanCode,detailPlanCode)
                .eq(ActivityDetailPlanItem::getTenantCode,TenantUtils.getTenantCode())
                .list();
    }

    public List<ActivityDetailPlanItemVo> findChangeStatus(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayListWithCapacity(0);
        }
        return this.activityDetailPlanItemMapper.findChangeStatus(detailPlanItemCodes,TenantUtils.getTenantCode());
    }

    public Page<String> findByDtoForPrediction(Page<String> page, ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.findByDtoForPrediction(page, dto);
    }

    public Page<BusinessUnitSetTable> findListForFR(Page<BusinessUnitSetTable> page, List<String> yearMonths) {
        return this.activityDetailPlanItemMapper.findListForFR(page,yearMonths);
    }

    public List<ActivityDetailPlanItemVo> findListByDetailPlanCode(String detailPlanCode) {
        if(StringUtils.isBlank(detailPlanCode)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> list = this.lambdaQuery().eq(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCode)
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .list();

        Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
    }

    public void useProductNumber(ActivityDetailPlanItemVo item) {
        if (Objects.isNull(item)
                || StringUtil.isEmpty(item.getDetailPlanItemCode())
                || Objects.isNull(item.getPeriodPromotionalNumberUse())) {
            return;
        }
        this.activityDetailPlanItemMapper.useProductNumber(item);
    }

    public void updateActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes, List<String> thisDelActivityDetailCodes) {
        if(StringUtils.isBlank(code)){
            return;
        }
        if(!CollectionUtils.isEmpty(thisNewActivityDetailCodes)){
            this.activityDetailPlanItemExtendRepository.addActivityDetailPurchasingOrder(code,thisNewActivityDetailCodes);
        }
        if(!CollectionUtils.isEmpty(thisDelActivityDetailCodes)){
            this.activityDetailPlanItemExtendRepository.delActivityDetailPurchasingOrder(code,thisDelActivityDetailCodes);
        }
    }

    public void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus) {
        if(StringUtils.isBlank(processStatus)){
            return;
        }
        if(CollectionUtils.isEmpty(activityDetailItemCodes)){
            return;
        }
        this.activityDetailPlanItemExtendRepository.updateActivityDetailPurchasingOrderProcessStatus(activityDetailItemCodes,processStatus);
    }

    public List<AuditCustomerDetailCollectionVo> findAuditDetailListByDetailPlanCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findAuditDetailListByDetailPlanCodeList(detailPlanItemCodeList,TenantUtils.getTenantCode());
    }

    /**
     * 重复活动细案查看
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    public Page<ActivityDetailPlanItemVo> repeatActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto, ActivityDetailPlanItemDto sourceDto) {
        if(Objects.isNull(sourceDto)){
            return new Page<>();
        }
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new ActivityDetailPlanItemDto());
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        String detailPlanItemCode = dto.getDetailPlanItemCode();
        if (StringUtils.isNotBlank(detailPlanItemCode)) {
            detailPlanItemCode = detailPlanItemCode.trim().replaceAll("\\s+", " ");
            List<String> detailPlanItemCodeList = Arrays.asList(detailPlanItemCode.trim().split(" "));
            dto.setDetailPlanItemCode(null);
            dto.setDetailPlanItemCodeList(detailPlanItemCodeList);
        }
        if (StringUtil.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtil.isEmpty(sourceDto.getTenantCode())) {
            sourceDto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.activityDetailPlanItemMapper.repeatActivityDetailPlanItemPage(page, dto,sourceDto);
    }
}
