package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemTerminal;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemTerminalMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 18:05
 * @description：活动细案终端明细数据库访问层
 */
@Component
public class ActivityDetailPlanItemTerminalRepository extends ServiceImpl<ActivityDetailPlanItemTerminalMapper, ActivityDetailPlanItemTerminal> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanItemMapper activityDetailPlanItemMapper;


    public List<ActivityDetailPlanItemTerminalDto> findTerminalDtoListByDetailItemCodeList(List<String> detailItemCodeList) {
        List<ActivityDetailPlanItemTerminalDto> list = Lists.newArrayList();
        if(CollectionUtils.isEmpty(detailItemCodeList)){
            return list;
        }
        List<ActivityDetailPlanItemTerminal> terminalList = this.list(Wrappers.lambdaQuery(ActivityDetailPlanItemTerminal.class)
                .in(ActivityDetailPlanItemTerminal::getDetailPlanItemCode, detailItemCodeList)
                .eq(ActivityDetailPlanItemTerminal::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItemTerminal::getTenantCode, TenantUtils.getTenantCode()));
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(terminalList, ActivityDetailPlanItemTerminal.class, ActivityDetailPlanItemTerminalDto.class, HashSet.class, ArrayList.class));
    }

    public List<ActivityDetailPlanReportVo> findTerminalVoListByDetailItemCode(String detailPlanItemCode) {
        List<ActivityDetailPlanReportVo> list = Lists.newArrayList();
        if(StringUtils.isEmpty(detailPlanItemCode)){
            return list;
        }
        return activityDetailPlanItemMapper.findTerminalVoListByDetailItemCode(detailPlanItemCode);
    }

    /**
     * 根据细案明细编码查询门店详情
     *
     * @param pageable
     * @param detailPlanItemCode
     * @return
     */
    public Page<ActivityDetailPlanItemTerminalVo> findTerminalByDetailPlanItemCode(Pageable pageable, String detailPlanItemCode) {
        Page<ActivityDetailPlanItemTerminalVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findTerminalByDetailPlanItemCode(page, detailPlanItemCode,TenantUtils.getTenantCode());
    }
}
