package com.biz.crm.tpm.business.activity.detail.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanPlanMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * 活动细案-关联活动方案表(ActivityDetailPlanPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-11-12 17:52:10
 */
@Component
public class ActivityDetailPlanPlanRepository extends ServiceImpl<ActivityDetailPlanPlanMapper, ActivityDetailPlanPlan> {

    @Autowired(required = false)
    private ActivityDetailPlanPlanMapper activityDetailPlanPlanMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据细案编码查询方案关联策略数据
     * @param detailPlanCode 细案编码
     * @return 细案关联方案数据
     */
    public List<ActivityDetailPlanPlanVo> findListVoByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return null;
        }
        List<ActivityDetailPlanPlanVo> list = activityDetailPlanPlanMapper.findListVoByDetailPlanCode(detailPlanCode);
        for (ActivityDetailPlanPlanVo item : list) {
            BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
            item.setUsedAmount(usedAmount);
            item.setUsableAmount(feeAmount.subtract(usedAmount));
        }
        return list;
    }

    public List<ActivityDetailPlanPlan> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanPlan.class)
                .eq(ActivityDetailPlanPlan::getDetailPlanCode, detailPlanCode)
                .eq(ActivityDetailPlanPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanPlan> updateWrapper = new UpdateWrapper<ActivityDetailPlanPlan>().lambda();
        updateWrapper.set(ActivityDetailPlanPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanPlan::getId, ids);
        this.update(updateWrapper);
    }

    /**
     * 根据细案编码获取
     * @param detailPlanCode
     * @return
     */
    public List<ActivityDetailPlanPlanVo> findActPlan(String detailPlanCode) {
        return  activityDetailPlanPlanMapper.findActPlan(detailPlanCode);
    }
    /**
     * 根据活动方案编码获取活动方案和活动细案关系
     *
     * @param planCodeList
     * @return
     */
    public List<ActivityDetailPlanPlan> findDetailPlanAndPlanList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanPlan::getPlanCode, planCodeList)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(TenantFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public void deleteByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanPlan> updateWrapper = new UpdateWrapper<ActivityDetailPlanPlan>().lambda();
        updateWrapper.set(ActivityDetailPlanPlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityDetailPlanPlan::getDetailPlanCode, detailPlanCode);
        this.update(updateWrapper);
    }

    public List<ActivityDetailPlanBudgetVo> findForSalesApproval(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanPlanMapper.findForSalesApproval(detailPlanItemCodes);
    }
}

