package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/29 16:57
 * @description：活动细案产品分摊
 */
@Component
public class ActivityDetailPlanProductRepository extends ServiceImpl<ActivityDetailPlanProductMapper, ActivityDetailPlanProduct> {

    public List<ActivityDetailPlanProduct> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet) {
        List<ActivityDetailPlanProduct> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(activityDetailCodeSet)) {
            list = this.lambdaQuery().in(ActivityDetailPlanProduct::getDetailPlanItemCode, activityDetailCodeSet).list();
        }
        return list;
    }

    public void deleteByDetailPlanCode(String detailPlanCode) {
        if (StringUtil.isEmpty(detailPlanCode)){
            return;
        }
        LambdaQueryWrapper<ActivityDetailPlanProduct> updateWrapper = new LambdaQueryWrapper<ActivityDetailPlanProduct>();
        updateWrapper.eq(ActivityDetailPlanProduct::getDetailPlanCode, detailPlanCode);
        updateWrapper.eq(ActivityDetailPlanProduct::getTenantCode, TenantUtils.getTenantCode());

        this.remove(updateWrapper);
    }

    public List<ActivityDetailPlanProduct> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank(detailPlanCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanProduct.class)
                .eq(ActivityDetailPlanProduct::getDetailPlanCode, detailPlanCode)
                .eq(ActivityDetailPlanProduct::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public List<ActivityDetailPlanProduct> listByDetailPlanItemCodes(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanProduct.class)
                .in(ActivityDetailPlanProduct::getDetailPlanItemCode, detailPlanItemCodeList)
                .eq(ActivityDetailPlanProduct::getTenantCode, TenantUtils.getTenantCode())
        );
    }
}
