package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.BusinessUnitSetTable;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.BusinessUnitSetTableMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class BusinessUnitSetTableRepository extends ServiceImpl<BusinessUnitSetTableMapper, BusinessUnitSetTable> {

    public void removeByYearMonth(List<String> yearMonths) {
        if(CollectionUtils.isEmpty(yearMonths)){
            return;
        }
        this.lambdaUpdate()
                .eq(BusinessUnitSetTable::getTenantCode, TenantUtils.getTenantCode())
                .in(BusinessUnitSetTable::getYearMonthStr,yearMonths)
                .remove();

    }

    public List<BusinessUnitSetTable> findListForFR(List<BusinessUnitSetTable> tableList) {
        return this.baseMapper.findListForFR(tableList,TenantUtils.getTenantCode());
    }
}
