package com.biz.crm.tpm.business.activity.detail.plan.local.service;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;

import java.util.List;

/**
 * 活动细案预算
 * @author wanghaojia
 * @date 2023/1/10 20:37
 */
public interface ActivityDetailPlanBudgetService {

    /**
     * 保存月度预算
     */
    void saveActivityDetailPlanBudgetList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemDtoList);

    /**
     * 扣减月度预算
     */
    void useMonthBudgetByPlanCodeList(List<String> planCodeList);

    void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList);

    void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList, boolean doSave);

    /**
     * 活动细案明细编码退回月度预算
     * @param detailPlanItemCodeList
     */
    void returnMonthBudgetByDetailPlanCodeList(List<String> detailPlanItemCodeList);
    /**
     * 活动细案编码退回月度预算
     * @param detailPlanCodeList
     */
    void returnMonthBudgetByPlanCodeList(List<String> detailPlanCodeList);

    /**
     * 直接保存细案预算明细
     * @param activityDetailPlanBudgetList
     */
    void saveActivityDetailPlanBudgetList(List<ActivityDetailPlanBudget> activityDetailPlanBudgetList);

    void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList);

    List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> detailPlanItemCodes);
}
