package com.biz.crm.tpm.business.activity.detail.plan.local.service;


import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

/**
 * 营销策略(ActivityDetail) 异步方法
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:11
 */
public interface ActivityDetailPlanItemAsyncService {

    /**
     * 关闭推送SAP-SD
     *
     * @param itemCodeList 明细编码
     * @param userIdentity 用户信息
     */
    void closeSdActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity);

    /**
     * 关闭推送牛人管家
     *
     * @param itemCodeList 明细编码
     * @param userIdentity 用户信息
     */
    void closeCowManagerActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity);

    /**
     * 活动细案关闭推送mq
     * @param businessUnitCode 业务单元编码
     * @param itemCodeList 关闭的细案明细编码
     * @param userIdentity 当前登录人信息
     */
    void closeActivityDetailPlanItemMqPush(String businessUnitCode,List<String> itemCodeList, AbstractCrmUserIdentity userIdentity);
}

