package com.biz.crm.tpm.business.activity.detail.plan.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtendField;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanDetailPlanAndBudgetEditDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:06
 */
public interface ActivityDetailPlanItemService extends MnPageCacheService<ActivityDetailPlanItemVo,ActivityDetailPlanItemDto> {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    List<ActivityDetailPlanBudgetSumVo> findBudgetCacheSumList(String businessUnitCode, String cacheKey);

    /**
     * 保存活动细案明细数据-默认走校验逻辑
     *
     * @param itemCacheList 活动细案明细数据
     */
    void saveActivityDetailPlanItemList(ActivityDetailPlan entity,boolean update, List<ActivityDetailPlanItemDto> itemCacheList);

    /**
     * 保存活动细案明细数据
     *
     * @param itemCacheList  活动细案明细数据
     * @param createValidate 是否走校验逻辑
     */
    void saveActivityDetailPlanItemList(ActivityDetailPlan entity,boolean update, List<ActivityDetailPlanItemDto> itemCacheList, boolean createValidate,boolean tempSave);

    /**
     * 活动细案明细新增批量校验逻辑
     *
     * @param dtoList 活动细案明细数据
     */
    void createValidateList(ActivityDetailPlanDto planDto, List<ActivityDetailPlanItemDto> dtoList);


    /**
     * 根据活动细案编码删除活动细案明细数据
     * @param detailPlanCodes 细案编码集合
     */
    void deleteByDetailPlanCodes(List<String> detailPlanCodes);


    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto);

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto);

    /**
     * 核销分页查询活动细案
     * @param pageable
     * @param activityDetailPlanItemDto
     * @return
     */
    Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 核销修改是否完全核销和结案金额
     * @param activityDetailPlanItemDtos
     * @param chargeAgainstType
     */
    void changeActivityDetailAuditInfo(List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos);

    /**
     * 核销查询活动细案明细
     * @param activityDetails 明细编码
     * @return
     */
    List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails);

    /**
     * 活动细案明细关闭
     * @param ids
     */
    void closeItem(List<String> ids);

    /**
     * 根据关联活动方案明细编码关闭
     * @param businessNoList 活动方案明细编码集合
     */
    void closeByPlanCodeItemList(List<String> businessNoList);

    /**
     * 根据活动细案编码获取可推送的明细集合
     * @param detailPlanCodes 细案编码集合
     * @return 明细集合
     */
    List<ActivityDetailPlanItemVo> findByDetailPlanCode(List<String> detailPlanCodes);

    Page<ActivityDetailPlanItemsExportsVo> findExportListByDetailPlanCodes(Pageable pageable, List<String> detailPlanCodes);

    /**
     * 根据活动细案明细编码获取可推送的明细集合
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes);

    /**
     * 根据活动细案明细编码获取明细集合
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    List<ActivityDetailPlanItemVo> findDetailAndExtendByItemCodes(List<String> itemCodes);

    /**
     * 更新推送牛人管家成功的明细状态
     * @param successCodes 明细编码集合
     */
    void updateDetailPlanCowManagerState(List<String> successCodes);

    /**
     * 根据方案明细创建活动细案明细
     *  @param itemList
     * @param activityDetailPlan
     * @param generateRule
     * @param toDay
     * @param relateDetailItemDtoList
     */
    void createActivityDetailPlanItem(List<ActivityPlanItemDto> itemList, ActivityDetailPlan activityDetailPlan, String generateRule, String toDay, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList);

    /**
     * 更新推送SAP成功的明细状态
     * @param code 明细编码集合
     * @param success 成功标志
     */
    void updateDetailPlanSapState(String code,boolean success);

    <T1 extends ActivityPlanItemBase,T2 extends ActivityPlanItemTerminalDto> ActivityDetailPlanItem buildByActivityItemTerminal(ActivityDetailPlan activityDetailPlan, T1 item,
                                                                                                                                T2 activityPlanItemTerminalDto, String templateConfigCode, String toDay,
                                                                                                                                List<ActivityDetailPlanItemExtendField> extendFieldSaveList);

    /**
     * 获取总条数
     *
     * @param cacheKey
     * @return
     */
    Integer getTotal(String cacheKey);

    /**
     * 查询所有推送sap且在活动执行中的明细编码及其销售组织编码
     * @param planCode 细案编码
     * @return Map<String,String> key:明细编码，value：销售组织编码
     */
    Map<String,String> findItemCodesByDetailPlanCodes(String planCode);

    /**
     * 获取在审批中或审批通过的关联的细案数量
     * @param planItemCodeList 活动细案编码
     */
    List<String> findApprovedDetailItemCodeListByPlanItemCodeList(List<String> planItemCodeList);

    /**
     * 根据活动细案明细编码查询
     * @param detailPlanItemCode
     * @return
     */
    ActivityDetailPlanItemVo findDetailPlanItemByItemCode(String detailPlanItemCode);

    /**
     * 查询总数
     * @param activityDetailPlanItemDto
     * @return
     */
    int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto);

//    /**
//     * 查询可核销信息
//     * @param autoAuditParams 查询参数
//     * @return List
//     */
//    List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams);

    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param itemNos 方案明细编码
     * @return List<String>
     **/
    List<String> getNoClosePlanItemNo(List<String> itemNos);

    /**
     * 根据活动号判断同一活动号下面的方案是否都已关闭
     *
     * @param actNo 活动号
     * @return Boolean
     **/
    Boolean getAllColseByActNumber(String actNo);

    /**
     * 方案退预算，修改细案明细，修改细案预算明细（方案关闭）
     *
     * @param dto 参数
     **/
    void editPlanDetailPlanAndBudget(ActivityPlanDetailPlanAndBudgetEditDto dto);

    /**
     * 分页查询，方案未关闭，细案已关闭，细案未回退预算的数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findNoRollBackByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 细案退预算，修改细案明细，修改细案预算明细（细案单独关闭）
     *
     * @param dto 参数
     **/
    void editDetailPlanAndBudget(ActivityPlanDetailPlanAndBudgetEditDto dto);
    void updateCost(List<ActivityDetailPlanItemVo> items);

    void tempSaveValidate(List<ActivityDetailPlanItemDto> itemCacheList);

    void createValidateListForOut(List<ActivityDetailPlanItemDto> itemCacheList);

    void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList);

    List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 细案明细编查询（物料采购单用）
     * @param pageable
     * @param activityDetailPlanItemDto
     * @return
     */
    Page<ActivityDetailPlanItemVo> findItemForMaterialPurchasing(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);
    Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Pageable pageable, ActivityDetailPlanItemDto dto);

    /**
     * 重复活动细案查看
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-14 23:35
     */
    Page<ActivityDetailPlanItemVo> repeatActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto);
}

