package com.biz.crm.tpm.business.activity.detail.plan.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 活动细案(ActivityDetailPlan)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:06
 */
public interface ActivityDetailPlanItemTerminalService {

    List<ActivityDetailPlanReportVo> findTerminalListByDetailPlanItemCode(String detailPlanItemCode);

    /**
     * 根据细案明细编码查询门店详情
     *
     * @param pageable
     * @param detailPlanItemCode
     * @return
     */
    Page<ActivityDetailPlanItemTerminalVo> findTerminalByDetailPlanItemCode(Pageable pageable, String detailPlanItemCode);

    List<ActivityDetailPlanItemTerminalDto> findTerminalListByDetailPlanItemCodes(List<String> detailPlanItemCodes);
}

