package com.biz.crm.tpm.business.activity.detail.plan.local.service;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;

import java.util.List;

/**
 * 活动细案-关联方案服务
 *
 * @author wanghaojia
 * @date 2022/11/23 16:00
 */
public interface ActivityDetailPlanPlanService {


    /**
     * 保存活动细案-关联方案数据
     *
     * @param dtoList 活动细案-关联方案数据
     */
    void saveActivityDetailPlanPlanList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanPlanDto> dtoList);

    /**
     * 根据细案编码获取关联数据
     * @param detailPlanCode
     * @return
     */
    List<ActivityDetailPlanPlanVo> findActPlan(String detailPlanCode);
    /**
     * 根据活动方案编码查询活细案关系
     *
     * @param planCodeList
     * @return
     */
    List<ActivityDetailPlanPlan> findDetailPlanAndPlanList(List<String> planCodeList);

    /**
     * 活动细案创建关联方案信息记录-能力中心
     * @param entity
	 * @param relatePlanList
     * @author jiangyin
     * @date 2023/5/24 10:50
     * @return void
     */
    void createDetailLinkPlanForOut(ActivityDetailPlan entity, List<ActivityDetailPlanPlanDto> relatePlanList);

    /**
     * 销售费用批复表-专用
     * @param detailPlanItemCodes
     * @return
     */
    List<ActivityDetailPlanBudgetVo> findForSalesApproval(List<String> detailPlanItemCodes);
}
