package com.biz.crm.tpm.business.activity.detail.plan.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanOutDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanReportDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 活动细案服务接口
 * @author wanghaojia
 * @date 2022/11/22 15:47
 */
public interface ActivityDetailPlanService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto);

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanReportVo> findDetailByConditions(Pageable pageable, ActivityDetailPlanReportDto dto);

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanReportVo> findDetailByConditionsFotExport(Pageable pageable, ActivityDetailPlanReportDto dto);


    /**
     * 活动细案新增编辑
     * @param cacheKey 明细缓存key
     * @return
     */
    void saveActivityDetailPlan(ActivityDetailPlanDto dto, String cacheKey);

    /**
     * 通过id获取活动方案数据
     * @param id 活动方案id
     */
    ActivityDetailPlanVo findById(String id);

    /**
     * 查询月度预算数据
     */
    Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable, ActivityDetailPlanBudgetDto planBudgetDto,MonthBudgetDto dto);

    /**
     * 批量删除活动方案
     * @param ids 活动方案id集合
     */
    void delete(List<String> ids);

    /**
     * 活动细案提交审批
     * @param ids 选中提交的数据id
     * @param dto 工作流参数
     */
    void submitApproval(List<String> ids, ActivityDetailPlanApproveSubmitDto dto);

    /**
     * 细案客户汇总暴露操作预算接口
     *
     * @param detailPlanCodeList
     * @param operationType
     */
    void operateCustomerMonthBudgetByPlanCodeList(List<String> detailPlanCodeList, String operationType);

    /**
     * 流程审批通过
     */
    void processPass(ProcessStatusDto dto);
    /**
     * 流程审批驳回/追回
     */
    void processRejectAndRecover(ProcessStatusDto dto);

    /**
     * 批量创建细案
     * @param listDto
     */
    List<String> autoBatchCreate(ActivityPlanListDto listDto);

    /**
     * 流程审批通过构建数据
     * @param detailPlanCodeList 活动细案编码集合
     * @return 细案数据集合
     */
    List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList);

    /**
     * 红包查询活动细案
     * @param dto2
     * @return
     */
    List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2);

    /**
     * 获取自动核销的活动细案
     * @return
     */
    List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String autoDate);

    /**
     * 自动核销信息
     * @param page 分页
     * @param autoAuditParams 查询参数
     * @return List
     */
    List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams);

    List<ActivityDetailPlanVo> findCanAutoAudit(AutoAuditParamsDto autoAuditParams);

    int getDetailPlanNum(String autoDate, String businessUnitCode);

    int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams);

    void updateAutoAudit(String detailPlanCode);

    List<ActivityDetailPlan> findByPlanCode(String planCode);

    /**
     * 垂直活动方案，细案关闭回退预算
     */
    void syncBudgetRollbackVertical();

    /**
     * 修改标识
     * @param codes 活动编码
     * @param autoAudit 自动核销标识
     */
    void updateAutoAuditFlag(List<String> codes, String autoAudit);

    ActivityDetailPlanDto saveActivityDetailPlanNoCache(ActivityDetailPlanDto dto);
    /**
     * （主体）根据汇总维度进行汇总
     *
     * @param activityDetailPlanDto 查询
     */
    void summary(ActivityDetailPlanDto activityDetailPlanDto);

    ActivityDetailPlanDto atomicCreateForOut(ActivityDetailPlanDto dto);

    Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto dto);

    /**
     * 更新细案活动状态
     *
     * @param detailPlanCodeList
     * @param statusEnum
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-08-26 02:29
     */
    void updatePlanStatusByDetailPlanCodeList(List<String> detailPlanCodeList, ActivityPlanStatusEnum statusEnum);

    /**
     * 根据dto查询(扣费预测用)
     * @param dto
     * @return
     */
    Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto dto);

    /**
     *
     * @param planCodeList
     * @return
     */
    List<ActivityDetailPlanPlanVo> getDetailPlanInfoByPlanItemCodeList(List<String> planCodeList);

    /**
     * 结案核销审批通过更新方案明细已结案金额
     * @param detailItemAlreadyAuditAmountMap
     */
    void updatePlanAlreadyAmount(Map<String, BigDecimal> detailItemAlreadyAuditAmountMap);
}
