package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动细案预算
 * @author wanghaojia
 * @date 2023/1/10 20:37
 */
@Service
public class ActivityDetailPlanBudgetServiceImpl implements ActivityDetailPlanBudgetService {


    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlanBudgetList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemDtoList) {
        Map<String, ActivityDetailPlanBudget> oldMap = Maps.newHashMap();
        if (update){
//            List<ActivityDetailPlanBudget> oldList = activityDetailPlanBudgetRepository.listByDetailPlanCode(entity.getDetailPlanCode());
//            oldMap = oldList.stream().collect(Collectors.toMap(item -> {
//                return item.getDetailPlanItemCode() + item.getMonthBudgetCode() ;
//            }, Function.identity()));
            //直接物理删除新建吧。
            activityDetailPlanBudgetRepository.deletePhysicalByDetailPlanCode(entity.getDetailPlanCode());
        }

        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                itemDto.getBudgetShares().forEach(item -> {
                    item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    item.setDetailPlanCode(itemDto.getDetailPlanCode());
                    item.setIntraCompanyAmount(itemDto.getIntraCompanyAmount());
                    item.setCustomerCode(itemDto.getCustomerCode());
                });
            }
        }
        List<ActivityDetailPlanBudgetDto> budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemDto::getBudgetShares).filter(Objects::nonNull)
                .flatMap(Collection::stream).collect(Collectors.toList());
        List<ActivityDetailPlanBudget> list = (List<ActivityDetailPlanBudget>) nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList,ActivityDetailPlanBudgetDto.class,ActivityDetailPlanBudget.class, HashSet.class,ArrayList.class);

//        //找出分子公司点内金额不为空的分组为客户的预算项目
//        List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = list.stream().filter(o -> Objects.nonNull(o.getIntraCompanyAmount())).filter(o -> StringUtils.isNotEmpty(o.getCustomerCode())).collect(Collectors.toList());
//        //部门的预算编码+客户维度
//        Map<String,List<ActivityDetailPlanBudget>> activityDetailPlanBudgetMap = activityDetailPlanBudgetList.stream().collect(Collectors.groupingBy(o->o.getMonthBudgetCode()+":"+o.getCustomerCode()));
//        if(!CollectionUtils.isEmpty(activityDetailPlanBudgetMap.values())){
//
//            List<MonthBudgetDto> dtos = new ArrayList<>();
//            activityDetailPlanBudgetMap.forEach((key,value)->{
//                String[] split = key.split(":");
//                MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
//                monthBudgetDto.setBusinessFormatCode(entity.getBusinessFormatCode());
//                monthBudgetDto.setBusinessUnitCode(entity.getBusinessUnitCode());
//                monthBudgetDto.setMonthBudgetCode(split[0]);
//                monthBudgetDto.setCustomerCode(split[1]);
//                dtos.add(monthBudgetDto);
//            });
//
//            List<MonthBudgetVo> customerMonthBudgetVoList = monthBudgetService.findCustomerGroupMonthBudget(dtos);
//            Map<String, MonthBudgetVo> customerMonthBudgetVoMap = customerMonthBudgetVoList.stream().collect(Collectors.toMap(o -> o.getDepartMonthBudgetCode() + o.getCustomerCode(), Function.identity()));
//            for (ActivityDetailPlanBudget activityDetailPlanBudget : activityDetailPlanBudgetList) {
//                MonthBudgetVo monthBudgetVo = customerMonthBudgetVoMap.get(activityDetailPlanBudget.getMonthBudgetCode() + activityDetailPlanBudget.getCustomerCode());
//                ActivityDetailPlanBudget monthBudget = new ActivityDetailPlanBudget();
//                monthBudget.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
//                monthBudget.setUseAmount(activityDetailPlanBudget.getIntraCompanyAmount());
//                monthBudget.setRelatePlanCode(activityDetailPlanBudget.getRelatePlanCode());
//                monthBudget.setRelatePlanItemCode(activityDetailPlanBudget.getRelatePlanItemCode());
//                monthBudget.setDetailPlanCode(activityDetailPlanBudget.getDetailPlanCode());
//                monthBudget.setDetailPlanItemCode(activityDetailPlanBudget.getDetailPlanItemCode());
//                monthBudget.setOccupyType("1");
//                list.add(monthBudget);
//            }
//        }
        List<ActivityDetailPlanBudget> saveList = Lists.newArrayList();
        List<ActivityDetailPlanBudget> updateList = Lists.newArrayList();
        for (ActivityDetailPlanBudget item : list) {
//            String key = item.getDetailPlanItemCode() + item.getMonthBudgetCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
                item.setDetailPlanCode(entity.getDetailPlanCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityDetailPlanBudgetRepository.updateBatchById(updateList);
        }
//        if (oldMap.size() > 0){
//            //待删除的数据
//            List<String> deleteIds = oldMap.values().stream().map(ActivityDetailPlanBudget::getId).collect(Collectors.toList());
//            activityDetailPlanBudgetRepository.deleteByIds(deleteIds);
//        }
    }

    /**
     * 扣减月度预算
     */
    @Override
    public void useMonthBudgetByPlanCodeList(List<String> planCodeList){
        List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)){
            return;
        }
        List<ActivityDetailPlanBudgetDto> budgetList = (List<ActivityDetailPlanBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetDto.class, HashSet.class, ArrayList.class);
        useMonthBudget(budgetList);
    }

    /**
     * 扣减月度预算
     */
    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList){
        useMonthBudget(budgetList,true);
    }
    /**
     * 扣减月度预算
     */
    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList,boolean doSave){
        List<OperateMonthBudgetDto> budgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setIndexNo(item.getIndexNo());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(item.getUseAmount());
                this.setDoSave(doSave);
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }

        //2、占用方案预算的
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType())
                    && StringUtils.isNotEmpty(item.getRelatePlanItemCode());
        }).map(item -> {
            return new OperateActivityPlanBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setPlanCode(item.getRelatePlanCode());
                this.setIndexNo(item.getIndexNo());
                this.setPlanItemCode(item.getRelatePlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(item.getUseAmount());
                this.setDoSave(doSave);
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
        //2、占用客户的
        List<OperateActivityPlanBudgetDto> customerBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType())
                    && StringUtils.isNotEmpty(item.getRelatePlanItemCode());
        }).map(item -> {
            return new OperateActivityPlanBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setIndexNo(item.getIndexNo());
                this.setPlanCode(item.getRelatePlanCode());
                this.setPlanItemCode(item.getRelatePlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(item.getUseAmount());
                this.setDoSave(doSave);
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerBudgetOperateList)){
            activityPlanSdkService.operateCustomerBudget(customerBudgetOperateList);
        }
    }

    /**
     * 活动细案明细编码退回月度预算
     * @param detailPlanItemCodeList
     */
    @Override
    public void returnMonthBudgetByDetailPlanCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)){
            return;
        }
        List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanItemCodeList(detailPlanItemCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)){
            return;
        }
        returnMonthBudget(activityPlanBudgets);
    }

    /**
     * 活动细案明细编码退回月度预算
     * @param detailPlanCodeList
     */
    @Override
    public void returnMonthBudgetByPlanCodeList(List<String> detailPlanCodeList){
        if (CollectionUtils.isEmpty(detailPlanCodeList)){
            return;
        }
        List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanCodeList(detailPlanCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)){
            return;
        }
        returnMonthBudget(activityPlanBudgets);
    }

    /**
     * 直接保存细案明细
     * @param activityDetailPlanBudgetList
     */
    @Override
    public void saveActivityDetailPlanBudgetList(List<ActivityDetailPlanBudget> activityDetailPlanBudgetList) {
        if(!CollectionUtils.isEmpty(activityDetailPlanBudgetList)){
            activityDetailPlanBudgetList.forEach(item->{
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            activityDetailPlanBudgetRepository.saveBatch(activityDetailPlanBudgetList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList) {
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                itemDto.getBudgetShares().forEach(item -> {
                    item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    item.setDetailPlanCode(itemDto.getDetailPlanCode());
                    item.setIntraCompanyAmount(itemDto.getIntraCompanyAmount());
                    item.setCustomerCode(itemDto.getCustomerCode());
                });
            }
        }
        List<ActivityDetailPlanBudgetDto> budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemDto::getBudgetShares).filter(Objects::nonNull)
                .flatMap(Collection::stream).collect(Collectors.toList());
        List<ActivityDetailPlanBudget> list = (List<ActivityDetailPlanBudget>) nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList,ActivityDetailPlanBudgetDto.class,ActivityDetailPlanBudget.class, HashSet.class,ArrayList.class);
        List<ActivityDetailPlanBudget> saveList = Lists.newArrayList();
        for (ActivityDetailPlanBudget item : list) {
            item.setDetailPlanCode(entity.getDetailPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }
        return activityDetailPlanBudgetRepository.findPlanItemCodeByActivityDetailItemCodes(detailPlanItemCodes);
    }

    /**
     * 扣减月度预算
     */
    public void returnMonthBudget(List<ActivityDetailPlanBudget> budgetList){
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    StringUtils.isNotEmpty(item.getRelatePlanItemCode())
                    && ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateActivityPlanBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setPlanCode(item.getRelatePlanCode());
                this.setPlanItemCode(item.getRelatePlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanSdkService.operateBudget(planBudgetOperateList);
        }

        List<OperateMonthBudgetDto> budgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        //2、占用客户的
        List<OperateActivityPlanBudgetDto> customerBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType())
                    && StringUtils.isNotEmpty(item.getRelatePlanItemCode());
        }).map(item -> {
            return new OperateActivityPlanBudgetDto(){{
                this.setBusinessCode(item.getDetailPlanItemCode());
                this.setPlanCode(item.getRelatePlanCode());
                this.setPlanItemCode(item.getRelatePlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerBudgetOperateList)){
            activityPlanSdkService.operateCustomerBudget(customerBudgetOperateList);
        }
    }


}
