package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetVerticalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.OperateActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/16 18:05
 * @description: 细案关联预算数据(垂直)实现
 */
@Service
@Slf4j
public class ActivityDetailPlanBudgetVerticalServiceImpl implements ActivityDetailPlanBudgetVerticalService {

    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;




    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(List<OperateActivityDetailPlanBudgetDto> operateList) {
        List<ActivityDetailPlanBudget> activityPlanBudgets = validateOperateBudget(operateList);
        Map<String, List<ActivityDetailPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudget::getDetailPlanItemCode));
        for (OperateActivityDetailPlanBudgetDto operateMonthBudgetDto : operateList) {
            log.error("退预算活动细案编码：{}",operateMonthBudgetDto.getDetailPlanItemCode());
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();

            List<ActivityDetailPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getDetailPlanItemCode());
            for (int i = 0; i < monthBudgetEntities.size(); i++) {
                ActivityDetailPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                //可用金额
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getReturnAmount());
                BigDecimal thisOperationAmount = operationAmount;
                if (BigDecimal.ZERO.compareTo(operationAmount) >= 0) {
                    break;
                }
                //本次操作大于可用金额
                if (thisOperationAmount.compareTo(usableAmount) > 0) {
                    thisOperationAmount = usableAmount;
                }
                operationAmount = operationAmount.subtract(thisOperationAmount);
                monthBudgetEntity.setReturnAmount(monthBudgetEntity.getReturnAmount().subtract(thisOperationAmount));
            }
        }
        this.activityDetailPlanBudgetRepository.updateBatchById(activityPlanBudgets);
    }

    public List<ActivityDetailPlanBudget> validateOperateBudget(List<OperateActivityDetailPlanBudgetDto> operateList) {
        for (OperateActivityDetailPlanBudgetDto operateMonthBudgetDto : operateList) {
//            Validate.notEmpty(operateMonthBudgetDto.getMonthBudgetCode(), "操作预算时，预算编码不能为空！");
            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！细案编码：%s,细案明细编码：%s",
                    operateMonthBudgetDto.getDetailPlanCode(),operateMonthBudgetDto.getDetailPlanItemCode());
            Validate.notEmpty(operateMonthBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getDetailPlanItemCode(), "操作方案预算时，细案明细编码不能为空！");
        }
        List<String> operateCodeList = operateList.stream().map(OperateActivityDetailPlanBudgetDto::getDetailPlanItemCode).distinct().collect(Collectors.toList());
        LinkedList<ActivityDetailPlanBudget> budgetEntityList = activityDetailPlanBudgetRepository.listByOperateCodeListVertical(operateCodeList);
//        if (budgetEntityList.size() < operateCodeList.size()) {
//            List<String> existsCodes = budgetEntityList.stream().map(ActivityDetailPlanBudget::getDetailPlanItemCode).collect(Collectors.toList());
//            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
//            throw new RuntimeException("预算操作失败，活动明细[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
//        }
        for (ActivityDetailPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()) {
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getUsedAmount()) {
                activityPlanItem.setUsedAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getReturnAmount()) {
                activityPlanItem.setReturnAmount(BigDecimal.ZERO);
            }
        }
        return budgetEntityList;
    }
}
