package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;


import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanCloseMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanCloseMqTagEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 营销策略(ActivityDetail) 异步方法
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:11
 */
@Slf4j
@Service("activityDetailPlanItemAsyncService")
public class ActivityDetailPlanItemAsyncServiceImpl implements ActivityDetailPlanItemAsyncService {


    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 推个mq消息调SAP-SD接口来关闭
     *
     * @param itemCodeList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.2.25 14:30
     */
    public void closeSdActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        List<List<String>> entityGroupList = Lists.partition(itemCodeList, 400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString(list));
            mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.CLOSE_SAP_SD);
            rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                //单位：毫秒 防止MQ消息发送过于频繁
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("", e);
            }
        });
    }

    /**
     * 推个mq消息调牛人管家接口来关闭
     *
     * @param itemCodeList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.2.25 14:30
     */
    public void closeCowManagerActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        List<List<String>> entityGroupList = Lists.partition(itemCodeList, 400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString(list));
            mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.CLOSE_COW_MANAGER);
            rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                //单位：毫秒 防止MQ消息发送过于频繁
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("", e);
            }
        });
    }

    /**
     * 推送MQ消息
     *
     * @param itemCodeList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.2.25 14:30
     */
    @Async
    @Override
    public void closeActivityDetailPlanItemMqPush(String businessUnitCode,List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        //先处理下SD和牛人管家的
        //关闭活动细案之后要推送SAP-SD，异步推送
        this.closeSdActivityItem(itemCodeList, loginUserService.getAbstractLoginUser());
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            //关闭活动细案之后要推送牛人管家，异步推送
            this.closeCowManagerActivityItem(itemCodeList, loginUserService.getAbstractLoginUser());
        }

        List<List<String>> entityGroupList = Lists.partition(itemCodeList, 400);
        entityGroupList.forEach(list -> {
            for (ActivityDetailPlanCloseMqTagEnum mqTagEnum : ActivityDetailPlanCloseMqTagEnum.values()) {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSON.toJSONString(list));
                mqMessageVo.setTopic(ActivityDetailPlanCloseMqTagConstant.PROCESS_CLOSE_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(mqTagEnum.getCode());
                rocketMqProducer.sendMqMsg(mqMessageVo);
                try {
                    //单位：毫秒 防止MQ消息发送过于频繁
                    Thread.sleep(200);
                } catch (Exception e) {
                    log.error("", e);
                }
            }
        });


        //处理后续业务  更新方案预算跟踪表
        MqMessageVo closeRecordVo = new MqMessageVo();
        closeRecordVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        closeRecordVo.setTag(ActivityDetailPlanPassMqTagConstant.DETAIL_PLAN_ITEM_UPDATE_CLOSE_RECORD);
        closeRecordVo.setMsgBody(com.alibaba.fastjson.JSON.toJSONString(itemCodeList));
        rocketMqProducer.sendMqMsg(closeRecordVo,10);

    }

}

