package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.aliyun.tea.utils.Validate;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.constant.MnPageCacheConstant;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案明细分页缓存
 * @author wanghaojia
 * @date 2022/12/12 20:11
 */
@Slf4j
@Component
public class ActivityDetailPlanItemPageCacheHelper extends MnPageCacheHelper<ActivityDetailPlanItemVo, ActivityDetailPlanItemDto> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalRepository activityDetailPlanItemTerminalRepository;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Override
    public String getCacheKeyPrefix() {
        return ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_CACHE_NEW_KEY_PREFIX;
    }

    @Override
    public Class<ActivityDetailPlanItemDto> getDtoClass() {
        return ActivityDetailPlanItemDto.class;
    }

    @Override
    public Class<ActivityDetailPlanItemVo> getVoClass() {
        return ActivityDetailPlanItemVo.class;
    }

    @Override
    public List<ActivityDetailPlanItemDto> findDtoListFromRepository(ActivityDetailPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getDetailPlanCode())){
            return Lists.newArrayList();
        }
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        //有策略编码，从数据库里面查出来放到缓存里面
        List<ActivityDetailPlanItemDto> allDtoList = activityDetailPlanItemRepository.findDtoAndAttachListByDetailPlanCode(dto.getDetailPlanCode());
        //根据明细code组装终端信息
        List<ActivityDetailPlanItemTerminalDto> allTerminalDtoList = activityDetailPlanItemTerminalRepository.findTerminalDtoListByDetailItemCodeList(allDtoList.stream().map(ActivityDetailPlanItemDto::getDetailPlanItemCode).collect(Collectors.toList()));
        Map<String, List<ActivityDetailPlanItemTerminalDto>> itemCodeToTerminalDtoListMap = allTerminalDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemTerminalDto::getDetailPlanItemCode));
        allDtoList.forEach(item -> {
            if (itemCodeToTerminalDtoListMap.containsKey(item.getDetailPlanItemCode())) {
                List<ActivityDetailPlanItemTerminalDto> terminalDtoList = itemCodeToTerminalDtoListMap.get(item.getDetailPlanItemCode());
                List<ActivityDetailPlanItemTerminalDto> terminalList = Lists.newArrayList();

                terminalDtoList.forEach(terminalDto->{
                    ActivityDetailPlanItemTerminalDto temp = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItemTerminalDto.class, HashSet.class, ArrayList.class);
                    temp.setTerminalCode(terminalDto.getTerminalCode());
                    temp.setTerminalName(terminalDto.getTerminalName());
                    temp.setTerminalType(terminalDto.getTerminalType());
                    temp.setDisplayQuantityStr(terminalDto.getDisplayQuantityStr());
                    temp.setDisplayPriceStr(terminalDto.getDisplayPriceStr());
                    temp.setTerminalMonthSalesAmountStr(terminalDto.getTerminalMonthSalesAmountStr());
                    temp.setPersonIdCard(terminalDto.getPersonIdCard());
                    temp.setPersonType(terminalDto.getPersonType());
                    temp.setPersonName(terminalDto.getPersonName());
                    temp.setPersonCode(terminalDto.getPersonCode());
                    temp.setTotalFeeAmountStr(terminalDto.getTotalFeeAmountStr());
                    temp.setHeadFeeAmountStr(terminalDto.getHeadFeeAmountStr());
                    temp.setDepartmentFeeAmountStr(terminalDto.getDepartmentFeeAmountStr());
                    temp.setIntraCompanyAmountStr(terminalDto.getIntraCompanyAmountStr());
                    temp.setOffPointAmountStr(terminalDto.getOffPointAmountStr());
                    temp.setCustomerFeeAmountStr(terminalDto.getCustomerFeeAmountStr());
                    terminalList.add(temp);
                });
                item.setTerminalList(terminalList);
            }
        });

        allDtoList.sort(Comparator.comparing(ActivityDetailPlanItemDto::getDetailPlanItemCode));

        //更据明细编码查询
        if (StringUtils.isNotBlank(dto.getDetailPlanItemCode())) {
            allDtoList = allDtoList.stream().filter(a -> dto.getDetailPlanItemCode().equals(a.getDetailPlanItemCode())).collect(Collectors.toList());
        }

        Map<String, List<ActivityDetailPlanItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityDetailPlanItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, ActivityDetailPlanItemDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(), entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        List<ActivityDetailPlanItemDto> dtoList = allMap.get(templateCode);
        //更据明细编码查询
        if (StringUtils.isNotBlank(dto.getDetailPlanItemCode())) {
            List<String> detailPlanItemCodeList = Lists.newArrayList(dto.getDetailPlanItemCode().split("[, ，]"));
            dtoList = dtoList.stream().filter(item -> {
                return detailPlanItemCodeList.contains(item.getDetailPlanItemCode());
            }).collect(Collectors.toList());
        }

        return dtoList;
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public List<ActivityDetailPlanItemDto> newItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        ActivityDetailPlanItemDto newItem = new ActivityDetailPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList(newItem);
    }

    /**
     * 导入新增数据
     * @param cacheKey
     * @param itemList
     * @return
     */
    public void importNewItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);

        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        //导入新增数据
        for (ActivityDetailPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }

        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(),newIdArr );

        Map<Object, ActivityDetailPlanItemDto> updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        redisTemplate.opsForHash().putAll(redisCacheDataKey, updateMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    @Override
    public List<ActivityDetailPlanItemDto> copyItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        List<ActivityDetailPlanItemDto> newItemList = (List<ActivityDetailPlanItemDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItemDto.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);
        for (ActivityDetailPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setDetailPlanItemCode(null);
        }
        return newItemList;
    }

    @Override
    public void updateItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");
            String isTemporary = servletRequestAttributes.getRequest().getParameter("isTemporary");
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                for (ActivityDetailPlanItemDto itemDto : itemList) {
                    if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                        //垂直选择预算逻辑处理
                        BigDecimal headFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;

                        Set<String> headMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumMonthBudgetCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemNameSet = Sets.newHashSet();

                        for (ActivityDetailPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                            if(StringUtils.isEmpty(budgetDto.getFeeBelongCode())){
                                //没有费用归口不处理
                                continue;
                            }
                            if (StringUtils.isNotEmpty(budgetDto.getUseAmountStr())){
                                NumberStringDealUtil.validateNumberStrAndSet(budgetDto.getUseAmountStr(),"本次使用预算金额",false,budgetDto::setUseAmount,BigDecimal.class);

                                if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //总部预算
                                    headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区自投预算
                                    regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区公投预算
                                    regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                                }
                            }


                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                //总部预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区自投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区公投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }


                        }
                        itemDto.setHeadFeeAmount(headFeeAmount);
                        itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                        itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                        itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                        itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                        itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());

                        itemDto.setHeadMonthBudgetCode(String.join(",",headMonthBudgetCodeSet));
                        itemDto.setRegionAutomaticMonthBudgetCode(String.join(",",regionAutomaticMonthBudgetCodeSet));
                        itemDto.setRegionReferendumMonthBudgetCode(String.join(",",regionReferendumMonthBudgetCodeSet));
                        itemDto.setHeadBudgetItemCode(String.join(",",headBudgetItemCodeSet));
                        itemDto.setRegionAutomaticBudgetItemCode(String.join(",",regionAutomaticBudgetItemCodeSet));
                        itemDto.setRegionReferendumBudgetItemCode(String.join(",",regionReferendumBudgetItemCodeSet));
                        itemDto.setHeadBudgetItemName(String.join(",",headBudgetItemNameSet));
                        itemDto.setRegionAutomaticBudgetItemName(String.join(",",regionAutomaticBudgetItemNameSet));
                        itemDto.setRegionReferendumBudgetItemName(String.join(",",regionReferendumBudgetItemNameSet));
                    }
                }
            }

            if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(businessUnitCode)) {
                if (BooleanEnum.FALSE.getCapital().equals(isTemporary)) {
                    //关联的方案明细
                    List<String> relatePlanItemCodes = itemList.stream().map(ActivityDetailPlanItemDto::getRelatePlanItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List<ActivityPlanItemVo> activityPlanItemVoList = activityPlanItemSdkService.findRelatedPlanItemByCodes(relatePlanItemCodes);
                    Map<String, ActivityPlanItemVo> activityPlanMap = activityPlanItemVoList.stream().collect(Collectors.toMap(ActivityPlanItemVo::getPlanItemCode, Function.identity()));
                    //模板配置
                    List<String> templateCodes = itemList.stream().map(ActivityDetailPlanItemDto::getTemplateConfigCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(templateCodes);
                    Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));

                    for (ActivityDetailPlanItemDto item : itemList) {
                        if (StringUtils.isEmpty(item.getRelatePlanItemCode())) {
                            continue;
                        }
                        //关联的方案明细
                        ActivityPlanItemVo relatePlanItemVo = activityPlanMap.get(item.getRelatePlanItemCode());
                        if (null == relatePlanItemVo) {
                            throw new IllegalArgumentException("获取承接的方案数据时，未查询到关联的方案明细信息! 方案明细编码["+item.getRelatePlanItemCode()+"]");
                        }
                        //对应的模板配置
                        ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(item.getTemplateConfigCode());
                        if (null == templateConfigVo) {
                            throw new IllegalArgumentException("处理承接数据时，未查询到对应的活动模板配置信息! 模板编码["+item.getTemplateConfigCode()+"]");
                        }
                        ActivityDetailPlanItemDto correspondenceData = this.correspondence(relatePlanItemVo);
                        ObjectConvertStringUtil.fillObjectStrProperties(correspondenceData,ActivityDetailPlanItemDto.class);
                        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
                        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
                        //完全承接
                        if (BooleanEnum.TRUE.getNumStr().equals(relatePlanItemVo.getFullAccept())) {

                            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                                if (null != config.getEditableWhenUndertake() && !config.getEditableWhenUndertake()){
                                    if (!propertyMap.containsKey(config.getField())){
                                        throw new RuntimeException("模板["+templateConfigVo.getConfigCode()+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]的属性["+config.getField()+"]配置有误!");
                                    }
                                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                                    if (null != propertyDescriptor){
                                        try {
                                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(correspondenceData);
                                            if (null != itemInvoke) {
                                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                                            }

                                        } catch (IllegalAccessException | InvocationTargetException e) {
                                            throw new RuntimeException("["+config.getTitle()+"]读取失败！");
                                        }
                                    }else{
                                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                                    }
                                }
                            }

                        }else {
                            //部分承接
                            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                                if (null != config.getEditableWhenUndertakePart() && !config.getEditableWhenUndertakePart()){
                                    if (!propertyMap.containsKey(config.getField())){
                                        throw new RuntimeException("模板["+templateConfigVo.getConfigCode()+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]的属性["+config.getField()+"]配置有误!");
                                    }
                                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                                    if (null != propertyDescriptor){
                                        try {
                                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(correspondenceData);
                                            if (null != itemInvoke) {
                                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                                            }

                                        } catch (IllegalAccessException | InvocationTargetException e) {
                                            throw new RuntimeException("["+config.getTitle()+"]读取失败！");
                                        }
                                    }else{
                                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

    @Override
    public Object getDtoKey(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemDto.getId();
    }

    @Override
    public String getCheckedStatus(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemDto.getChecked();
    }

    /**
     * 方案明细字段 对应 细案明细字段
     *
     * @param relateVo
     * @return
     */
    private ActivityDetailPlanItemDto correspondence(ActivityPlanItemVo relateVo) {
        ActivityDetailPlanItemDto dto = nebulaToolkitService.copyObjectByWhiteList(relateVo,ActivityDetailPlanItemDto.class,HashSet.class,ArrayList.class,"activityNumber");

        return dto;
    }

}
