package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanProductRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemProductService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import liquibase.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 活动方案-关联策略服务
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityDetailPlanItemProductServiceImpl implements ActivityDetailPlanItemProductService {

    @Autowired(required = false)
    private ActivityDetailPlanProductRepository activityPlanItemProductRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     * @param itemDtoList  活动方案明细数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlanItemProductList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemDtoList) {
        if (CollectionUtils.isEmpty(itemDtoList)){
            return;
        }

        if (update){
            activityPlanItemProductRepository.deleteByDetailPlanCode(entity.getDetailPlanCode());
        }
        List<ActivityDetailPlanProduct> saveList = Lists.newArrayList();
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (StringUtil.isNotEmpty(itemDto.getProductCode()) && itemDto.getProductCode().contains(",")){
                //是多选的才保存
                String[] productCodeSplit = itemDto.getProductCode().split(",");
                if (StringUtil.isEmpty(itemDto.getProductName())){
                    throw new RuntimeException("产品名称有误！");
                }
                String[] productNameSplit = itemDto.getProductName().split(",");
                if (productNameSplit.length != productCodeSplit.length){
                    throw new RuntimeException("产品名称与编码数量不匹配！");
                }
                for (int i = 0; i < productCodeSplit.length; i++) {
                    ActivityDetailPlanProduct itemProduct = new ActivityDetailPlanProduct();
                    itemProduct.setDetailPlanCode(entity.getDetailPlanCode());
                    itemProduct.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    itemProduct.setProductCode(productCodeSplit[i]);
                    itemProduct.setProductName(productNameSplit[i]);
                    saveList.add(itemProduct);
                }
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanItemProductRepository.saveBatch(saveList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList) {
        if (CollectionUtils.isEmpty(itemDtoList)){
            return;
        }
        List<ActivityDetailPlanProduct> saveList = Lists.newArrayList();
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (StringUtil.isNotEmpty(itemDto.getProductCode()) && itemDto.getProductCode().contains(",")){
                //是多选的才保存
                String[] productCodeSplit = itemDto.getProductCode().split(",");
                if (StringUtil.isEmpty(itemDto.getProductName())){
                    throw new RuntimeException("产品名称有误！");
                }
                String[] productNameSplit = itemDto.getProductName().split(",");
                if (productNameSplit.length != productCodeSplit.length){
                    throw new RuntimeException("产品名称与编码数量不匹配！");
                }
                for (int i = 0; i < productCodeSplit.length; i++) {
                    ActivityDetailPlanProduct itemProduct = new ActivityDetailPlanProduct();
                    itemProduct.setDetailPlanCode(entity.getDetailPlanCode());
                    itemProduct.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    itemProduct.setProductCode(productCodeSplit[i]);
                    itemProduct.setProductName(productNameSplit[i]);
                    saveList.add(itemProduct);
                }
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanItemProductRepository.saveBatch(saveList);
        }
    }


}
