package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceStatisVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 营销策略(ActivityDetail)表服务实现类
 *
 * @author wanghaojia
 * @date 2022/11/22 16:29
 */
@Service
public class ActivityDetailPlanItemSdkServiceImpl implements ActivityDetailPlanItemSdkService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required = false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;

    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityDetailPlanProductRepository activityDetailPlanProductRepository;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private ProductBrandService productBrandService;

    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyService activityDetailPlanItemModifyService;

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 分页查询所有数据
     *
     * @param pageable                  分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = activityDetailPlanItemService.findByConditions(pageable, activityDetailPlanItemDto);
        convertDictValue(page.getRecords());
        return page;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        List<ActivityDetailPlanItemVo> list = activityDetailPlanItemService.findByConditionsList(activityDetailPlanItemDto);
        convertDictValue(list);
        return list;
    }
    
    private void convertDictValue(List<ActivityDetailPlanItemVo> list){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        List<String> dictCodeList = Lists.newArrayList("MDM_CUSTOMIZE_ORG");
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
        Map<String, Map<String, String>> dictMapMap = !org.springframework.util.CollectionUtils.isEmpty(dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n)) : new HashMap<>();
        Map<String, String> regionMap = dictMapMap.get("MDM_CUSTOMIZE_ORG");

        for (ActivityDetailPlanItemVo itemVo : list) {
            itemVo.setRegionName(regionMap.get(itemVo.getRegion()));
        }

    }

    @Override
    public Set<String> findCustomer(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (activityDetailPlanItemDto == null) {
            return Sets.newHashSet();
        }

        Validate.notNull(activityDetailPlanItemDto.getActivityBeginDate(), "活动开始时间不能为空");
        Validate.notNull(activityDetailPlanItemDto.getActivityEndDate(), "活动结束时间不能为空");
        Validate.notEmpty(activityDetailPlanItemDto.getBusinessUnitCode(), "业务单元编码不能为空");
        Validate.notEmpty(activityDetailPlanItemDto.getBusinessFormatCode(), "业态编码不能为空");


        List<ActivityDetailPlanItem> activityDetailPlanItems = this.activityDetailPlanItemRepository.lambdaQuery()
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getBusinessUnitCode, activityDetailPlanItemDto.getBusinessUnitCode())
                .eq(ActivityDetailPlanItem::getBusinessFormatCode, activityDetailPlanItemDto.getBusinessFormatCode())
                .eq(StringUtils.isNotBlank(activityDetailPlanItemDto.getCustomerCode()), ActivityDetailPlanItem::getCustomerCode, activityDetailPlanItemDto.getCustomerCode())
                .between(ActivityDetailPlanItem::getActivityBeginDate, activityDetailPlanItemDto.getActivityBeginDate(), activityDetailPlanItemDto.getActivityEndDate())
                .select(ActivityDetailPlanItem::getCustomerCode).list();
        if (CollectionUtils.isNotEmpty(activityDetailPlanItems)) {
            return activityDetailPlanItems.stream().filter(Objects::nonNull).map(ActivityDetailPlanItem::getCustomerCode).collect(Collectors.toSet());
        }
        return null;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByCustomerCode(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (activityDetailPlanItemDto == null) {
            return Lists.newArrayList();
        }

        Validate.notNull(activityDetailPlanItemDto.getActivityBeginDate(), "活动开始时间不能为空");
        Validate.notNull(activityDetailPlanItemDto.getActivityEndDate(), "活动结束时间不能为空");
        Validate.notEmpty(activityDetailPlanItemDto.getCustomerCode(), "客户编码不能为空");
        Validate.notEmpty(activityDetailPlanItemDto.getBusinessUnitCode(), "业务单元编码不能为空");
        Validate.notEmpty(activityDetailPlanItemDto.getBusinessFormatCode(), "业态编码不能为空");

        List<ActivityDetailPlanItem> activityDetailPlanItems = this.activityDetailPlanItemRepository.lambdaQuery()
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItem::getBusinessUnitCode, activityDetailPlanItemDto.getBusinessUnitCode())
                .eq(ActivityDetailPlanItem::getBusinessFormatCode, activityDetailPlanItemDto.getBusinessFormatCode())
                .eq(ActivityDetailPlanItem::getCustomerCode, activityDetailPlanItemDto.getCustomerCode())
                .between(ActivityDetailPlanItem::getActivityBeginDate, activityDetailPlanItemDto.getActivityBeginDate(), activityDetailPlanItemDto.getActivityEndDate())
                .list();

        if (CollectionUtils.isEmpty(activityDetailPlanItems)) {
            return Lists.newArrayList();
        }

        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class));
    }

    @Override
    public List<ActivityDetailPlanItemVo> listByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItemList = activityDetailPlanItemRepository.listByDetailCodeList(itemCodeList);
        if (CollectionUtils.isEmpty(activityDetailPlanItemList)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItemVo> activityDetailPlanItemVos = (List<ActivityDetailPlanItemVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                activityDetailPlanItemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class
        );
        List<ActivityDetailPlanBudget> budgetList = activityDetailPlanBudgetRepository.listByDetailCodeList(itemCodeList);
        // 预算
        if (!CollectionUtils.isEmpty(budgetList)) {
            List<ActivityDetailPlanBudgetVo> activityPlanBudgetVos = (List<ActivityDetailPlanBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                    budgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class
            );
            Map<String, List<ActivityDetailPlanBudgetVo>> budgetMap = activityPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getDetailPlanItemCode));
            activityDetailPlanItemVos.forEach(activityPlanItemVo -> {
                activityPlanItemVo.setBudgetShares(budgetMap.get(activityPlanItemVo.getDetailPlanItemCode()));
            });
        }
        return activityDetailPlanItemVos;
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemService.findForAudit(pageable, activityDetailPlanItemDto);
    }

    @Override
    public int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemService.findTotalForAudit(activityDetailPlanItemDto);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.activityDetailPlanItemRepository.findCanAutoAuditItemPage(page,autoAuditParams);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails) {
        return activityDetailPlanItemService.findForAuditByCodes(activityDetails);
    }

    @Override
    public void changeActivityDetailAuditInfo(List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos) {
        activityDetailPlanItemService.changeActivityDetailAuditInfo(activityDetailPlanItemDtos);
    }

    /**
     * 调整预算上向下规划金额、是否完全规划
     *
     * @param operationBudgetList
     * @author huojia
     * @date 2022/11/30 22:08
     **/
    @Override
    public void operationBudget(List<ActivityDetailPlanBudgetDto> operationBudgetList) {
        if (CollectionUtils.isEmpty(operationBudgetList)) {
            return;
        }
        // 查询活动细案预算
        Set<String> detailItemCodeSet = operationBudgetList.stream().map(ActivityDetailPlanBudgetDto::getDetailPlanItemCode).collect(Collectors.toSet());
        List<ActivityDetailPlanItem> activityPlanItems = activityDetailPlanItemRepository.listByDetailCodeList(new ArrayList<>(detailItemCodeSet));
        /*List<ActivityDetailPlanBudget> allBudgetList = activityDetailPlanBudgetRepository.listByDetailCodeList(new ArrayList<>(detailItemCodeSet));
        if (CollectionUtils.isEmpty(allBudgetList)) {
            throw new RuntimeException("活动方案预算查询失败！");
        }*/
        // 分组
        /*Map<String, List<ActivityDetailPlanBudget>> planBudgetMap = allBudgetList.stream()
                .collect(Collectors.groupingBy(ActivityDetailPlanBudget::getDetailPlanItemCode));*/
        Map<String, List<ActivityDetailPlanBudgetDto>> planBudgetDtoMap = operationBudgetList.stream()
                .collect(Collectors.groupingBy(ActivityDetailPlanBudgetDto::getDetailPlanItemCode));
        Map<String, ActivityDetailPlanItem> itemMap = activityPlanItems.stream()
                .collect(Collectors.toMap(ActivityDetailPlanItem::getDetailPlanItemCode, Function.identity()));
        // 按维度对应
        planBudgetDtoMap.forEach((detailItemCode, detailBudgetDtoList) -> {
            /*List<ActivityDetailPlanBudget> budgetList = planBudgetMap.get(detailItemCode);
            Map<String, ActivityDetailPlanBudgetDto> map = detailBudgetDtoList.stream()
                    .collect(Collectors.toMap(ActivityDetailPlanBudgetDto::getMonthBudgetCode, Function.identity()));
            budgetList.forEach(planBudget -> {
                if (!map.containsKey(planBudget.getMonthBudgetCode())) {
                    return;
                }
                ActivityDetailPlanBudgetDto activityPlanBudgetDto = map.get(planBudget.getMonthBudgetCode());
                planBudget.setDownAmount(Optional.ofNullable(planBudget.getDownAmount()).orElse(BigDecimal.ZERO).add(activityPlanBudgetDto.getThisDownAmount()));
                if (planBudget.getDownAmount().compareTo(planBudget.getUseAmount()) == 0) {
                    planBudget.setIsAllDown(BooleanEnum.TRUE.getCapital());
                }
            });*/
            ActivityDetailPlanItem activityPlanItem = itemMap.get(detailItemCode);
            BigDecimal downAmount = Optional.ofNullable(activityPlanItem.getDownAmount()).orElse(BigDecimal.ZERO);
            activityPlanItem.setDownAmount(
                    downAmount.add(detailBudgetDtoList.stream()
                            .map(ActivityDetailPlanBudgetDto::getThisDownAmount)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add)));
            // 完全向下规划：已向下规划金额 = 公司承担金额
            BigDecimal add = Optional.ofNullable(activityPlanItem.getHeadFeeAmount()).orElse(BigDecimal.ZERO)
                    .add(Optional.ofNullable(activityPlanItem.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO));
            if (activityPlanItem.getDownAmount().compareTo(add) >= 0) {
                activityPlanItem.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                activityPlanItem.setIsAllDown(BooleanEnum.FALSE.getCapital());
            }
            this.activityDetailPlanItemRepository.updateById(activityPlanItem);
            /*this.activityDetailPlanBudgetRepository.updateBatchById(budgetList);*/
        });
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes) {
        return findByActivityDetailItemCodes(itemCodes,null);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes, String businessUnitCode) {

        Validate.isTrue(CollectionUtils.isNotEmpty(itemCodes), "输入参数不能为空");

        String activityDetailPlanRollbackBudget = null;
        if(BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
            activityDetailPlanRollbackBudget = ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode();
        }
        List<ActivityDetailPlanItem> itemList = this.activityDetailPlanItemRepository.findByActivityDetailItemCodes(itemCodes,activityDetailPlanRollbackBudget);
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<>();
        }
        Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
    }

    /**
     * 根据客户与区域 统计费用合计
     *
     * @param dto 统计参数
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> statisticsFeeAmountByCusOrgCodes(ActivityDetailPlanItemStatisticsDto dto) {
        List<ActivityDetailPlanItemStatisticsVo> list = activityDetailPlanItemRepository.statisticsFeeAmountByCusOrgCodes(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(
                ActivityDetailPlanItemStatisticsVo::getCustomerCode, ActivityDetailPlanItemStatisticsVo::getTotalAmount));
        return map;
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findForWithholding(Pageable pageable, String operationType, ActivityDetailPlanItemDto dto) {
        return activityDetailPlanItemRepository.findByProcessStatusAndUpAccountStatus(pageable, dto, ProcessStatusEnum.PASS.getKey(), BooleanEnum.TRUE.getCapital());
    }

    @Override
    public List<ActivityDetailPlanProductVo> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet) {

        List<ActivityDetailPlanProduct> activityDetailPlanProductEntities = activityDetailPlanProductRepository.findApportionProductByActivityDetailCodes(activityDetailCodeSet);
        if (CollectionUtils.isNotEmpty(activityDetailPlanProductEntities)) {
            Collection<ActivityDetailPlanProductVo> activityDetailPlanProductVos = this.nebulaToolkitService.copyCollectionByBlankList(activityDetailPlanProductEntities, ActivityDetailPlanProduct.class, ActivityDetailPlanProductVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ActivityDetailPlanProductVo>) activityDetailPlanProductVos;
        }
        return new ArrayList<>();
    }

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Override
    public Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Pageable pageable, ActivityDetailPlanItemDto upwardDto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        String upAccountStatus = BooleanEnum.TRUE.getCapital();
        String processStatus = ProcessStatusEnum.PASS.getKey();
        List<SalesOrgSubComOrgVo> subComOrgVos;
        if (StringUtils.isNotEmpty(upwardDto.getSalesOrgCode())) {
            SalesOrgVo salesOrgVo = salesOrgVoService.findBySalesOrgCode(upwardDto.getSalesOrgCode());
            if (salesOrgVo != null) {
                subComOrgVos = salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgVo.getErpCode());
                upwardDto.setSalesOrgCode(null);
            } else {
                throw new UnsupportedOperationException("未查询到销售组织信息，请重新选择");
            }
        } else {
            subComOrgVos = salesOrgSubComOrgService.findAll();
        }
        List<String> customerErpCodeList = subComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());
        List<CustomerVo> customerVoList = customerVoService.findByErpCodeList(customerErpCodeList);
        List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        //拼接客户编码查询逻辑
        List<String> customerCodeInStrList = new ArrayList<>();
        int pageNum = 0;
        int pageSize = 500;
        for (; pageNum * pageSize < customerCodeList.size(); pageNum++) {
            if (pageNum * pageSize + pageSize > customerCodeList.size()) {
                customerCodeInStrList.add("('" + StringUtils.join(customerCodeList.subList(pageNum * pageSize, customerCodeList.size()), "','") + "')");
            } else {
                customerCodeInStrList.add("('" + StringUtils.join(customerCodeList.subList(pageNum * pageSize, pageNum * pageSize + pageSize), "','") + "')");
            }
        }
        //获取分子公司-向上不需要预提的活动类型列表
        String dictTypeCode = "tpm_withholding_detail_exclude_activity_type";
        Map<String, String> excludeActivityTypeMap =  dictToolkitService.findMapByDictTypeCode(dictTypeCode);
        if(!excludeActivityTypeMap.isEmpty()){
            Set<String> excludeActivityTypeCodeSet = excludeActivityTypeMap.keySet();
            return activityDetailPlanItemRepository.findUpwardDetailForWithholding(page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, excludeActivityTypeCodeSet);
        }
        return activityDetailPlanItemRepository.findUpwardDetailForWithholding(page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, null);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(String yearMonth, List<String> subComCustomerErpCodeList) {
        String mainCode = BusinessUnitEnum.HEADQUARTERS.getCode();
        String beginDate = yearMonth + "-01";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(beginDate, DateUtil.DEFAULT_YEAR_MONTH_DAY));
        calendar.add(Calendar.MONTH, 1);
        String endDate = DateUtil.formatDate(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);

        List<String> inConditionList = new ArrayList<>();
        int page = 0;
        int pageSize = 500;
        while (page * pageSize < subComCustomerErpCodeList.size()) {
            if (page * pageSize + pageSize > subComCustomerErpCodeList.size()) {
                List<String> subCondition = subComCustomerErpCodeList.subList(page * pageSize, subComCustomerErpCodeList.size());
                String inCondition = "('" + StringUtils.join(subCondition, "','") + "')";
                inConditionList.add(inCondition);
            } else {
                List<String> subCondition = subComCustomerErpCodeList.subList(page * pageSize, page * pageSize + pageSize);
                String inCondition = "('" + StringUtils.join(subCondition, "','") + "')";
                inConditionList.add(inCondition);
            }
            page++;
        }
        return activityDetailPlanItemRepository.findSubComActivityDetailByYearMonth(beginDate, endDate, mainCode, inConditionList);
    }

    /**
     * 根据品牌，零售商，区域统计细案明细的费用合计 key=零售商+品牌+区域，value=金额
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> statisticsDetailPlanItemTotalFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank(dto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(dto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<>();
        }
        List<ActivityDetailPlanItemStatisticsVo> list = activityDetailPlanItemRepository.statisticsDetailPlanItemTotalFee(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(
                ActivityDetailPlanItemStatisticsVo::getRetailerBrandRegionCode, ActivityDetailPlanItemStatisticsVo::getTotalAmount));
    }

    /**
     * 根据品牌，零售商，区域统计细案明细数据 key=零售商-区域-品牌，value=金额 （下月预计上账费用）
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> statisNextMonthPredictAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank(dto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(dto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(dto.getEndCaseForm())) {
            return new HashMap<>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<>();
        }
        Map<String, BigDecimal> map = new HashMap<>();
        List<NextMonthPredictAccountFeeVo> feeVos = activityDetailPlanItemRepository.statisNextMonthPredictAccountFee(dto);
        if(CollectionUtils.isEmpty(feeVos)){
            return map;
        }
        for (NextMonthPredictAccountFeeVo feeVo : feeVos) {
            String key = feeVo.getSystemCode()+"-"+feeVo.getRegion();
            if (map.containsKey(key)) {
                BigDecimal b = map.get(key).add(feeVo.getUnaccountedAmount());
                map.put(key, b);
            } else {
                map.put(key, feeVo.getUnaccountedAmount());
            }
        }
        return map;
//        //获取当前业态的品牌
//        ProductBrandFormatDto brandFormatDto = new ProductBrandFormatDto();
//        brandFormatDto.setBusinessFormatCode(dto.getBusinessFormatCode());
//        Map<String, String> brMap = this.productBrandService.findNameByCodesAndFormat(brandFormatDto);
//
//        //先分页获取活动明细数据，然后循环判断金额是否为0，有无品牌，无品牌判断有无产品，无产品则需要分摊金额到品牌上，分摊比例要通过零售商和区域，活动日期去统计垂直销售业绩里的数据
//        Page<NextMonthPredictAccountFeeVo> page = new Page<>(1, 1000);
//        while (true) {
//            Page<NextMonthPredictAccountFeeVo> pageResult = activityDetailPlanItemRepository.statisNextMonthPredictAccountFee(page, dto);
//            if (CollectionUtils.isEmpty(pageResult.getRecords())) {
//                break;
//            }
//            //循环每页数据
//            Set<String> proSet = new HashSet<>();
//            for (NextMonthPredictAccountFeeVo record : pageResult.getRecords()) {
//                //跳过未上账金额<=0的数据
//                if (BigDecimal.ZERO.compareTo(record.getUnaccountedAmount()) >= 0) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getSystemCode())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getRegion())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getProductBrandCode()) && StringUtils.isNotBlank(record.getProductCode())) {
//                    proSet.add(record.getProductCode());
//                }
//            }
//            //查询产品对应的品牌
//            List<ProductVo> proList = productVoService.findByCodes(new ArrayList<>(proSet));
//            Map<String, String> proMap = new HashMap<>();
//            if (!CollectionUtils.isEmpty(proList)) {
//                proMap = proList.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductBrandCode));
//            }
//            //再次循环
//            for (NextMonthPredictAccountFeeVo record : pageResult.getRecords()) {
//                //跳过未上账金额<=0的数据
//                if (BigDecimal.ZERO.compareTo(record.getUnaccountedAmount()) >= 0) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getSystemCode())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getRegion())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getProductBrandCode()) && StringUtils.isNotBlank(record.getProductCode())) {
//                    record.setProductBrandCode(proMap.getOrDefault(record.getProductCode(), null));
//                }
//                //开始计算未上账金额
//                //有品牌无需分摊
//                if (StringUtils.isNotBlank(record.getProductBrandCode())) {
//                    String key = record.getSystemCode() + "-" + record.getRegion() + "-" + record.getProductBrandCode();
//                    if (map.containsKey(key)) {
//                        BigDecimal b = map.get(key).add(record.getUnaccountedAmount());
//                        map.put(key, b);
//                    } else {
//                        map.put(key, record.getUnaccountedAmount());
//                    }
//                } else {
//                    //无品牌需要分摊
//                    SalesPerformanceStatisDto statisDto = new SalesPerformanceStatisDto();
//                    statisDto.setActivityBeginDate(record.getActivityBeginDate());
//                    statisDto.setActivityEndDate(record.getActivityEndDate());
//                    statisDto.setSystemCode(record.getSystemCode());
//                    statisDto.setRegion(record.getRegion());
//                    Map<String, BigDecimal> brandMap = this.salesPerformanceVoService.statisSalesAmountByBrand(statisDto);
//                    //若返回为空，以当前业态的全部品牌分摊
//                    if (!brandMap.isEmpty()) {
//                        this.apportionAmount(brandMap, map, record.getSystemCode(), record.getRegion(), record.getUnaccountedAmount());
//                    } else {
//                        this.shareEquallyAmount(brMap, map, record.getSystemCode(), record.getRegion(), record.getUnaccountedAmount());
//                    }
//                }
//            }
//            page.setCurrent(pageResult.getCurrent() + 1);
//        }
//        return map;
    }

    /**
     * 根据品牌，零售商，区域统计细案明细数据 key=零售商-区域-品牌，value=金额 （折扣上账金额）
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> statisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank(dto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(dto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(dto.getEndCaseForm())) {
            return new HashMap<>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<>();
        }
        Map<String, BigDecimal> map = new HashMap<>();
        List<DiscountAccountFeeVo> feeVos = activityDetailPlanItemRepository.statisDiscountAccountFee(dto);
        if(CollectionUtils.isEmpty(feeVos)){
            return map;
        }
        for (DiscountAccountFeeVo feeVo : feeVos) {
            String key = feeVo.getSystemCode()+"-"+feeVo.getRegion();
            if (map.containsKey(key)) {
                BigDecimal b = map.get(key).add(feeVo.getDiscountUpAccount());
                map.put(key, b);
            } else {
                map.put(key, feeVo.getDiscountUpAccount());
            }
        }
        return map;


        //获取当前业态的品牌
//        ProductBrandFormatDto brandFormatDto = new ProductBrandFormatDto();
//        brandFormatDto.setBusinessFormatCode(dto.getBusinessFormatCode());
//        Map<String, String> brMap = this.productBrandService.findNameByCodesAndFormat(brandFormatDto);
//
//        //先分页获取 通过活动细案明细->细案预测表->结案核销 已上账 折扣 折扣上账金额 ，然后循环判断金额是否为0，有无品牌，无品牌判断有无产品，无产品则需要分摊金额到品牌上，分摊比例要通过零售商和区域，活动日期去统计垂直销售业绩里的数据
//        Page<DiscountAccountFeeVo> page = new Page<>(1, 1000);
//        while (true) {
//            Page<DiscountAccountFeeVo> pageResult = activityDetailPlanItemRepository.statisDiscountAccountFee(page, dto);
//            if (CollectionUtils.isEmpty(pageResult.getRecords())) {
//                break;
//            }
//            //循环每页数据
//            Set<String> proSet = new HashSet<>();
//            for (DiscountAccountFeeVo record : pageResult.getRecords()) {
//                //跳过未上账金额<=0的数据
//                if (BigDecimal.ZERO.compareTo(record.getDiscountUpAccount()) >= 0) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getSystemCode())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getRegion())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getProductBrandCode()) && StringUtils.isNotBlank(record.getProductCode())) {
//                    proSet.add(record.getProductCode());
//                }
//            }
//            //查询产品对应的品牌
//            List<ProductVo> proList = productVoService.findByCodes(new ArrayList<>(proSet));
//            Map<String, String> proMap = new HashMap<>();
//            if (!CollectionUtils.isEmpty(proList)) {
//                proMap = proList.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductBrandCode));
//            }
//            //再次循环
//            for (DiscountAccountFeeVo record : pageResult.getRecords()) {
//                //跳过未上账金额<=0的数据
//                if (BigDecimal.ZERO.compareTo(record.getDiscountUpAccount()) >= 0) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getSystemCode())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getRegion())) {
//                    continue;
//                }
//                if (StringUtils.isBlank(record.getProductBrandCode()) && StringUtils.isNotBlank(record.getProductCode())) {
//                    record.setProductBrandCode(proMap.getOrDefault(record.getProductCode(), null));
//                }
//                //开始计算未上账金额
//                //有品牌无需分摊
//                if (StringUtils.isNotBlank(record.getProductBrandCode())) {
//                    String key = record.getSystemCode() + "-" + record.getRegion() + "-" + record.getProductBrandCode();
//                    if (map.containsKey(key)) {
//                        BigDecimal b = map.get(key).add(record.getDiscountUpAccount());
//                        map.put(key, b);
//                    } else {
//                        map.put(key, record.getDiscountUpAccount());
//                    }
//                } else {
//                    //无品牌需要分摊
//                    SalesPerformanceStatisDto statisDto = new SalesPerformanceStatisDto();
//                    statisDto.setActivityBeginDate(record.getActivityBeginDate());
//                    statisDto.setActivityEndDate(record.getActivityEndDate());
//                    statisDto.setSystemCode(record.getSystemCode());
//                    statisDto.setRegion(record.getRegion());
//                    Map<String, BigDecimal> brandMap = this.salesPerformanceVoService.statisSalesAmountByBrand(statisDto);
//                    //若返回为空，以当前业态的全部品牌分摊
//                    if (!brandMap.isEmpty()) {
//                        this.apportionAmount(brandMap, map, record.getSystemCode(), record.getRegion(), record.getDiscountUpAccount());
//                    } else {
//                        this.shareEquallyAmount(brMap, map, record.getSystemCode(), record.getRegion(), record.getDiscountUpAccount());
//                    }
//                }
//            }
//            page.setCurrent(pageResult.getCurrent() + 1);
//        }
//        return map;
    }

    /**
     * 分摊比例
     *
     * @param brandMap   品牌销量map
     * @param map        结果map
     * @param systemCode 零售商
     * @param region     区域
     * @param amount     未上账金额
     */
    public void apportionAmount(Map<String, BigDecimal> brandMap, Map<String, BigDecimal> map, String systemCode, String region, BigDecimal amount) {
        //先将brandMap转为List并排序，确保金额最大值在最后
        List<SalesPerformanceStatisVo> list = new ArrayList<>();
        for (String s : brandMap.keySet()) {
            SalesPerformanceStatisVo vo = new SalesPerformanceStatisVo();
            vo.setBrand(s);
            vo.setStatisValue(brandMap.get(s));
        }
        list.sort(Comparator.comparing(SalesPerformanceStatisVo::getStatisValue));


        //key前缀
        String key = systemCode + "-" + region + "-";
        //计算总销量
        BigDecimal total = list.stream().map(SalesPerformanceStatisVo::getStatisValue).reduce(BigDecimal.ZERO, BigDecimal::add);

        //总销量为0，均摊比例到每个品牌
        boolean boo = total.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal rate = BigDecimal.ZERO;
        if (boo) {
            rate = BigDecimal.ONE.divide(new BigDecimal(list.size()), 6, BigDecimal.ROUND_HALF_UP);
        }

        //已使用比例
        BigDecimal totalRate = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); i++) {
            BigDecimal r = BigDecimal.ZERO;
            //判断使用的比例
            if (boo) {
                //均摊
                if (i == list.size() - 1) {
                    //此处为最后一个，进行尾差处理
                    r = BigDecimal.ONE.subtract(totalRate);
                } else {
                    r = rate;
                }
            } else {
                //非均摊
                if (i == list.size() - 1) {
                    //此处为最后一个，进行尾差处理
                    r = BigDecimal.ONE.subtract(totalRate);
                } else {
                    r = list.get(i).getStatisValue().divide(total, 6, BigDecimal.ROUND_HALF_UP);
                }
            }
            totalRate = totalRate.add(r);
            //根据比例计算品牌对应的分摊金额
            String key2 = key + list.get(i).getBrand();
            if (map.containsKey(key2)) {
                BigDecimal b = map.get(key2).add(amount.multiply(r));
                map.put(key, b);
            } else {
                map.put(key, amount.multiply(r));
            }
        }


    }

    /**
     * 均摊比例
     *
     * @param brandMap   品牌map
     * @param map        结果map
     * @param systemCode 零售商
     * @param region     区域
     * @param amount     未上账金额
     */
    public void shareEquallyAmount(Map<String, String> brandMap, Map<String, BigDecimal> map, String systemCode, String region, BigDecimal amount) {
        //key前缀
        String key = systemCode + "-" + region + "-";
        BigDecimal rate = BigDecimal.ONE.divide(new BigDecimal(brandMap.size()), 6, BigDecimal.ROUND_HALF_UP);
        int i = 0;
        //已使用比例
        BigDecimal totalRate = BigDecimal.ZERO;
        for (String s : brandMap.keySet()) {
            i++;
            BigDecimal r = BigDecimal.ZERO;
            if (i == brandMap.size()) {
                //此处为最后一个，进行尾差处理
                r = BigDecimal.ONE.subtract(totalRate);
            } else {
                r = rate;
            }
            totalRate = totalRate.add(r);
            //根据比例计算品牌对应的分摊金额
            String key2 = key + s;
            if (map.containsKey(key2)) {
                BigDecimal b = map.get(key2).add(amount.multiply(r));
                map.put(key, b);
            } else {
                map.put(key, amount.multiply(r));
            }
        }
    }

    /**
     * 查询所有推送sap且在活动执行中的明细编码及其销售组织编码.
     * 参数'planCode'为空则查所有。
     *
     * @param planCode 细案编码
     * @return Map<String, String> key:明细编码，value：销售组织编码
     */
    @Override
    public Map<String, String> findItemCodesByDetailPlanCodes(String planCode) {
        return activityDetailPlanItemService.findItemCodesByDetailPlanCodes(planCode);
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findBudgetByCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return null;
        }
        List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = activityDetailPlanBudgetRepository.findBudgetByCodes(detailPlanItemCodes);
        if (CollectionUtils.isEmpty(activityDetailPlanBudgetList)) {
            return null;
        }
        Collection<ActivityDetailPlanBudgetVo> activityDetailPlanBudgetVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanBudgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanBudgetVo>) activityDetailPlanBudgetVos;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtil.isEmpty(itemCodes)) {
            return Collections.emptyList();
        }
        return activityDetailPlanItemService.findByItemCodes(itemCodes);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findDetailAndExtendByItemCodes(List<String> itemCodes) {
        return activityDetailPlanItemService.findDetailAndExtendByItemCodes(itemCodes);
    }

    @Override
    public Integer getSubRelatedItemTotal(ActivityDetailPlanItemDto planItemDto) {
        Validate.notNull(planItemDto,"条件参数不能为空");
        Validate.notNull(planItemDto.getFeeYearMonth(),"年月不能为空！");
        Validate.notBlank(planItemDto.getCustomerCode(),"客户编码不能为空！");
        return activityDetailPlanItemRepository.getSubRelatedItemTotal(planItemDto);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findSubRelatedCachePageList(Integer num,Integer pageSize, ActivityDetailPlanItemDto dto) {
        Validate.notNull(dto,"条件参数不能为空");
        Validate.notNull(dto.getFeeYearMonth(),"年月不能为空！");
        Validate.notBlank(dto.getCustomerCode(),"客户编码不能为空！");
        num = Optional.ofNullable(num).orElse(0);
        num = num * pageSize;
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemRepository.getDetailItemList(num,pageSize, dto);
        return itemVoList;
    }

    @Override
    public BigDecimal findByCode(String detailPlanItemCode) {

        return this.activityDetailPlanItemRepository.findByCode(detailPlanItemCode);

    }

    @Override
    public ActivityDetailPlanItemVo getActivityDetailPlanItemByCode(String itemCode) {

        return this.activityDetailPlanItemRepository.getDetailPlanItemByCode(itemCode);
    }

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细总条数
     *
     * @param selectDto
     * @return
     */
    @Override
    public Integer getExtractAuditDetailPlanCheckDataTotal(ActivityDetailPlanItemDto selectDto) {
        if (Objects.isNull(selectDto)) {
            return 0;
        }
        return this.activityDetailPlanItemRepository.getExtractAuditDetailPlanCheckDataTotal(selectDto);

    }

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细详情
     *
     * @param selectDto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(ActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize) {
        if (Objects.isNull(selectDto)) {
            return Lists.newArrayList();
        }
        pageNumber = pageNumber * pageSize;
        return this.activityDetailPlanItemRepository.extractAuditDetailPlanCheckData(selectDto,pageNumber,pageSize);

    }
    @Override
    public List<ActivityDetailPlanItemVo> findByPlanItemCode(String planItemCode) {
        if(StringUtils.isEmpty(planItemCode)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItemList = this.activityDetailPlanItemRepository.findListByRelatePlanItemCode(planItemCode);
        Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByRegionPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItems = activityDetailPlanItemRepository.findByRegionPlanItemCodes(planItemCodes);
        if(CollectionUtils.isNotEmpty(activityDetailPlanItems)){
            Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
        }
        return Lists.newArrayList();
    }

    /**
     * 根据方案明细编码或方案编码查关联细案明细数量
     *
     * @param detailPlanItemCodes
     * @param planCodes
     * @return
     */
    @Override
    public Integer findByItemCodesOrPlanCods(Set<String> detailPlanItemCodes, Set<String> planCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes) && CollectionUtils.isEmpty(planCodes)) {
            return null;
        }
        return activityDetailPlanItemRepository.findByItemCodesOrPlanCods(detailPlanItemCodes,planCodes);
    }

    /**
     * 根据总部方案编码查关联方案的细案明细
     *
     * @param cods
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemVo> findByPlanCodes(Set<String> cods) {
        if (CollectionUtils.isEmpty(cods)) {
            return null;
        }
        return activityDetailPlanItemRepository.findByPlanCodes(cods);
    }

    @Override
    public List<ActivityDetailPlanItemVo> listForVariable(ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemRepository.listForVariable(dto);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findListByPlanItemCode(String planItemCode) {
        if(StringUtils.isEmpty(planItemCode)){
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItems = activityDetailPlanItemRepository.findByPlanItemCode(planItemCode);
        if(CollectionUtils.isEmpty(activityDetailPlanItems)){
            return Lists.newArrayList();
        }
        Collection<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityDetailPlanItemVo>) activityDetailPlanItemVos;
    }

    /**
     * 根据活动方案编码查 细案明细
     *
     * @param set
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemVo> findByPlanItemCodes(Set<String> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        return activityDetailPlanItemRepository.findByPlanItemCodes(set);
    }

    @Override
    public List<String> findDetailItemCodesByPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isNotEmpty(planItemCodes)){
            return activityDetailPlanItemRepository.findDetailItemCodesByPlanItemCodes(planItemCodes);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SalesApprovalVo> findPsmList(SalesApprovalDto salesApprovalDto) {
        List<SalesApprovalVo> psmList = activityDetailPlanApprovalActivityInfoRepository.findPsmList(salesApprovalDto);
        return psmList;
    }

    /**
     * 根据上级方案明细编码查 细案明细
     *
     * @param set
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemVo> findByRelatePlanItemCodes(Set<String> set) {
        if(CollectionUtils.isNotEmpty(set)){
            return activityDetailPlanItemRepository.findByRelatePlanItemCodes(set);
        }
        return Lists.newArrayList();
    }

    @Override
    public void updateAuditStatusByActivityDetailCodes(List<String> newActivityDetailCodes, List<String> delActivityDetailCodes, ProcessStatusEnum processStatus) {
        if(CollectionUtils.isEmpty(newActivityDetailCodes)||CollectionUtils.isEmpty(delActivityDetailCodes)){
            return;
        }
        activityDetailPlanItemRepository.updateAuditStatusByActivityDetailCodes(newActivityDetailCodes,delActivityDetailCodes,processStatus);
    }

    @Override
    public List<ActivityDetailPlanItemDto> findListByDetailCodesForRedPayLedger(List<String> businessNoList) {
        if(CollectionUtils.isEmpty(businessNoList)){
            return Lists.newArrayList();
        }

        List<ActivityDetailPlanVo> activityDetailPlanVos = this.activityDetailPlanRepository.findByPlanCodes(new HashSet<>(businessNoList));

        Map<String, ActivityDetailPlanVo> activityDetailPlanVoMap = activityDetailPlanVos.stream().collect(Collectors.toMap(ActivityDetailPlanVo::getDetailPlanCode, Function.identity()));
        List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos = this.activityDetailPlanItemRepository.findListByDetailCodesForRedPayLedger(businessNoList);
        for (ActivityDetailPlanItemDto activityDetailPlanItemDto : activityDetailPlanItemDtos) {
            ActivityDetailPlanVo activityDetailPlanVo = activityDetailPlanVoMap.get(activityDetailPlanItemDto.getDetailPlanCode());
            activityDetailPlanItemDto.setDepartmentCode(activityDetailPlanVo.getDepartmentCode());
            activityDetailPlanItemDto.setDepartmentName(activityDetailPlanVo.getDepartmentName());
            activityDetailPlanItemDto.setDetailPlanName(activityDetailPlanVo.getDetailPlanName());

        }
        return activityDetailPlanItemDtos;
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> activityDetailCodes) {
        if(CollectionUtils.isEmpty(activityDetailCodes)){
            return Lists.newArrayList();
        }
        return this.activityDetailPlanBudgetRepository.findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes);
    }

    @Override
    public Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        return activityDetailPlanItemRepository.findPageStatisDiscountAccountFee(dto, pageable);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Pageable pageable, ActivityDetailPlanItemDto dto) {
        return activityDetailPlanItemService.findConditionByPlanCodes(pageable,dto);
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanBudgetVo> list = activityDetailPlanBudgetRepository.findRegionIsRelateHead(planCodes,TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    /**
     * 查询细案调整明细
     * @param modifyBusinessCodes
     * @return
     */
    @Override
    public List<ActivityDetailPlanItemModifyDto> findModifyItemByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if(CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return Lists.newArrayListWithCapacity(0);
        }
        return this.activityDetailPlanItemModifyService.findModifyItemByModifyBusinessCodes(modifyBusinessCodes);
    }

    @Override
    public List<ActivityDetailPlanItemVo> findListByDetailPlanCode(String detailPlanCode) {
        if(StringUtils.isEmpty(detailPlanCode)){
            return Lists.newArrayList();
        }
        return this.activityDetailPlanItemRepository.findListByDetailPlanCode(detailPlanCode);
    }

    @Override
    public List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyBusinessCode) {
        if(StringUtils.isEmpty(modifyBusinessCode)){
            return Lists.newArrayList();
        }
        return this.activityDetailPlanItemModifyRepository.findDtoListByModifyCode(modifyBusinessCode);
    }

    @Override
    public void useProductNumber(ActivityDetailPlanItemVo item) {
        if (Objects.isNull(item)
                || StringUtils.isEmpty(item.getDetailPlanItemCode())
                || Objects.isNull(item.getPeriodPromotionalNumberUse())) {
            return;
        }
        this.activityDetailPlanItemRepository.useProductNumber(item);

    }

    @Override
    public void updateActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes, List<String> thisDelActivityDetailCodes) {
        if(StringUtils.isEmpty(code)){
            return;
        }
        if(CollectionUtils.isEmpty(thisNewActivityDetailCodes)&&CollectionUtils.isEmpty(thisDelActivityDetailCodes)){
            return;
        }
        if(CollectionUtils.isNotEmpty(thisNewActivityDetailCodes)){
            initActivityDetailExtend(thisNewActivityDetailCodes);
        }
        this.activityDetailPlanItemRepository.updateActivityDetailPurchasingOrder(code,thisNewActivityDetailCodes,thisDelActivityDetailCodes);
    }

    private void initActivityDetailExtend(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return;
        }
        List<String> extendDetailPlanItemCodes = this.activityDetailPlanItemExtendRepository.findListByPlanItemCodes(detailPlanItemCodes);

        List<String> initDetailPlanCodes = new ArrayList<>();
        for (String detailPlanItemCode : detailPlanItemCodes) {
            if(!extendDetailPlanItemCodes.contains(detailPlanItemCode)){
                initDetailPlanCodes.add(detailPlanItemCode);
            }
        }
        if(CollectionUtils.isEmpty(initDetailPlanCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> detailPlanItemVoList = this.activityDetailPlanItemRepository.findByItemCodes(initDetailPlanCodes);
        for (ActivityDetailPlanItemVo itemVo : detailPlanItemVoList) {
            ActivityDetailPlanItemExtend activityDetailPlanItemExtend = new ActivityDetailPlanItemExtend();
            activityDetailPlanItemExtend.setId(itemVo.getId());
            activityDetailPlanItemExtend.setDetailPlanCode(itemVo.getDetailPlanCode());
            activityDetailPlanItemExtend.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
            activityDetailPlanItemExtend.setTenantCode(TenantUtils.getTenantCode());
            this.activityDetailPlanItemExtendRepository.save(activityDetailPlanItemExtend);
        }
    }

    @Override
    public void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus) {
        if(StringUtils.isEmpty(processStatus)){
            return;
        }
        if(CollectionUtils.isEmpty(activityDetailItemCodes)){
            return;
        }
        initActivityDetailExtend(activityDetailItemCodes);
        this.activityDetailPlanItemRepository.updateActivityDetailPurchasingOrderProcessStatus(activityDetailItemCodes,processStatus);
    }
}
