package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.mn.common.page.cache.constant.MnPageCacheConstant;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanDetailPlanAndBudgetEditDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanItemCloseLogDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanItemCloseLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanTemplateMapEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.GenerateRuleEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.log.ActivityDetailPlanLogEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemExtendFieldBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.CarGiftGroupEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemExtendFieldBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetVerticalService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.event.AuditDetailEventListener;
import com.biz.crm.tpm.business.audit.sdk.service.AuditSdkService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 营销策略(ActivityDetail)表服务实现类
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:11
 */
@Slf4j
@Service("activityDetailItemItemService")
public class ActivityDetailPlanItemServiceImpl extends MnPageCacheServiceImpl<ActivityDetailPlanItemVo, ActivityDetailPlanItemDto> implements ActivityDetailPlanItemService {

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private TerminalVoService terminalVoService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private List<AuditDetailEventListener> auditDetailEventListenerList;


    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 生成编码服务
     */
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 活动类型服务
     */
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    /**
     * 活动形式服务
     */
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    /**
     * 活动模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetService activityDetailPlanBudgetService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityDetailPlanItemAsyncService activityDetailPlanItemAsyncService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalRepository activityDetailPlanItemTerminalRepository;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetVerticalService activityDetailPlanBudgetVerticalService;

    @Autowired(required = false)
    private ActivityPlanBudgetVerticalService activityPlanBudgetVerticalService;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendFieldRepository activityDetailPlanItemExtendFieldRepository;

    @Autowired(required = false)
    private ExtendFieldService extendFieldService;

    @Autowired(required = false)
    private AuditSdkService auditSdkService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    /**
     * 分页查询所有数据
     *
     * @param pageable                  分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> result = activityDetailPlanItemRepository.findByConditions(pageable, activityDetailPlanItemDto);
        this.fillChangeStatus(result);
        return result;
    }

    private void fillChangeStatus(Page<ActivityDetailPlanItemVo> result) {
        if (CollectionUtils.isEmpty(result.getRecords())) {
            return;
        }
        //默认
        result.getRecords().forEach(e -> e.setActivityDetailChangeStatus("30"));
        //细案明细编码
        List<String> detailPlanItemCodes = result.getRecords().stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).distinct().collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> changeList = this.activityDetailPlanItemRepository.findChangeStatus(detailPlanItemCodes);
        if (CollectionUtils.isEmpty(changeList)) {
            return;
        }
        Map<String, List<ActivityDetailPlanItemVo>> toMap = changeList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemVo::getDetailPlanItemCode));
        result.getRecords().forEach(e -> {
            if (toMap.containsKey(e.getDetailPlanItemCode())) {
                String changeStatus = toMap.get(e.getDetailPlanItemCode()).stream().anyMatch(modify -> ProcessStatusEnum.COMMIT.getDictCode().equals(modify.getProcessStatus())) ? "10" : "20";
                e.setActivityDetailChangeStatus(changeStatus);
            }
        });
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findCachePageList(Pageable pageable, ActivityDetailPlanItemDto dto, String cacheKey) {
        String redisCacheIdKey = helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = helper.getRedisCacheInitKey(cacheKey);
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(Lists.newArrayList());

        a:
        if (redisService.hasKey(redisCacheIdKey)) {
            //redis里面有的话直接从redis里面取
            if (StringUtils.isEmpty(dto.getDetailPlanItemCode())) {
                Long total = redisService.lSize(redisCacheIdKey);
                page.setTotal(total);
                List<Object> idList = redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1);
                if (!CollectionUtils.isEmpty(idList)) {
                    List<Object> dataList = redisTemplate.opsForHash().multiGet(redisCacheDataKey, idList);
                    List<ActivityDetailPlanItemDto> dtoList = (List<ActivityDetailPlanItemDto>) (List) dataList;
                    List<ActivityDetailPlanItemVo> voList = helper.dtoListToVoList(dtoList);
                    page.setRecords(voList);
                }
            } else {
                List<ActivityDetailPlanItemDto> cacheList = findCacheList(cacheKey);
                if (!CollectionUtils.isEmpty(cacheList)) {
                    List<String> detailPlanItemCodeList = Lists.newArrayList(dto.getDetailPlanItemCode().split("[, ，]"));
                    cacheList = cacheList.stream().filter(item -> {
                        return detailPlanItemCodeList.contains(item.getDetailPlanItemCode());
                    }).collect(Collectors.toList());
                    page.setTotal(cacheList.size());
                    long start = page.offset();
                    if (page.getTotal() > start) {
                        long end = page.offset() + page.getSize();
                        if (page.getTotal() < end) {
                            end = page.getTotal();
                        }
                        List<ActivityDetailPlanItemDto> recordDtoList = cacheList.subList((int) page.offset(), (int) end);
                        List<ActivityDetailPlanItemVo> voList = helper.dtoListToVoList(recordDtoList);
                        page.setRecords(voList);
                    }
                }
            }
        } else if (!redisService.hasKey(redisCacheInitKey) && null != dto) {
            //标记为已初始化，不重复初始化
            redisService.set(redisCacheInitKey, BooleanEnum.TRUE, helper.getExpireTime());
            //redis里面没有
            List<ActivityDetailPlanItemDto> dtoList = helper.findDtoListFromRepository(dto, cacheKey);

            if (CollectionUtils.isEmpty(dtoList)) {
                break a;
            }

            if (helper.initToCacheFromRepository()) {
                helper.putCache(cacheKey, dtoList);
            }

            //放到缓存里面
            page.setTotal(dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List<ActivityDetailPlanItemDto> recordDtoList = dtoList.subList((int) page.offset(), (int) end);
                List<ActivityDetailPlanItemVo> voList = helper.dtoListToVoList(recordDtoList);
                page.setRecords(voList);
            }
        }
        //更新下VO里面的字段值
        helper.fillVoListProperties(page.getRecords());
        return page;
    }

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @Override
    public List<ActivityDetailPlanBudgetSumVo> findBudgetCacheSumList(String businessUnitCode, String cacheKey) {
        List<ActivityDetailPlanItemDto> itemList = this.findCacheList(cacheKey + ":");
        Map<String, ActivityDetailPlanBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto item : itemList) {
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && !CollectionUtils.isEmpty(item.getBudgetShares())) {
                List<ActivityDetailPlanBudgetDto> budgetShares = item.getBudgetShares();
                for (ActivityDetailPlanBudgetDto budgetShare : budgetShares) {
                    if (StringUtils.isBlank(budgetShare.getMonthBudgetCode())) {
                        continue;
                    }
                    //预算不为空才处理
                    ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(budgetShare.getMonthBudgetCode(), (key) -> new ActivityDetailPlanBudgetSumVo() {{
                        this.setUseAmount(BigDecimal.ZERO);
                        this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                    }});
                    budgetSumVo.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                    budgetSumVo.setBudgetItemCode(budgetShare.getBudgetItemCode());
                    budgetSumVo.setBudgetItemName(budgetShare.getBudgetItemName());
                    if (null != budgetShare.getUseAmountStr()) {
                        try {
                            budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(budgetShare.getUseAmountStr().trim())));
                        } catch (Exception ignore) {
                        }
                    }
                    feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
                }
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())) {
                //预算不为空才处理
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getHeadMonthBudgetCode(), (key) -> new ActivityDetailPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getHeadBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getHeadBudgetItemName());
                if (null != item.getHeadFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getHeadFeeAmountStr().trim())));
                    } catch (Exception e) {
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && StringUtils.isNotEmpty(item.getMonthBudgetCode())) {
                //预算不为空才处理
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new ActivityDetailPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getBudgetItemName());
                if (null != item.getDepartmentFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getDepartmentFeeAmountStr().trim())));
                    } catch (Exception e) {
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                ActivityDetailPlanBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                budgetSumVo.setOrgCode(budgetVo.getOrgCode());
                budgetSumVo.setOrgName(budgetVo.getOrgName());
                if (null != budgetVo.getAccumulatedAvailableBalance()) {
                    budgetSumVo.setAccumulatedAvailableBalance(budgetVo.getAccumulatedAvailableBalance());
                }
                if (null != budgetVo.getControlBalanceAmount()) {
                    budgetSumVo.setControlBalanceAmount(budgetVo.getControlBalanceAmount());
                }
            }
        }
        List<ActivityDetailPlanBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        return budgetSumList;
    }

    /**
     * 保存营销策略明细数据-默认走校验逻辑
     *
     * @param itemCacheList 营销策略明细数据
     */
    @Override
    public void saveActivityDetailPlanItemList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemCacheList) {
        saveActivityDetailPlanItemList(entity, update, itemCacheList, true, false);
    }

    /**
     * 保存营销策略明细数据
     *
     * @param itemList       营销策略明细数据
     * @param createValidate 是否走校验逻辑
     */
    @Override
    public void saveActivityDetailPlanItemList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemList, boolean createValidate, boolean tempSave) {
        if (createValidate && !tempSave) {
            createValidateList(new ActivityDetailPlanDto(), itemList);
        } else {
            tempSaveValidate(itemList);
        }
        String tenantCode = entity.getTenantCode();
        Map<String, ActivityDetailPlanItem> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityDetailPlanItem> oldList = activityDetailPlanItemRepository.findListByActivityDetailPlanCode(entity.getDetailPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityDetailPlanItem::getId, Function.identity()));
        }
        List<ActivityDetailPlanItem> saveList = Lists.newArrayList();
        List<ActivityDetailPlanItemExtendField> extendFieldSaveList = Lists.newArrayList();
        List<ActivityDetailPlanItem> updateList = Lists.newArrayList();
        List<ActivityDetailPlanItemTerminal> terminalList = Lists.newArrayList();
        Map<String, ActivityDetailPlanItem> finalOldMap = oldMap;
        Map<String, ActivityDetailPlanItemDto> dtoMap = Maps.newHashMap();
        int saveSize = (int) itemList.stream().filter(item -> !finalOldMap.containsKey(item.getId())).count();
        List<String> codeList = Lists.newArrayList();
        AtomicInteger index = new AtomicInteger(0);
        if (saveSize > 0) {
            // Z-+8位流水
            String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
            codeList = this.generateCodeService.generateCode(ruleCode, saveSize, 8, 0, TimeUnit.DAYS);
        }

        for (ActivityDetailPlanItemDto item : itemList) {
            dtoMap.put(item.getId(), item);
            item.setBusinessFormatCode(entity.getBusinessFormatCode());
            item.setBusinessUnitCode(entity.getBusinessUnitCode());

            ActivityDetailPlanItem itemEntity = null;
            if (oldMap.containsKey(item.getId())) {
                ActivityDetailPlanItem oldItemEntity = oldMap.get(item.getId());
                item.setDetailPlanItemCode(oldItemEntity.getDetailPlanItemCode());
                itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItem.class, HashSet.class, ArrayList.class);
                updateList.add(itemEntity);
                oldMap.remove(item.getId());


                List<ActivityDetailPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(item, ActivityDetailPlanItemExtendFieldBase.class, ActivityDetailPlanItemExtendField.class);
                if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                    for (ActivityDetailPlanItemExtendField extendField : activityPlanItemExtendFields) {
                        extendField.setDetailPlanCode(item.getDetailPlanCode());
                        extendField.setDetailPlanItemCode(item.getDetailPlanItemCode());
                        extendField.setTenantCode(itemEntity.getTenantCode());
                    }
                    extendFieldSaveList.addAll(activityPlanItemExtendFields);
                }

            } else {
                item.setDetailPlanItemCode(codeList.get(index.getAndIncrement()));
                itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItem.class, HashSet.class, ArrayList.class);
                itemEntity.setDetailPlanCode(entity.getDetailPlanCode());
                itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemEntity.setIsClose(BooleanEnum.FALSE.getCapital());
                itemEntity.setCowManagerState(InterfacePushStateEnum.NOT_PUSH.getCode());
                itemEntity.setSapInterfaceState(InterfacePushStateEnum.NOT_PUSH.getCode());
                itemEntity.setTenantCode(tenantCode);

                saveList.add(itemEntity);
                List<ActivityDetailPlanItemTerminalDto> terminalDtoList = item.getTerminalList();
                if (!CollectionUtils.isEmpty(terminalDtoList)) {
                    Collection<ActivityDetailPlanItemTerminal> terminalCollection = nebulaToolkitService.copyCollectionByWhiteList(terminalDtoList, ActivityDetailPlanItemTerminalDto.class, ActivityDetailPlanItemTerminal.class, HashSet.class, ArrayList.class);
                    String detailPlanItemCode = itemEntity.getDetailPlanItemCode();
                    String detailPlanCode = itemEntity.getDetailPlanCode();
                    terminalCollection.forEach(terminal -> {
                        terminal.setDetailPlanItemCode(detailPlanItemCode);
                        terminal.setDetailPlanCode(detailPlanCode);
                        terminal.setTenantCode(tenantCode);
                    });
                    terminalList.addAll(terminalCollection);
                }
            }
            if (StringUtils.isNotEmpty(item.getProductCode()) && item.getProductCode().contains(",")) {
                //如果是多选的话，设置成空的，单独存表
                itemEntity.setProductCode("");
                itemEntity.setProductName("");
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {

            for (ActivityDetailPlanItem activityPlanItem : saveList) {
                ActivityDetailPlanItemDto dto = dtoMap.get(activityPlanItem.getId());
                dto.setDetailPlanItemCode(activityPlanItem.getDetailPlanItemCode());
                activityPlanItem.setId(null);


                List<ActivityDetailPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(dto, ActivityDetailPlanItemExtendFieldBase.class, ActivityDetailPlanItemExtendField.class);
                if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                    activityPlanItemExtendFields.forEach(item -> {
                        item.setDetailPlanCode(activityPlanItem.getDetailPlanCode());
                        item.setDetailPlanItemCode(activityPlanItem.getDetailPlanItemCode());
                        item.setTenantCode(activityPlanItem.getTenantCode());
                    });
                    extendFieldSaveList.addAll(activityPlanItemExtendFields);
                }
            }
            //垂直。根据明细上门店编码查询售达方编码名称

            //垂直。根据明细上门店编码查询售达方编码名称
            List<String> terminalCodes = saveList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).map(ActivityDetailPlanItem::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toList());
            Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(terminalCodes)) {
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(terminalCodes);
                if (!CollectionUtils.isEmpty(terminalVos)) {
                    terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                }
            }
            for (ActivityDetailPlanItem item : saveList) {
                if (StringUtils.isNotBlank(item.getTerminalCode())) {
                    if (terminalVoMap.containsKey(item.getTerminalCode())) {
                        TerminalVo terminalVo = terminalVoMap.get(item.getTerminalCode());
                        //售达方编码（客户编码）
                        String sellerCode = terminalVo.getSellerCode();
                        //销售机构编码  销售机构编码拼接规则是：分销渠道+业态+销售机构编码
                        String instituCode = terminalVo.getSalesInstitutionCode();
                        // customerCode 编码规则 ： 售达方编码 + 销售机构编码 + 分销渠道 + 业态
                        if (StringUtils.isNotBlank(sellerCode) && StringUtils.isNotBlank(instituCode) && instituCode.length() >= 8) {
                            item.setCustomerCode(sellerCode + instituCode.substring(4) + instituCode.substring(0, 4));
                            item.setCustomerName(terminalVo.getSellerName());
                        }
                        item.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                        item.setActivityOrgName(terminalVo.getSalesInstitutionName());
                    }
                }
            }
            activityDetailPlanItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            //垂直。根据明细上门店编码查询售达方编码名称
            List<String> terminalCodes = updateList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).map(ActivityDetailPlanItem::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toList());
            Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(terminalCodes)) {
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(terminalCodes);
                if (!CollectionUtils.isEmpty(terminalVos)) {
                    terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                }
            }
            for (ActivityDetailPlanItem item : updateList) {
                if (StringUtils.isNotBlank(item.getTerminalCode())) {
                    if (terminalVoMap.containsKey(item.getTerminalCode())) {
                        TerminalVo terminalVo = terminalVoMap.get(item.getTerminalCode());
                        //售达方编码（客户编码）
                        String sellerCode = terminalVo.getSellerCode();
                        //销售机构编码  销售机构编码拼接规则是：分销渠道+业态+销售机构编码
                        String instituCode = terminalVo.getSalesInstitutionCode();
                        // customerCode 编码规则 ： 售达方编码 + 销售机构编码 + 分销渠道 + 业态
                        if (StringUtils.isNotBlank(sellerCode) && StringUtils.isNotBlank(instituCode) && instituCode.length() >= 8) {
                            item.setCustomerCode(sellerCode + instituCode.substring(4) + instituCode.substring(0, 4));
                            item.setCustomerName(terminalVo.getSellerName());
                        }
                        item.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                        item.setActivityOrgName(terminalVo.getSalesInstitutionName());
                    }
                }
            }
            activityDetailPlanItemRepository.updateBatchById(updateList);
        }
        if (!CollectionUtils.isEmpty(extendFieldSaveList)) {
            activityDetailPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
        }
        if (oldMap.size() > 0) {
            //待删除的数据
            activityDetailPlanItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
        //保存细案明细明细（主体的明细汇总不是手抖 明细的明细）
        if (!CollectionUtils.isEmpty(terminalList)) {
            activityDetailPlanItemTerminalRepository.saveOrUpdateBatch(terminalList);
        }
    }

    @Override
    public void tempSaveValidate(List<ActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(), "活动细案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("活动细案明细模板数据有误！");
        }
        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Pattern activityIntensityCompile = Pattern.compile(ActivityDetailPlanConstant.activityIntensityPattern);
        for (Map.Entry<String, List<ActivityDetailPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityDetailPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityDetailPlanItemDto dto : thisDtoList) {
                if (!StringUtils.isBlank(dto.getActivityBeginDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(), "活动开始时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityBeginDate);
                }
                if (!StringUtils.isBlank(dto.getActivityEndDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(), "活动结束时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityEndDate);
                }
                if (!StringUtils.isBlank(dto.getActivityBeginDateStr()) && !StringUtils.isBlank(dto.getActivityEndDateStr())) {
                    dto.setFeeYearMonth(new Date(dto.getActivityBeginDate().getYear(), dto.getActivityEndDate().getMonth(), 1));
                }

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())) {
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())) {
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())) {
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())) {
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, ActivityDetailPlanItemDto.class, true, templateDetailTitleMap);
        }
    }

    @Override
    public void createValidateListForOut(List<ActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(), "活动细案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("活动细案明细模板数据有误！");
        }
        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);

        Pattern activityIntensityCompile = Pattern.compile(ActivityDetailPlanConstant.activityIntensityPattern);
        for (Map.Entry<String, List<ActivityDetailPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityDetailPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityDetailPlanItemDto dto : thisDtoList) {
                //后端验证必填字段
//                Validate.notBlank(dto.getActivityTypeCode(),templateDetailTitleMap.getOrDefault("activityTypeCode","活动分类")+"不能为空！");
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(), "活动开始时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityBeginDate);
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(), "活动结束时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityEndDate);
                if (dto.getActivityBeginDate().getYear() != dto.getActivityEndDate().getYear() ||
                        dto.getActivityBeginDate().getMonth() != dto.getActivityEndDate().getMonth()) {
                    throw new RuntimeException("活动开始结束时间不能跨月!");
                }
                dto.setFeeYearMonth(new Date(dto.getActivityBeginDate().getYear(), dto.getActivityEndDate().getMonth(), 1));

//                Validate.notBlank(dto.getActivityOrgCode(),templateDetailTitleMap.getOrDefault("activityOrgCode","区域编码")+"不能为空！");
//                Validate.notBlank(dto.getProductBrandCode(),templateDetailTitleMap.getOrDefault("productBrandCodeStr","品牌编码")+"不能为空！");
                Validate.notNull(dto.getTotalFeeAmountStr(), templateDetailTitleMap.getOrDefault("totalFeeAmountStr", "费用合计") + "不能为空！");

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())) {
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())) {
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())) {
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())) {
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }

                if (StringUtils.isNotEmpty(dto.getActivityIntensity())) {
                    //活动力度校验
                    try {
                        new BigDecimal(dto.getActivityIntensity());
                    } catch (Exception e) {
                        Matcher activityIntensityMatcher = activityIntensityCompile.matcher(dto.getActivityIntensity());
                        if (!activityIntensityMatcher.matches()) {
                            throw new RuntimeException("活动力度[" + dto.getActivityIntensity() + "]格式有误");
                        }
                    }
                }


////                1022565 【正式环境】活动细案 随车搭赠模板数据缺失校验,销售机构/分销渠道/销售部门/客户组/物料
//                if (StringUtils.isNotEmpty(dto.getCarGiftGroup())){
//                    //有填随车搭赠组合，做校验
//                    if (StringUtils.isEmpty(dto.getSalesInstitutionCode())){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]销售机构不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getProductCode())){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]物料不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getSalesRegionCode()) &&
//                            (
//                                    CarGiftGroupEnum.GroupA.getCode().equals(dto.getCarGiftGroup()) ||
//                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup())
//                            )){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]销售部门不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getDistributionChannelCode()) &&
//                            (
//                                    CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup()) ||
//                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup())  ||
//                                            CarGiftGroupEnum.GroupF.getCode().equals(dto.getCarGiftGroup())  ||
//                                            CarGiftGroupEnum.GroupG.getCode().equals(dto.getCarGiftGroup())
//                            )){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]分销渠道不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getCustomerGroupCode()) &&
//                            (
//                                    CarGiftGroupEnum.GroupA.getCode().equals(dto.getCarGiftGroup()) ||
//                                            CarGiftGroupEnum.GroupC.getCode().equals(dto.getCarGiftGroup()) ||
//                                            CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup())  ||
//                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup())  ||
//                                            CarGiftGroupEnum.GroupG.getCode().equals(dto.getCarGiftGroup())  ||
//                                            CarGiftGroupEnum.GroupI.getCode().equals(dto.getCarGiftGroup())
//                            )){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]客户组不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getCustomerCode()) &&
//                            (
//                                    CarGiftGroupEnum.GroupB.getCode().equals(dto.getCarGiftGroup())
//                            )){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]客户不能为空!");
//                    }
//                    if (StringUtils.isEmpty(dto.getSalesOrgCode()) &&
//                            (
//                                    CarGiftGroupEnum.GroupC.getCode().equals(dto.getCarGiftGroup()) ||
//                                            CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup())
//                            )){
//                        throw new RuntimeException("随车搭赠组合["+dto.getCarGiftGroup()+"]销售组不能为空!");
//                    }
//                }


            }
            //模板验证必填字段
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null != configDetail.getRequired() && configDetail.getRequired()) {
                    if (!propertyMap.containsKey(configDetail.getField())) {
                        throw new RuntimeException("模板[" + templateConfigVo.getConfigName() + "]属性[" + configDetail.getTitle() + "]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(configDetail.getField());
                    if (null != propertyDescriptor) {
                        for (ActivityDetailPlanItemDto dto : thisDtoList) {
                            try {
                                Object invoke = propertyDescriptor.getReadMethod().invoke(dto);
                                if (null == invoke || StringUtils.isEmpty(invoke.toString())) {
                                    throw new RuntimeException("[" + configDetail.getTitle() + "]不能为空！");
                                }
                            } catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException("[" + configDetail.getTitle() + "]读取失败！");
                            }
                        }
                    } else {
                        throw new RuntimeException("[" + configDetail.getTitle() + "]配置有误，请检查！");
                    }
                }
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, ActivityDetailPlanItemDto.class, true, templateDetailTitleMap);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemList) {
        createValidateListForOut(itemList);
        String tenantCode = entity.getTenantCode();
        List<ActivityDetailPlanItem> saveList = Lists.newArrayList();
        List<ActivityDetailPlanItemExtendField> extendFieldSaveList = Lists.newArrayList();
        List<ActivityDetailPlanItem> updateList = Lists.newArrayList();
        List<ActivityDetailPlanItemTerminal> terminalList = Lists.newArrayList();
        Map<String, ActivityDetailPlanItemDto> dtoMap = Maps.newHashMap();
        int saveSize = itemList.size();
        List<String> codeList = Lists.newArrayList();
        AtomicInteger index = new AtomicInteger(0);
        if (saveSize > 0) {
            // Z-+8位流水
            String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
            codeList = this.generateCodeService.generateCode(ruleCode, saveSize, 8, 0, TimeUnit.DAYS);
        }

        for (ActivityDetailPlanItemDto item : itemList) {
            dtoMap.put(item.getId(), item);
            item.setBusinessFormatCode(entity.getBusinessFormatCode());
            item.setBusinessUnitCode(entity.getBusinessUnitCode());

            ActivityDetailPlanItem itemEntity = null;

            item.setDetailPlanItemCode(codeList.get(index.getAndIncrement()));
            itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItem.class, HashSet.class, ArrayList.class);
            itemEntity.setDetailPlanCode(entity.getDetailPlanCode());
            itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            itemEntity.setIsClose(BooleanEnum.FALSE.getCapital());
            itemEntity.setCowManagerState(InterfacePushStateEnum.NOT_PUSH.getCode());
            itemEntity.setSapInterfaceState(InterfacePushStateEnum.NOT_PUSH.getCode());
            itemEntity.setTenantCode(tenantCode);

            saveList.add(itemEntity);
            List<ActivityDetailPlanItemTerminalDto> terminalDtoList = item.getTerminalList();
            if (!CollectionUtils.isEmpty(terminalDtoList)) {
                Collection<ActivityDetailPlanItemTerminal> terminalCollection = nebulaToolkitService.copyCollectionByWhiteList(terminalDtoList, ActivityDetailPlanItemTerminalDto.class, ActivityDetailPlanItemTerminal.class, HashSet.class, ArrayList.class);
                String detailPlanItemCode = item.getDetailPlanItemCode();
                terminalCollection.forEach(terminal -> {
                    terminal.setDetailPlanItemCode(detailPlanItemCode);
                    terminal.setTenantCode(tenantCode);
                });
                terminalList.addAll(terminalCollection);
            }

            if (StringUtils.isNotEmpty(item.getProductCode()) && item.getProductCode().contains(",")) {
                //如果是多选的话，设置成空的，单独存表
                itemEntity.setProductCode("");
                itemEntity.setProductName("");
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {

            for (ActivityDetailPlanItem activityPlanItem : saveList) {
                ActivityDetailPlanItemDto dto = dtoMap.get(activityPlanItem.getId());
                dto.setDetailPlanItemCode(activityPlanItem.getDetailPlanItemCode());
                activityPlanItem.setId(null);

                List<ActivityDetailPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(dto, ActivityDetailPlanItemExtendFieldBase.class, ActivityDetailPlanItemExtendField.class);
                if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                    activityPlanItemExtendFields.forEach(extendField -> {
                        extendField.setDetailPlanCode(dto.getDetailPlanCode());
                        extendField.setDetailPlanItemCode(dto.getDetailPlanItemCode());
                        extendField.setTenantCode(dto.getTenantCode());
                    });
                    extendFieldSaveList.addAll(activityPlanItemExtendFields);
                }
            }
            //垂直。根据明细上门店编码查询售达方编码名称
            List<String> terminalCodes = saveList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).map(ActivityDetailPlanItem::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toList());
            Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(terminalCodes)) {
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(terminalCodes);
                if (!CollectionUtils.isEmpty(terminalVos)) {
                    terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                }
            }
            for (ActivityDetailPlanItem item : saveList) {
                if (StringUtils.isNotBlank(item.getTerminalCode())) {
                    if (terminalVoMap.containsKey(item.getTerminalCode())) {
                        TerminalVo terminalVo = terminalVoMap.get(item.getTerminalCode());
                        //售达方编码（客户编码）
                        String sellerCode = terminalVo.getSellerCode();
                        //销售机构编码  销售机构编码拼接规则是：分销渠道+业态+销售机构编码
                        String instituCode = terminalVo.getSalesInstitutionCode();
                        // customerCode 编码规则 ： 售达方编码 + 销售机构编码 + 分销渠道 + 业态
                        if (StringUtils.isNotBlank(sellerCode) && StringUtils.isNotBlank(instituCode) && instituCode.length() >= 8) {
                            item.setCustomerCode(sellerCode + instituCode.substring(4) + instituCode.substring(0, 4));
                            item.setCustomerName(terminalVo.getSellerName());
                        }
                        item.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                        item.setActivityOrgName(terminalVo.getSalesInstitutionName());
                    }
                }
            }
            activityDetailPlanItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(extendFieldSaveList)) {
            activityDetailPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
        }
        //保存细案明细明细（主体的明细汇总不是手抖 明细的明细）
        if (!CollectionUtils.isEmpty(terminalList)) {
            activityDetailPlanItemTerminalRepository.saveOrUpdateBatch(terminalList);
        }
    }

    @Override
    public List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemRepository.findByConditionsList(activityDetailPlanItemDto);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findItemForMaterialPurchasing(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemRepository.findItemForMaterialPurchasing(pageable, activityDetailPlanItemDto);
    }


    /**
     * 活动细案明细新增校验逻辑
     *
     * @param dtoList 活动细案明细数据
     */
    @Override
    public void createValidateList(ActivityDetailPlanDto planDto, List<ActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(), "活动细案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("活动细案明细模板数据有误！");
        }
        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Pattern activityIntensityCompile = Pattern.compile(ActivityDetailPlanConstant.activityIntensityPattern);
        for (Map.Entry<String, List<ActivityDetailPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityDetailPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityDetailPlanItemDto dto : thisDtoList) {
                //后端验证必填字段
//                Validate.notBlank(dto.getActivityTypeCode(),templateDetailTitleMap.getOrDefault("activityTypeCode","活动分类")+"不能为空！");
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(), "活动开始时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityBeginDate);
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(), "活动结束时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityEndDate);
                if (dto.getActivityBeginDate().getYear() != dto.getActivityEndDate().getYear() ||
                        dto.getActivityBeginDate().getMonth() != dto.getActivityEndDate().getMonth()) {
                    throw new RuntimeException("活动开始结束时间不能跨月!");
                }
                dto.setFeeYearMonth(new Date(dto.getActivityBeginDate().getYear(), dto.getActivityEndDate().getMonth(), 1));

//                Validate.notBlank(dto.getActivityOrgCode(),templateDetailTitleMap.getOrDefault("activityOrgCode","区域编码")+"不能为空！");
//                Validate.notBlank(dto.getProductBrandCode(),templateDetailTitleMap.getOrDefault("productBrandCodeStr","品牌编码")+"不能为空！");
                Validate.notNull(dto.getTotalFeeAmountStr(), templateDetailTitleMap.getOrDefault("totalFeeAmountStr", "费用合计") + "不能为空！");

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())) {
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())) {
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())) {
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())) {
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }

                if (StringUtils.isNotEmpty(dto.getActivityIntensity())) {
                    //活动力度校验
                    try {
                        new BigDecimal(dto.getActivityIntensity());
                    } catch (Exception e) {
                        Matcher activityIntensityMatcher = activityIntensityCompile.matcher(dto.getActivityIntensity());
                        if (!activityIntensityMatcher.matches()) {
                            throw new RuntimeException("活动力度[" + dto.getActivityIntensity() + "]格式有误");
                        }
                    }
                }


//                1022565 【正式环境】活动细案 随车搭赠模板数据缺失校验,销售机构/分销渠道/销售部门/客户组/物料
                if (StringUtils.isNotEmpty(dto.getCarGiftGroup())) {
                    //有填随车搭赠组合，做校验
                    if (StringUtils.isEmpty(dto.getSalesInstitutionCode())) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]销售机构不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getProductCode())) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]物料不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getSalesRegionCode()) &&
                            (
                                    CarGiftGroupEnum.GroupA.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup())
                            )) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]销售部门不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getDistributionChannelCode()) &&
                            (
                                    CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupF.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupG.getCode().equals(dto.getCarGiftGroup())
                            )) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]分销渠道不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getCustomerGroupCode()) &&
                            (
                                    CarGiftGroupEnum.GroupA.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupC.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupE.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupG.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupI.getCode().equals(dto.getCarGiftGroup())
                            )) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]客户组不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getCustomerCode()) &&
                            (
                                    CarGiftGroupEnum.GroupB.getCode().equals(dto.getCarGiftGroup())
                            )) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]客户不能为空!");
                    }
                    if (StringUtils.isEmpty(dto.getSalesOrgCode()) &&
                            (
                                    CarGiftGroupEnum.GroupC.getCode().equals(dto.getCarGiftGroup()) ||
                                            CarGiftGroupEnum.GroupD.getCode().equals(dto.getCarGiftGroup())
                            )) {
                        throw new RuntimeException("随车搭赠组合[" + dto.getCarGiftGroup() + "]销售组不能为空!");
                    }
                }


            }
            //模板验证必填字段
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null != configDetail.getRequired() && configDetail.getRequired()) {
                    if (!propertyMap.containsKey(configDetail.getField())) {
                        throw new RuntimeException("模板[" + templateConfigVo.getConfigName() + "]属性[" + configDetail.getTitle() + "]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(configDetail.getField());
                    if (null != propertyDescriptor) {
                        for (ActivityDetailPlanItemDto dto : thisDtoList) {
                            try {
                                Object invoke = propertyDescriptor.getReadMethod().invoke(dto);
                                if (null == invoke || StringUtils.isEmpty(invoke.toString())) {
                                    throw new RuntimeException("[" + configDetail.getTitle() + "]不能为空！");
                                }
                            } catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException("[" + configDetail.getTitle() + "]读取失败！");
                            }
                        }
                    } else {
                        throw new RuntimeException("[" + configDetail.getTitle() + "]配置有误，请检查！");
                    }
                }
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(thisDtoList, ActivityDetailPlanItemDto.class, true, templateDetailTitleMap);
            if (BusinessUnitEnum.isDefaultBusinessUnit(planDto.getBusinessUnitCode())) {
                //            2.是否汇总选是，导入表也导入了并且汇总了，在保存的时候，要校验，汇总里和明细里的，费用合计有没有等于总部承担+大区承担+客户承担。
                //            如果没有，需提示相应的汇总或明细里面的费用合计不等于总部承担+大区承担+客户承担
                //            3.是否汇总选是，导入表也导入了并且汇总了，在保存的时候，要校验该条汇总行的费用合计、总部承担、大区承担、客户承担金额是否等于对应的汇总明细数据的费用合计、总部承担、大区承担、客户承担的金额之和
                for (ActivityDetailPlanItemDto dto : thisDtoList) {
                    BigDecimal totalFeeAmount = Optional.ofNullable(dto.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal headFeeAmount = Optional.ofNullable(dto.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal departmentFeeAmount = Optional.ofNullable(dto.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal customerFeeAmount = Optional.ofNullable(dto.getCustomerFeeAmount()).orElse(BigDecimal.ZERO);
                    if (totalFeeAmount.compareTo(
                            headFeeAmount.add(departmentFeeAmount).add(customerFeeAmount)
                    ) != 0) {
                        throw new RuntimeException("第" + dto.getIndexNo() + "行费用合计不等于总部承担+大区承担+客户承担");
                    }
                    if (!CollectionUtils.isEmpty(dto.getTerminalList())) {
                        Validate.isTrue(BooleanEnum.TRUE.getCapital().equals(planDto.getIsGather()), "第" + dto.getIndexNo() + "行数据已汇总，请重新录入！");
                        BigDecimal totalFeeAmountSum = BigDecimal.ZERO;
                        BigDecimal headFeeAmountSum = BigDecimal.ZERO;
                        BigDecimal departmentFeeAmountSum = BigDecimal.ZERO;
                        BigDecimal customerFeeAmountSum = BigDecimal.ZERO;
                        for (ActivityDetailPlanItemTerminalDto itemTerminalDto : dto.getTerminalList()) {
                            BigDecimal totalFeeAmount1 = new BigDecimal(Optional.ofNullable(itemTerminalDto.getTotalFeeAmountStr()).orElse("0"));
                            BigDecimal headFeeAmount1 = new BigDecimal(Optional.ofNullable(itemTerminalDto.getHeadFeeAmountStr()).orElse("0"));
                            BigDecimal departmentFeeAmount1 = new BigDecimal(Optional.ofNullable(itemTerminalDto.getDepartmentFeeAmountStr()).orElse("0"));
                            BigDecimal customerFeeAmount1 = new BigDecimal(Optional.ofNullable(itemTerminalDto.getCustomerFeeAmountStr()).orElse("0"));
                            if (totalFeeAmount1.compareTo(
                                    headFeeAmount1.add(departmentFeeAmount1).add(customerFeeAmount1)
                            ) != 0) {
                                throw new RuntimeException("第" + dto.getIndexNo() + "行门店明细费用合计不等于总部承担+大区承担+客户承担");
                            }
                            totalFeeAmountSum = totalFeeAmountSum.add(totalFeeAmount1);
                            headFeeAmountSum = headFeeAmountSum.add(headFeeAmount1);
                            departmentFeeAmountSum = departmentFeeAmountSum.add(departmentFeeAmount1);
                            customerFeeAmountSum = customerFeeAmountSum.add(customerFeeAmount1);
                        }
                        Validate.isTrue(totalFeeAmountSum.compareTo(totalFeeAmount) == 0, "第" + dto.getIndexNo() + "行门店明细费用合计不等于汇总行费用合计");
                        Validate.isTrue(headFeeAmountSum.compareTo(headFeeAmount) == 0, "第" + dto.getIndexNo() + "行门店明细总部承担金额不等于汇总行总部承担金额");
                        Validate.isTrue(departmentFeeAmountSum.compareTo(departmentFeeAmount) == 0, "第" + dto.getIndexNo() + "行门店明细大区承担金额不等于汇总行大区承担金额");
                        Validate.isTrue(customerFeeAmountSum.compareTo(customerFeeAmount) == 0, "第" + dto.getIndexNo() + "行门店明细客户承担金额不等于汇总行客户承担金额");

                    }
                }
            }
        }
    }

    /**
     * 根据活动细案编码删除活动细案明细数据
     *
     * @param detailPlanCodes 细案编码集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByDetailPlanCodes(List<String> detailPlanCodes) {
        activityDetailPlanItemRepository.deleteByDetailPlanCodes(detailPlanCodes);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closeByPlanCodeItemList(List<String> businessNoList) {
        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findListByRelatePlanItemCodeList(businessNoList);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<String> ids = itemList.stream().map(ActivityDetailPlanItem::getId).collect(Collectors.toList());
        closeItem(ids, true);
    }

    /**
     * 关闭活动细案明细
     *
     * @param ids 活动细案明细id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closeItem(List<String> ids) {
        closeItem(ids, false);
    }

    @Transactional(rollbackFor = Exception.class)
    public void closeItem(List<String> ids, boolean autoClose) {
        Assert.notEmpty(ids, "请选择明细!");
        //验证细案明细
        List<ActivityDetailPlanItem> itemList = this.closeItemBaseVerifyItem(ids, autoClose);
        List<String> detailPlanCodeList = itemList.stream()
                .map(ActivityDetailPlanItem::getDetailPlanCode)
                .distinct().collect(Collectors.toList());
        List<String> detailPlanItemCodeList = itemList.stream()
                .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                .distinct().collect(Collectors.toList());
        Assert.notEmpty(detailPlanCodeList, "活动细案明细无细案编码!");
        Assert.notEmpty(detailPlanItemCodeList, "活动细案明细无细案明细编码!");

        //验证细案头部信息
        List<ActivityDetailPlan> detailPlanList = this.closeItemBaseVerifyHead(detailPlanCodeList);
        List<String> businessUnitCodeList = itemList.stream().map(ActivityDetailPlanItem::getBusinessUnitCode)
                .distinct().collect(Collectors.toList());

        Assert.notEmpty(businessUnitCodeList, "活动细案" + detailPlanCodeList + "业务单元不能为空!");
        Assert.isTrue(businessUnitCodeList.size() == 1, "活动细案" + detailPlanCodeList + "一次只能关闭同一个业务单元!");
        Assert.notEmpty(detailPlanList, "活动细案" + detailPlanCodeList + "未找到");
        String businessUnitCode = businessUnitCodeList.get(0);
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(businessUnitCode);
        Assert.notNull(businessUnitEnum, "业务单元不合法!");
        if (BusinessUnitEnum.VERTICAL.equals(businessUnitEnum)) {
            List<AuditCustomerDetailCollectionVo> resultList = activityDetailPlanItemRepository.findAuditDetailListByDetailPlanCodeList(detailPlanItemCodeList);
            if (CollectionUtil.isNotEmpty(resultList)) {
                resultList.forEach(item -> {
                    Assert.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus()),
                            "活动细案明细编码[" + item.getActivityDetailCode() + "]被核销明细[" + item.getAuditDetailCode() + "]关联未审批通过,不能够关闭活动!");
                    Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getWholeAudit()),
                            "活动细案明细编码[" + item.getActivityDetailCode() + "]被核销明细[" + item.getAuditDetailCode() + "]关联已完全结案,不能够关闭活动!");
                });
            }
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)
                && !autoClose) {
            //根据方案 自动生成细案,不允许关闭
            long planAutoCount = detailPlanList.stream().filter(k -> StringUtils.isNotBlank(k.getPlanCode())).count();
            Assert.isTrue(planAutoCount == 0, "选择的细案存在方案自动生成的细案,不允许关闭,如需关闭,请前往方案处关闭!");
        }
        this.closeItemByEntityList(itemList);

        List<ActivityDetailPlanItem> resultList = activityDetailPlanItemRepository.findListByDetailPlanCodeList(detailPlanCodeList);
        Assert.notEmpty(resultList, "活动细案" + detailPlanCodeList + "未找到");
        List<String> allCloseDetailPlanCodeList = new ArrayList<>();
        List<String> partialCloseDetailPlanCodeList = new ArrayList<>();

        Map<String, Map<String, String>> detailPlanItemMap = resultList.stream()
                .collect(Collectors.groupingBy(ActivityDetailPlanItem::getDetailPlanCode))
                .entrySet().stream()
                .filter(k -> CollectionUtil.isNotEmpty(k.getValue()))
                .collect(Collectors.toMap(Map.Entry::getKey,
                        item -> item.getValue().stream().collect(Collectors.toMap(ActivityDetailPlanItem::getId,
                                v -> StringUtils.isEmpty(v.getIsClose()) ? BooleanEnum.FALSE.getCapital() : v.getIsClose(),
                                (o, n) -> n)), (o, n) -> n));

        detailPlanItemMap.forEach((detailPlanCode, idMap) -> {
            ids.stream()
                    .filter(idMap::containsKey)
                    .forEach(id -> {
                        idMap.put(id, BooleanEnum.TRUE.getCapital());
                    });

        });
        log.info("活动细案活动状态明细[{}]", detailPlanItemMap);
        detailPlanItemMap.forEach((detailPlanCode, idMap) -> {
            Set<String> planStatusSet = new HashSet<>(idMap.values());
            if (CollectionUtil.isNotEmpty(planStatusSet)) {
                if (planStatusSet.size() == 1) {
                    allCloseDetailPlanCodeList.add(detailPlanCode);
                } else {
                    partialCloseDetailPlanCodeList.add(detailPlanCode);
                }
            }
        });
        log.info("活动细案全部关闭{}", allCloseDetailPlanCodeList);
        log.info("活动细案部分关闭{}", partialCloseDetailPlanCodeList);
        //完全关闭
        if (CollectionUtil.isNotEmpty(allCloseDetailPlanCodeList)) {
            activityDetailPlanService.updatePlanStatusByDetailPlanCodeList(allCloseDetailPlanCodeList, ActivityPlanStatusEnum.allClose);
        }
        //部分关闭
        if (CollectionUtil.isNotEmpty(partialCloseDetailPlanCodeList)) {
            activityDetailPlanService.updatePlanStatusByDetailPlanCodeList(partialCloseDetailPlanCodeList, ActivityPlanStatusEnum.partialClose);
        }
        //关闭业务日志，这里就只记录关闭状态吧
        Map<String, ActivityDetailPlan> planMap = detailPlanList.stream().collect(Collectors.toMap(ActivityDetailPlan::getDetailPlanCode, Function.identity()));
        SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanItemCloseLogEventDto> onClosed =
                ActivityDetailPlanLogEventListener::onItemClosed;
        for (ActivityDetailPlanItem activityPlanItem : itemList) {
            ActivityDetailPlan activityPlan = planMap.get(activityPlanItem.getDetailPlanCode());
            ActivityDetailPlanItemCloseLogEventDto logEventDto = new ActivityDetailPlanItemCloseLogEventDto();
            ActivityDetailPlanItemCloseLogDto oldDto = new ActivityDetailPlanItemCloseLogDto();
            oldDto.setId(activityPlan.getId());
//            oldDto.setDetailPlanCode(activityPlanItem.getDetailPlanCode());
//            oldDto.setDetailPlanItemCode(activityPlanItem.getDetailPlanItemCode());
            oldDto.setIsClose(BooleanEnum.FALSE.getSure());
            logEventDto.setOriginal(oldDto);
            ActivityDetailPlanItemCloseLogDto newDto = new ActivityDetailPlanItemCloseLogDto();
            newDto.setId(activityPlan.getId());
            oldDto.setDetailPlanCode(activityPlanItem.getDetailPlanCode());
            oldDto.setDetailPlanItemCode(activityPlanItem.getDetailPlanItemCode());
            newDto.setIsClose(BooleanEnum.TRUE.getSure());
            logEventDto.setNewest(newDto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onClosed);
        }

        List<String> itemCodeList = itemList.stream()
                .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                .distinct().collect(Collectors.toList());
        activityDetailPlanItemAsyncService.closeActivityDetailPlanItemMqPush(businessUnitCode, itemCodeList, loginUserService.getAbstractLoginUser());
    }

    /**
     * 关闭细案基础验证
     *
     * @param ids
     * @return
     */
    private List<ActivityDetailPlanItem> closeItemBaseVerifyItem(List<String> ids, boolean autoClose) {
        Assert.notEmpty(ids, "请选择数据!");
        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findByIdList(ids);
        Assert.notEmpty(ids, "选择的数据不存在,请刷新重试!");
        itemList.forEach(item -> {
            Assert.hasLength(item.getDetailPlanItemCode(), "活动细案明细编码为空!");
            Assert.hasLength(item.getBusinessUnitCode(),
                    "活动细案[" + item.getDetailPlanItemCode() + "]业务单元为空!");
            Assert.hasLength(item.getDetailPlanCode(),
                    "活动细案明细编码[" + item.getDetailPlanItemCode() + "]的活动细案编码为空!");
            Assert.notNull(BusinessUnitEnum.codeToEnum(item.getBusinessUnitCode()),
                    "活动细案[" + item.getDetailPlanItemCode() + "]业务单元不合法!");
            Assert.hasLength(item.getIsClose(),
                    "活动细案[" + item.getDetailPlanItemCode() + "]是否关闭标记为空!");
            Assert.notNull(item.getActivityBeginDate(),
                    "活动细案[" + item.getDetailPlanItemCode() + "]开始时间为空!");
            Assert.notNull(item.getActivityEndDate(),
                    "活动细案[" + item.getDetailPlanItemCode() + "]结束时间为空!");
        });
        Set<String> hasCloseItemCodeSet = itemList.stream()
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose()))
                .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                .collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(hasCloseItemCodeSet)) {
            throw new RuntimeException("活动细案明细" + hasCloseItemCodeSet.toString() + "已关闭！");
        }
        String businessUnitCode = itemList.get(0).getBusinessUnitCode();
        //垂直逻辑
        List<String> detailCodeList = itemList.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toList());
        AuditFindDetailDto dto = new AuditFindDetailDto();
        dto.setActivityDetailCodeList(detailCodeList);
        List<AuditCustomerDetailCollectionVo> auditVoList = new ArrayList<>();
        auditDetailEventListenerList.forEach(listener -> {
            List<AuditCustomerDetailCollectionVo> auditItemList = listener.findDetailByActivityDetailCodeList(dto);
            if (CollectionUtil.isNotEmpty(itemList)) {
                auditVoList.addAll(auditItemList);
            }
        });
        Map<String, List<AuditCustomerDetailCollectionVo>> auditVoMap = Optional.ofNullable(auditVoList)
                .orElse(Collections.emptyList()).stream()
                .collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getActivityDetailCode));
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            //业务单元等于垂直时：
            //（1）活动细案明细已生成结案核销单（高效配置生成、手动新增生成），
            // 且结案核销单为“待提交、追回、驳回、审批中”状态，都不允许关闭。
            // 对于生成的核销单是审批通过状态时，进一步判断活动的是否完全结案标识，
            // 如果活动上的是否完全结案=是，则不允许关闭活动细案。
            // 其他情况允许关闭（未关联核销单或者关联核销单但是是否完全结案=否时，是允许关闭的）
            //（2）不允许关闭的活动细案在关闭时需要做出提示【Z-xxxxxxxx已生成核销单或者活动已完全结案，请勿关闭】。
            // （提示到具体的活动细案明细编码）
            //将活动细案生成的核销单删除后（只有待提交、追回、驳回的核销单允许删除），才可关闭对应的活动细案明细。
            itemList.forEach(item -> {
                List<AuditCustomerDetailCollectionVo> detailCollectionVoList = auditVoMap.get(item.getDetailPlanItemCode());
                if (CollectionUtil.isNotEmpty(detailCollectionVoList)) {
                    detailCollectionVoList.forEach(vo -> {
                        if (ProcessStatusEnum.START.getKey().equals(vo.getProcessStatus())
                                || ProcessStatusEnum.PREPARE.getKey().equals(vo.getProcessStatus())
                                || ProcessStatusEnum.COMMIT.getKey().equals(vo.getProcessStatus())
                                || ProcessStatusEnum.REJECT.getKey().equals(vo.getProcessStatus())
                                || ProcessStatusEnum.RECOVER.getKey().equals(vo.getProcessStatus())
                                || ProcessStatusEnum.COLSE.getKey().equals(vo.getProcessStatus())) {
                            throw new IllegalArgumentException("【" + item.getDetailPlanItemCode()
                                    + "】已生成核销单或者活动已完全结案，请勿关闭");
                        } else if (ProcessStatusEnum.PASS.getKey().equals(vo.getProcessStatus())) {
                            Assert.isTrue(!BooleanEnum.TRUE.getCapital().equals(item.getWholeAudit()),
                                    "【" + item.getDetailPlanItemCode() + "】已生成核销单或者活动已完全结案，请勿关闭");
                        }
                    });
                }

            });
            //垂直逻辑，若是自动关闭，已关闭的细案直接跳过
            if (autoClose) {
                List<ActivityDetailPlanItem> itemList2 = new ArrayList<>();
                for (ActivityDetailPlanItem item : itemList) {
                    if (!BooleanEnum.TRUE.getCapital().equals(item.getIsClose())) {
                        itemList2.add(item);
                    }
                }
                return itemList2;
            } else {
                //已开始活动细案不允许关闭
                Date nowDate = new Date();
                Set<String> itemHasEndSet = itemList.stream()
                        .filter(k -> {
                            Date compareDate = k.getActivityEndDate();
                            if (null != k.getOrderEndDate() && k.getOrderEndDate().compareTo(compareDate) > 0) {
                                compareDate = k.getOrderEndDate();
                            }
                            return nowDate.compareTo(compareDate) > 0;
                        })
                        .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                        .collect(Collectors.toSet());
                if (CollectionUtil.isNotEmpty(itemHasEndSet)) {
                    throw new RuntimeException("活动细案明细" + itemHasEndSet.toString() + "已结束,不允许关闭！");
                }
            }
        } else {
            //业务单元不等于垂直时：
            //（1）活动细案明细已生成结案核销单（高效配置生成、手动新增生成），
            // 不管核销单什么状态，都不允许关闭（待提交、追回、驳回、审批中、审批通过）。未关联核销单的允许关闭。
            //（2）已生成结案核销单的活动细案在关闭时需要做出提示【Z-xxxxxxxx已生成核销单，请勿关闭】。（提示到具体的活动细案明细编码）
            //（3）将活动细案生成的核销单删除后（只有待提交、追回、驳回的核销单允许删除），才可关闭对应的活动细案明细。
            List<String> itemCodeList = itemList.stream()
                    .filter(k -> !BooleanEnum.TRUE.getCapital().equals(k.getIsClose()))
                    .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                    .distinct().collect(Collectors.toList());
            Assert.notEmpty(itemCodeList, "细案已关闭,请重新选择!");
            if (autoClose) {
                return itemList;
            }
            itemList.forEach(item -> {
                Assert.isTrue(!auditVoMap.containsKey(item.getDetailPlanItemCode()),
                        "【" + item.getDetailPlanItemCode() + "】已生成核销单，请勿关闭");
            });
        }
        return itemList;
    }

    /**
     * 关闭细案基础验证
     *
     * @param detailPlanCodeList
     * @return
     */
    private List<ActivityDetailPlan> closeItemBaseVerifyHead(List<String> detailPlanCodeList) {
        Assert.notEmpty(detailPlanCodeList, "细案明细编码不能为空!");
        detailPlanCodeList = detailPlanCodeList.stream().distinct().collect(Collectors.toList());
        List<ActivityDetailPlan> detailPlanList = activityDetailPlanRepository.findByDetailPlanCodeList(detailPlanCodeList);
        Assert.notEmpty(detailPlanList, "细案明细未找到细案头部信息,关闭失败!");
        Assert.isTrue(detailPlanList.size() == detailPlanCodeList.size(),
                "选择的细案明细存在无头部信息,关闭失败!");
        detailPlanList.forEach(item -> {
            Assert.hasLength(item.getDetailPlanCode(),
                    "活动细案编码为空!");
            Assert.hasLength(item.getIsTemporary(),
                    "活动细案[" + item.getDetailPlanCode() + "]是否临时方案为空!");
            Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getIsTemporary())
                            || BooleanEnum.TRUE.getCapital().equals(item.getIsTemporary()),
                    "活动细案[" + item.getDetailPlanCode() + "]是否临时方案标记不合法!");
            //if(BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())){
            Assert.isTrue(StringUtils.isNotBlank(item.getProcessStatus()) && ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus()),
                    "只有审批状态为审批通过的细案/方案可以关闭!");
            //}
        });
        return detailPlanList;
    }

    /**
     * 关闭活动细案明细  实体
     *
     * @param itemList
     */
    private void closeItemByEntityList(List<ActivityDetailPlanItem> itemList) {
        Assert.notEmpty(itemList, "关闭的细案明细信息不能为空,关闭失败!");
        /**
         * 主体需要释放预算,垂直不需要
         * 1临时方法释放月度预算
         * 2非临时方案释放活动方案预算
         */
        List<String> itemHeadCodeList = itemList.stream()
                .filter(k -> BusinessUnitEnum.isDefaultBusinessUnit(k.getBusinessUnitCode()))
                .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                .distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(itemHeadCodeList)) {
            activityDetailPlanBudgetService.returnMonthBudgetByDetailPlanCodeList(itemHeadCodeList);
        }

        List<String> itemCodeList = itemList.stream()
                .map(ActivityDetailPlanItem::getDetailPlanItemCode)
                .distinct().collect(Collectors.toList());

        String businessUnitCode = itemList.get(0).getBusinessUnitCode();
        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
            activityDetailPlanItemRepository.closeItem(itemCodeList);
        } else if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            activityDetailPlanItemRepository.closeItemVertical(itemCodeList);
        }
        activityDetailPlanItemRepository.updateHeadStatus(itemCodeList);
    }


    /**
     * 根据活动细案编码获取明细集合
     *
     * @param detailPlanCodes 细案编码集合
     * @return 明细集合
     */
    @Override
    public List<ActivityDetailPlanItemVo> findByDetailPlanCode(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return null;
        }
        List<ActivityDetailPlanItemVo> list = activityDetailPlanItemRepository.findItemsByActivityDetailItemCodes(detailPlanCodes);
        fillDetailPlanName(list);
        return list;
    }

    public void fillDetailPlanName(List<ActivityDetailPlanItemVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> detailPlanCodeList = list.stream().map(ActivityDetailPlanItemVo::getDetailPlanCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return;
        }
        List<ActivityDetailPlan> detailPlanList = activityDetailPlanRepository.list(Wrappers.lambdaQuery(ActivityDetailPlan.class)
                .in(ActivityDetailPlan::getDetailPlanCode, detailPlanCodeList)
        );
        Map<String, ActivityDetailPlan> detailPlanMap = detailPlanList.stream().collect(Collectors.toMap(ActivityDetailPlan::getDetailPlanCode, Function.identity()));
        for (ActivityDetailPlanItemVo activityDetailPlanItemVo : list) {
            ActivityDetailPlan activityDetailPlan = detailPlanMap.get(activityDetailPlanItemVo.getDetailPlanCode());
            activityDetailPlanItemVo.setDetailPlanName(activityDetailPlan.getDetailPlanName());
            activityDetailPlanItemVo.setBusinessUnitCode(activityDetailPlan.getBusinessUnitCode());
            activityDetailPlanItemVo.setBusinessFormatCode(activityDetailPlan.getBusinessFormatCode());
        }
    }

    /**
     * 根据活动细案明细编码获取可推送的明细集合
     *
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    @Override
    public List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItemVo> list = activityDetailPlanItemRepository.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        fillDetailPlanName(list);

        return list;
    }

    /**
     * 根据活动细案明细编码获取明细集合
     *
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    @Override
    public List<ActivityDetailPlanItemVo> findDetailAndExtendByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper<ActivityDetailPlanItem> wrapper = Wrappers.lambdaQuery(ActivityDetailPlanItem.class)
                .in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode());
        List<ActivityDetailPlanItem> list = activityDetailPlanItemRepository.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItemVo> voList = (List<ActivityDetailPlanItemVo>) nebulaToolkitService.copyCollectionByWhiteList(list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class);
        this.fillDetailPlanName(voList);

        return voList;
    }

    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
        return activityTypeService.findActivityTypeSelectList(dto);
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
        Validate.notBlank(dto.getActivityTypeCode(), "活动类型不能为空！");
        return activityFormService.findActivityFormSelectList(dto);
    }

    @Override
    public int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemRepository.findTotalForAudit(activityDetailPlanItemDto);
    }

//    @Override
//    public List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams) {
//        return this.activityDetailPlanItemRepository.findCanAutoAuditItem(autoAuditParams);
//    }

    @Override
    public Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Page<ActivityDetailPlanItemVo> forAudit = activityDetailPlanItemRepository.findForAudit(pageable, activityDetailPlanItemDto);
        stopWatch.stop();
        log.info("结案核销根据活动申请编码批量添加缓存findForAudit2消耗时间为:{}", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));

        List<ActivityDetailPlanItemVo> records = forAudit.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<ActivityDetailPlanItemVo> planItemVos = new ArrayList<>(records.size());
            Set<String> detailPlanItemCodes = records.stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).collect(Collectors.toSet());
            StopWatch stopWatch1 = new StopWatch();
            stopWatch1.start();
            List<ActivityDetailPlanItemVo> list = activityDetailPlanItemRepository.findByCodes(detailPlanItemCodes);
            stopWatch1.stop();
            log.info("结案核销根据活动申请编码批量添加缓存findByCodes消耗时间为:{}", DateUtil.millisecondToStr(stopWatch1.getLastTaskTimeMillis()));
            Map<String, BigDecimal> map = new HashMap<>();
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(a -> {
                    map.put(a.getDetailPlanItemCode(), a.getEstimatedWriteOffAmount());
                });
            }
            for (ActivityDetailPlanItemVo r : records) {
                // 预估核销金额
                String detailPlanItemCode = r.getDetailPlanItemCode();
                if (StringUtils.isEmpty(detailPlanItemCode)) {
                    planItemVos.add(r);
                    continue;
                }
                BigDecimal decimal = map.get(detailPlanItemCode);
                decimal = ObjectUtils.isEmpty(decimal) ? BigDecimal.ZERO : decimal;
                r.setEstimatedWriteOffAmount(decimal);
                // 已结案金额
                BigDecimal alreadyAuditAmount = r.getAlreadyAuditAmount();
                alreadyAuditAmount = ObjectUtils.isEmpty(alreadyAuditAmount) ? BigDecimal.ZERO : alreadyAuditAmount;
//                AuditEventDto auditEventDto = new AuditEventDto();
//                auditEventDto.setDetailPlanItemCode(detailPlanItemCode);
//                SerializableBiConsumer<AuditCodeListener, AuditEventDto> sf = AuditCodeListener::findByConditions;
//                AuditResponse customerVo = (AuditResponse) nebulaNetEventClient.directPublish(auditEventDto, AuditCodeListener.class, sf);
//                if (ObjectUtils.isEmpty(customerVo)) {
//                    planItemVos.add(r);
//                    continue;
//                }
//                BigDecimal byCode = customerVo.getAlreadyAuditAmount();
//                byCode = ObjectUtils.isEmpty(byCode) ? BigDecimal.ZERO : byCode;
//                BigDecimal alreadyAudit = alreadyAuditAmount.add(byCode).setScale(6, BigDecimal.ROUND_HALF_UP);
//                r.setAlreadyAuditAmount(alreadyAudit);
                // 已结案
//                BigDecimal amountBorneByHeadquarters = customerVo.getAmountBorneByHeadquarters();
//                amountBorneByHeadquarters = ObjectUtils.isEmpty(amountBorneByHeadquarters) ? BigDecimal.ZERO : amountBorneByHeadquarters;
//                BigDecimal amountOfTheClosedCompany = customerVo.getAmountOfTheClosedCompany();
//                amountOfTheClosedCompany = ObjectUtils.isEmpty(amountOfTheClosedCompany) ? BigDecimal.ZERO : amountOfTheClosedCompany;
//                BigDecimal amountOutsideThePointClosingParty = customerVo.getAmountOutsideThePointClosingParty();
//                amountOutsideThePointClosingParty = ObjectUtils.isEmpty(amountOutsideThePointClosingParty) ? BigDecimal.ZERO : amountOutsideThePointClosingParty;
//                BigDecimal amountToBeBorneByTheRegion = customerVo.getAmountToBeBorneByTheRegion();
//                amountToBeBorneByTheRegion = ObjectUtils.isEmpty(amountToBeBorneByTheRegion) ? BigDecimal.ZERO : amountToBeBorneByTheRegion;
//                r.setAmountOfTheClosedCompany(amountOfTheClosedCompany);
//                r.setAmountOutsideThePointClosingParty(amountOutsideThePointClosingParty);
//                r.setAmountToBeBorneByTheRegion(amountToBeBorneByTheRegion);
//                r.setAmountBorneByHeadquarters(amountBorneByHeadquarters);
                String auditForm = r.getAuditForm();
                if (StringUtils.isNotEmpty(auditForm) && ActivityDetailPlanConstant.CLOSING_FORM.equals(auditForm)) {
                    r.setIsPushSap(ActivityDetailPlanConstant.NO_N);
                } else {
                    r.setIsPushSap(ActivityDetailPlanConstant.YES_Y);
                }
                // 默认本次结案金额
                BigDecimal scale = decimal.subtract(alreadyAuditAmount).setScale(6, BigDecimal.ROUND_HALF_UP);
                r.setThisAuditAmount(scale);
                // 是否完全结案
                if (decimal.compareTo(scale.add(alreadyAuditAmount).setScale(6, BigDecimal.ROUND_HALF_UP)) != 1) {
                    r.setWholeAudit(ActivityDetailPlanConstant.YES_Y);
                }
                r.setEndCaseIntraCompanyAmount(r.getIntraCompanyAmount());
                BigDecimal headFeeAmount = r.getHeadFeeAmount();
                headFeeAmount = ObjectUtils.isEmpty(headFeeAmount) ? BigDecimal.ZERO : headFeeAmount;
                BigDecimal departmentFeeAmount = r.getDepartmentFeeAmount();
                departmentFeeAmount = ObjectUtils.isEmpty(departmentFeeAmount) ? BigDecimal.ZERO : departmentFeeAmount;
                // 结案总部承担金额 = 本次结案金额*【总部承担金额/（总部承担金额+大区承担金额）】
                BigDecimal sum = headFeeAmount.add(departmentFeeAmount).setScale(6, BigDecimal.ROUND_HALF_UP);
                if (sum.compareTo(BigDecimal.ZERO) != 0) {
                    r.setEndCaseHeadFeeAmount(scale.multiply(headFeeAmount.divide(sum, 6, BigDecimal.ROUND_HALF_UP)).setScale(6, BigDecimal.ROUND_HALF_UP));
                    // 结案大区承担金额 = 本次结案金额*【大区承担金额/（总部承担金额+大区承担金额）】
                    r.setEndCaseDepartmentFeeAmount(scale.multiply(departmentFeeAmount.divide(sum, 6, BigDecimal.ROUND_HALF_UP)).setScale(6, BigDecimal.ROUND_HALF_UP));
                }
                // 结案客户承担金额
                r.setEndCaseCustomerFeeAmount(r.getCustomerFeeAmount());
                // 结案分子公司点内金额
                r.setEndCaseIntraCompanyAmount(r.getThisAuditAmount());
                planItemVos.add(r);
            }
            return forAudit.setRecords(planItemVos);
        }
        return forAudit;
    }

    @Override
    public void changeActivityDetailAuditInfo(List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(activityDetailPlanItemDtos), "输入的数据不能为空");
        Set<String> codes = activityDetailPlanItemDtos.stream().map(ActivityDetailPlanItemDto::getDetailPlanItemCode).collect(Collectors.toSet());
        List<ActivityDetailPlanItem> list = this.activityDetailPlanItemRepository.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanItemCode, codes).eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        Validate.isTrue(!CollectionUtils.isEmpty(list), "未在找到细案明细找到数据");
        Map<String, ActivityDetailPlanItem> activityDetailPlanItemMap = list.stream().collect(Collectors.toMap(ActivityDetailPlanItem::getDetailPlanItemCode, Function.identity()));
        List<ActivityDetailPlanItem> activityDetailPlanItems = new ArrayList<>();
        activityDetailPlanItemDtos.forEach(item -> {
            ActivityDetailPlanItem activityDetailPlanItem = activityDetailPlanItemMap.get(item.getDetailPlanItemCode());
            Validate.notNull(activityDetailPlanItem, "未在细案明细中找到细案明细码【%s】的数据", item.getDetailPlanItemCode());
            ActivityDetailPlanItem activityDetailPlanItem1 = new ActivityDetailPlanItem();
            activityDetailPlanItem1.setId(activityDetailPlanItem.getId());
            activityDetailPlanItem1.setWholeAudit(item.getWholeAudit());
            if (YesOrNoEnum.YES.getCode().equals(item.getWholeAudit())) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                activityDetailPlanItem1.setWholeAuditDate(df.format(new Date()));
            }
            activityDetailPlanItem1.setAlreadyAuditAmount(Optional.ofNullable(activityDetailPlanItem.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)));
            activityDetailPlanItem1.setAlreadyEndCaseHeadFeeAmount(Optional.ofNullable(activityDetailPlanItem.getAlreadyEndCaseHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAlreadyEndCaseHeadFeeAmount()).orElse(BigDecimal.ZERO)));
            activityDetailPlanItem1.setAlreadyEndCaseDepartmentFeeAmount(Optional.ofNullable(activityDetailPlanItem.getAlreadyEndCaseDepartmentFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAlreadyEndCaseDepartmentFeeAmount()).orElse(BigDecimal.ZERO)));
            activityDetailPlanItem1.setAlreadyEndCaseIntraCompanyAmount(Optional.ofNullable(activityDetailPlanItem.getAlreadyEndCaseIntraCompanyAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAlreadyEndCaseIntraCompanyAmount()).orElse(BigDecimal.ZERO)));
            activityDetailPlanItem1.setAlreadyEndCaseOffPointAmount(Optional.ofNullable(activityDetailPlanItem.getAlreadyEndCaseOffPointAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getAlreadyEndCaseOffPointAmount()).orElse(BigDecimal.ZERO)));

            activityDetailPlanItems.add(activityDetailPlanItem1);
        });
        log.info("结案核销审批通过反写已结案金额：activityDetailPlanItems：{}", JsonUtils.obj2JsonString(activityDetailPlanItems));
        this.activityDetailPlanItemRepository.updateBatchById(activityDetailPlanItems);

        //更新活动方案结案金额
        //updatePlanAlreadyAmount(activityDetailPlanItemDtos);
    }

    private void updatePlanAlreadyAmount(List<ActivityDetailPlanItemDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }

        List<ActivityPlanItemDto> activityPlanItemDtoList = new ArrayList<>();
        Map<String, ActivityDetailPlanItemDto> detailItemMap = dtos.stream().collect(Collectors.toMap(ActivityDetailPlanItemDto::getDetailPlanItemCode, Function.identity()));
        List<String> detailPlanItemCodes = dtos.stream().map(ActivityDetailPlanItemDto::getDetailPlanItemCode).collect(Collectors.toList());
        List<ActivityDetailPlanBudgetVo> activityDetailPlanBudgetVos = activityDetailPlanBudgetService.findPlanItemCodeByActivityDetailItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(activityDetailPlanBudgetVos)) {
            Map<String, List<ActivityDetailPlanBudgetVo>> collect = activityDetailPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getRelatePlanItemCode));
            collect.forEach((key, value) -> {
                ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
                activityPlanItemDto.setPlanItemCode(key);
                for (ActivityDetailPlanBudgetVo activityDetailPlanBudgetVo : value) {
                    ActivityDetailPlanItemDto activityDetailPlanItemDto = detailItemMap.get(activityDetailPlanBudgetVo.getDetailPlanItemCode());
                    activityPlanItemDto.setAlreadyAuditAmount(
                            Optional.ofNullable(activityPlanItemDto.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)
                                    .add(Optional.ofNullable(activityDetailPlanItemDto.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)));
                }
                activityPlanItemDtoList.add(activityPlanItemDto);
            });
        }

        activityPlanItemSdkService.updateAlreadyAuditAmount(activityPlanItemDtoList);

    }

    @Override
    public List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails) {
        Validate.isTrue(!CollectionUtils.isEmpty(activityDetails), "输入参数不能为空");
        return activityDetailPlanItemRepository.findForAuditByCodes(activityDetails);
    }

    /**
     * 更新推送牛人管家成功的明细状态
     *
     * @param successCodes 明细编码集合
     */
    @Override
    public void updateDetailPlanCowManagerState(List<String> successCodes) {
        if (CollectionUtils.isEmpty(successCodes)) {
            return;
        }
        activityDetailPlanItemRepository.updateDetailPlanCowManagerState(successCodes);
    }

    /**
     * 更新推送Sap成功的明细状态
     *
     * @param code    明细编码集合
     * @param success 成功标记
     */
    @Override
    public void updateDetailPlanSapState(String code, boolean success) {
        if (StringUtils.isBlank(code)) {
            return;
        }
        activityDetailPlanItemRepository.updateDetailPlanSapState(code, success);
    }

    @Override
    public void createActivityDetailPlanItem(List<ActivityPlanItemDto> itemList, ActivityDetailPlan activityDetailPlan, String generateRule, String toDay, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {

        if (!CollectionUtils.isEmpty(itemList)) {

            //找出活动形式对应的细案模版
//            Set<String> activityFormCodeCodeSet = itemList.stream().map(ActivityPlanItemDto::getActivityFormCode).collect(Collectors.toSet());
//            Map<String, ActivityFormVo> activityFormVoMap = new HashMap<>();
//            if(!CollectionUtils.isEmpty(activityFormCodeCodeSet)) {
//                List<ActivityFormVo> activityFormByCode = activityFormService.findActivityFormByCode(activityFormCodeCodeSet);
//                activityFormVoMap = activityFormByCode.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
//            }

            Set<String> planTemplateConfigs = itemList.stream().map(ActivityPlanItemDto::getTemplateConfigCode).collect(Collectors.toSet());
            List<DictDataVo> planMapDetailList = dictDataVoService.findByDictTypeCode("plan_map_detail");
            Map<String, DictDataVo> planMapDetailMap = planMapDetailList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));

            List<ActivityDetailPlanItem> activityDetailPlanItems = new ArrayList<>();

            List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = new ArrayList<>();
            List<ActivityDetailPlanItemExtendField> extendFieldSaveList = new ArrayList<>();

            for (ActivityPlanItemDto item : itemList) {
                //1033120 【所有环境】垂直活动方案自动生成细案时，把费用金额是0的过滤掉，就不要生成细案了；门店分摊的时候分摊成0的也不要
                if (BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode())) {
                    if (null == item.getFeeAmount() || item.getFeeAmount().compareTo(BigDecimal.ZERO) == 0) {
                        continue;
                    }
                }

                // 活动便签号 “MN-yymmdd00000001-”+用户填写内容
//                String ruleCode2 = ActivityDetailPlanConstant.ACTIVITY_NUMBER+toDay;
//                List<String> codeList2 = this.generateCodeService.generateCode(ruleCode2, 1, 8, 0, TimeUnit.DAYS);
//                String  activityNumber = codeList2.get(0) + "-" + item.getActivityNumber();
                // 判断是否按照门店明细进行拆分
                boolean generatePlan = false;
                List<ActivityPlanBudgetDto> budgetList = item.getBudgetShares();
                if (GenerateRuleEnum.TERMINAL.getCode().equals(generateRule)) {
                    List<ActivityPlanItemTerminalDto> activityPlanItemTerminalList = item.getActivityPlanItemTerminalList();
                    if (!CollectionUtils.isEmpty(activityPlanItemTerminalList)) {
                        for (ActivityPlanItemTerminalDto activityPlanItemTerminalDto : activityPlanItemTerminalList) {
                            //1033120 【所有环境】垂直活动方案自动生成细案时，把费用金额是0的过滤掉，就不要生成细案了；门店分摊的时候分摊成0的也不要
                            if (BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode())) {
                                if (null == activityPlanItemTerminalDto.getAmount() || activityPlanItemTerminalDto.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                                    continue;
                                }
                            }
                            DictDataVo templateDict = planMapDetailMap.get(item.getTemplateConfigCode());
                            ActivityDetailPlanItem activityDetailPlanItem = buildByActivityItemTerminal(activityDetailPlan, item, activityPlanItemTerminalDto,
                                    templateDict.getDictValue(), toDay, extendFieldSaveList);
                            activityDetailPlanItems.add(activityDetailPlanItem);
                        }
                        if (!CollectionUtils.isEmpty(budgetList)) {
                            //预算根据门店明细拆分
                            activityDetailPlanBudgetList.addAll(splitBudgetByTerminal(budgetList, activityPlanItemTerminalList, item));
                        }
                    } else if (StringUtils.isNotEmpty(item.getTerminalCode())) {
                        //如果有门店编码，就不进行拆分
                        ActivityDetailPlanItem activityDetailPlanItem = buildDetailItem(item, toDay);
//                        if (!BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode())){
                        DictDataVo templateDict = planMapDetailMap.get(item.getTemplateConfigCode());
                        activityDetailPlanItem.setTemplateConfigCode(templateDict.getDictValue());
//                        }
                        activityDetailPlanItems.add(activityDetailPlanItem);

                        if (!CollectionUtils.isEmpty(budgetList)) {
                            Collection<ActivityDetailPlanBudget> activityDetailPlanBudgets = buildDetailBudget(budgetList, item, activityDetailPlanItem);
                            activityDetailPlanBudgetList.addAll(activityDetailPlanBudgets);
                        }
                    } else {
                        //没有门店编码也没有门店明细，就按方案生成的逻辑来处理
                        generatePlan = true;
                    }
                } else if (GenerateRuleEnum.CUSTOMER.getCode().equals(generateRule)) {
                    //todo

                    //随车搭赠模板为904的时候走方案生成的逻辑
                }else if(GenerateRuleEnum.PLAN.getCode().equals(generateRule)||(GenerateRuleEnum.RELATE_DETAIL_PLAN.getCode()
                        .equals(generateRule)&&CarGiftGroupEnum.GroupB.getCode().equals(item.getCarGiftGroup()))) {
                    generatePlan = true;
                }else if(GenerateRuleEnum.RELATE_DETAIL_PLAN.getCode().equals(generateRule)&&!CarGiftGroupEnum.GroupB.getCode().equals(item.getCarGiftGroup())){
                    Map<String, List<ActivityPlanItemRelateDetailItemDto>> relateDetailItemMap = relateDetailItemDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemRelateDetailItemDto::getPlanItemCode));
                    List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList1 = relateDetailItemMap.get(item.getPlanItemCode());
                    relateDetailItemDtoList1.forEach(o->{
                        o.setRelatePlanCode(o.getPlanCode());
                        o.setRelatePlanItemCode(o.getPlanItemCode());
                    });
                    List<ActivityDetailPlanItem> detailPlanItemList = (List<ActivityDetailPlanItem>)this.nebulaToolkitService.copyCollectionByWhiteList(relateDetailItemDtoList1, ActivityPlanItemRelateDetailItemDto.class, ActivityDetailPlanItem.class, LinkedHashSet.class, ArrayList.class);
                    for (ActivityDetailPlanItem activityDetailPlanItem : detailPlanItemList) {
                        DictDataVo templateDict = planMapDetailMap.get(item.getTemplateConfigCode());
                        activityDetailPlanItem.setTemplateConfigCode(templateDict.getDictValue());
                        // Z-+8位流水
                        String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
                        List<String> codeList = this.generateCodeService.generateCode(ruleCode, 1, 8, 0, TimeUnit.DAYS);
                        activityDetailPlanItem.setDetailPlanItemCode(codeList.get(0));
                        activityDetailPlanItem.setIsClose(YesOrNoEnum.NO.getCode());
                    }
                    activityDetailPlanItems.addAll(detailPlanItemList);
                    activityDetailPlanBudgetList.addAll(matchActivityPlanBudgetRelate(item,detailPlanItemList));

                }
                if (generatePlan) {
                    ActivityDetailPlanItem activityDetailPlanItem = buildDetailItem(item, toDay);
                    //不是垂直从数据字典转换
                    DictDataVo templateDict = planMapDetailMap.get(item.getTemplateConfigCode());
                    activityDetailPlanItem.setTemplateConfigCode(templateDict.getDictValue());

                    List<ActivityDetailPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(item, ActivityPlanItemExtendFieldBase.class, ActivityDetailPlanItemExtendField.class);
                    if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                        activityPlanItemExtendFields.forEach(extendField -> {
                            extendField.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
                            extendField.setDetailPlanItemCode(activityDetailPlanItem.getDetailPlanItemCode());
                            extendField.setTenantCode(activityDetailPlanItem.getTenantCode());
                        });
                        extendFieldSaveList.addAll(activityPlanItemExtendFields);
                    }

                    activityDetailPlanItems.add(activityDetailPlanItem);
                    if (!CollectionUtils.isEmpty(budgetList)) {
                        Collection<ActivityDetailPlanBudget> activityDetailPlanBudgets = buildDetailBudget(budgetList, item, activityDetailPlanItem);
                        activityDetailPlanBudgetList.addAll(activityDetailPlanBudgets);
                    }
                }
            }

            Map<String, List<ActivityDetailPlanBudget>> activityDetailPlanBudgetMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(activityDetailPlanBudgetList)) {
                activityDetailPlanBudgetList.forEach(item -> {
                    item.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
                });
                activityDetailPlanBudgetService.saveActivityDetailPlanBudgetList(activityDetailPlanBudgetList);

                activityDetailPlanBudgetMap = activityDetailPlanBudgetList.stream().collect(Collectors.groupingBy(o -> o.getDetailPlanCode() + o.getDetailPlanItemCode()));
            }

            for (int i = 0; i < activityDetailPlanItems.size(); i++) {
                ActivityDetailPlanItem item = activityDetailPlanItems.get(i);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setBusinessFormatCode(activityDetailPlan.getBusinessFormatCode());
                item.setBusinessUnitCode(activityDetailPlan.getBusinessUnitCode());
                //垂直重新算下总部、大区、承担金额
                if (BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode())) {
                    List<ActivityDetailPlanBudget> activityDetailPlanBudgets = activityDetailPlanBudgetMap.get(item.getDetailPlanCode() + item.getDetailPlanItemCode());
                    if (!CollectionUtils.isEmpty(activityDetailPlanBudgets)) {
                        List<ActivityDetailPlanBudget> headBudget = activityDetailPlanBudgets.stream().filter(o -> FeeBelongEnum.HEAD.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(headBudget)) {
                            item.setHeadFeeAmount(BigDecimal.ZERO);
                        } else {
                            item.setHeadFeeAmount(headBudget.stream().map(ActivityDetailPlanBudget::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        }
                        List<ActivityDetailPlanBudget> regionAutomaticBudget = activityDetailPlanBudgets.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(regionAutomaticBudget)) {
                            item.setRegionAutomaticFeeAmount(BigDecimal.ZERO);
                        } else {
                            item.setRegionAutomaticFeeAmount(regionAutomaticBudget.stream().map(ActivityDetailPlanBudget::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                        }
                        List<ActivityDetailPlanBudget> regionReferendumBudget = activityDetailPlanBudgets.stream().filter(o -> FeeBelongEnum.REGION_REFERENDUM.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(regionReferendumBudget)) {
                            item.setRegionReferendumFeeAmount(BigDecimal.ZERO);
                        } else {
                            item.setRegionReferendumFeeAmount(regionReferendumBudget.stream().map(ActivityDetailPlanBudget::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                        }
                    }
                }
            }
            //垂直。根据明细上门店编码查询售达方编码名称
            List<String> terminalCodes = activityDetailPlanItems.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).map(ActivityDetailPlanItem::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toList());
            Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(terminalCodes)) {
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(terminalCodes);
                if (!CollectionUtils.isEmpty(terminalVos)) {
                    terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                }
            }
            for (ActivityDetailPlanItem item : activityDetailPlanItems) {
                if (StringUtils.isNotBlank(item.getTerminalCode())) {
                    if (terminalVoMap.containsKey(item.getTerminalCode())) {
                        TerminalVo terminalVo = terminalVoMap.get(item.getTerminalCode());
                        //售达方编码（客户编码）
                        String sellerCode = terminalVo.getSellerCode();
                        //销售机构编码  销售机构编码拼接规则是：分销渠道+业态+销售机构编码
                        String instituCode = terminalVo.getSalesInstitutionCode();
                        // customerCode 编码规则 ： 售达方编码 + 销售机构编码 + 分销渠道 + 业态
                        if (StringUtils.isNotBlank(sellerCode) && StringUtils.isNotBlank(instituCode) && instituCode.length() >= 8) {
                            item.setCustomerCode(sellerCode + instituCode.substring(4) + instituCode.substring(0, 4));
                            item.setCustomerName(terminalVo.getSellerName());
                        }
                        item.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                        item.setActivityOrgName(terminalVo.getSalesInstitutionName());
                    }
                }
            }


            activityDetailPlanItems.forEach(item -> {
                item.setBusinessUnitCode(activityDetailPlan.getBusinessUnitCode());
                item.setBusinessFormatCode(activityDetailPlan.getBusinessFormatCode());
            });
            log.info("细案明细要保存数据{}", JSON.toJSONString(activityDetailPlanItems));
            activityDetailPlanItemRepository.saveBatch(activityDetailPlanItems);

            if (!CollectionUtils.isEmpty(extendFieldSaveList)) {
                activityDetailPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
            }
            log.info("细案明细数据{}", JSON.toJSONString(activityDetailPlanItems));
        }
    }

    /**
     * 活动方案预算关联策略、方案
     *
     * @param
     */
    public List<ActivityDetailPlanBudget> matchActivityPlanBudgetRelate(ActivityPlanItemDto planItemDto, List<ActivityDetailPlanItem> itemList) {

        List<ActivityDetailPlanBudget> budgetDtos = new ArrayList<>();
        Set<String> monthBudgetCodeSet = Sets.newHashSet();
        monthBudgetCodeSet.addAll(itemList.stream().map(ActivityDetailPlanItem::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        monthBudgetCodeSet.addAll(itemList.stream().map(ActivityDetailPlanItem::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));

        //查下月度预算信息，保存费用归口
        Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
            List<MonthBudgetVo> monthBudgetList = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }
        for (ActivityDetailPlanItem item : itemList) {
            if (StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())) {
                ActivityDetailPlanBudget monthBudget = new ActivityDetailPlanBudget();
                monthBudget.setDetailPlanCode(item.getDetailPlanCode());
                monthBudget.setDetailPlanItemCode(item.getDetailPlanItemCode());
                monthBudget.setRelatePlanCode(planItemDto.getPlanCode());
                monthBudget.setRelatePlanItemCode(item.getRelatePlanItemCode());
                monthBudget.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                monthBudget.setBudgetItemCode(item.getHeadBudgetItemCode());
                monthBudget.setBudgetItemName(item.getHeadBudgetItemName());
                monthBudget.setUseAmount(item.getHeadFeeAmount());
                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(item.getHeadMonthBudgetCode()) ? monthBudgetMap.get(item.getHeadMonthBudgetCode()).getFeeBelongCode() : null);
                budgetDtos.add(monthBudget);
            }
            if (StringUtils.isNotEmpty(item.getMonthBudgetCode())) {
                ActivityDetailPlanBudget monthBudget = new ActivityDetailPlanBudget();
                monthBudget.setDetailPlanCode(item.getDetailPlanCode());
                monthBudget.setDetailPlanItemCode(item.getDetailPlanItemCode());
                monthBudget.setRelatePlanCode(planItemDto.getPlanCode());
                monthBudget.setRelatePlanItemCode(item.getRelatePlanItemCode());
                monthBudget.setMonthBudgetCode(item.getMonthBudgetCode());
                monthBudget.setBudgetItemCode(item.getBudgetItemCode());
                monthBudget.setBudgetItemName(item.getBudgetItemName());
                monthBudget.setUseAmount(item.getDepartmentFeeAmount());
                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(item.getMonthBudgetCode()) ? monthBudgetMap.get(item.getMonthBudgetCode()).getFeeBelongCode() : null);
                budgetDtos.add(monthBudget);
            }
        }
        return budgetDtos;
    }

    @Override
    public <T1 extends ActivityPlanItemBase, T2 extends ActivityPlanItemTerminalDto> ActivityDetailPlanItem buildByActivityItemTerminal(ActivityDetailPlan activityDetailPlan, T1 item,
                                                                                                                                        T2 activityPlanItemTerminalDto, String templateConfigCode, String toDay,
                                                                                                                                        List<ActivityDetailPlanItemExtendField> extendFieldSaveList) {
        ActivityDetailPlanItem activityDetailPlanItem = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItem.class, null, null);
        //生成code
        // Z-+8位流水
        String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
        List<String> codeList = this.generateCodeService.generateCode(ruleCode, 1, 8, 0, TimeUnit.DAYS);

        activityDetailPlanItem.setDetailPlanItemCode(codeList.get(0));
        //设置细案模版
        activityDetailPlanItem.setTemplateConfigCode(templateConfigCode);

        activityDetailPlanItem.setRelatePlanCode(item.getPlanCode());
        activityDetailPlanItem.setRelatePlanItemCode(item.getPlanItemCode());
        activityDetailPlanItem.setTerminalCode(activityPlanItemTerminalDto.getTerminalCode());
        activityDetailPlanItem.setTerminalName(activityPlanItemTerminalDto.getTerminalName());

        activityDetailPlanItem.setPeriodPromotionalNumber(Optional.ofNullable(activityPlanItemTerminalDto.getQuantity()).orElse(BigDecimal.ZERO).intValue());
        activityDetailPlanItem.setDisplayQuantity(activityPlanItemTerminalDto.getQuantity());
        activityDetailPlanItem.setTotalFeeAmount(activityPlanItemTerminalDto.getAmount());
        activityDetailPlanItem.setFeeAmount(activityPlanItemTerminalDto.getFeeAmount());
        activityDetailPlanItem.setSystemBorneAmount(activityPlanItemTerminalDto.getSystemBorneAmount());
        activityDetailPlanItem.setResponsibleBusiness(activityPlanItemTerminalDto.getResponsibleBusiness());
        activityDetailPlanItem.setResponsibleSupervision(activityPlanItemTerminalDto.getResponsibleSupervision());
        activityDetailPlanItem.setNameOfShoppingGuide(activityPlanItemTerminalDto.getName());
        activityDetailPlanItem.setEmployeeId(activityPlanItemTerminalDto.getEmpId());
        activityDetailPlanItem.setEmployeeCode(activityPlanItemTerminalDto.getEmployeeCode());
        activityDetailPlanItem.setTelephone(activityPlanItemTerminalDto.getPhone());
        activityDetailPlanItem.setIdentityCard(activityPlanItemTerminalDto.getIdentityCard());
        activityDetailPlanItem.setQuantity(Optional.ofNullable(activityPlanItemTerminalDto.getQuantity()).orElse(BigDecimal.ZERO).intValue());
        activityDetailPlanItem.setFloatingRate(activityPlanItemTerminalDto.getFloatingRate());
        //        浮动量=期间促销件数*（1+浮动率）
        if (null != activityDetailPlanItem.getPeriodPromotionalNumber() && null != activityPlanItemTerminalDto.getFloatingRate()) {
            activityDetailPlanItem.setFloatingNumber(new BigDecimal(activityDetailPlanItem.getPeriodPromotionalNumber()).multiply(BigDecimal.ONE.add(activityPlanItemTerminalDto.getFloatingRate())));
        }
        //        浮动金额=费用合计* （1+浮动率）
        activityDetailPlanItem.setFloatingAmount(activityPlanItemTerminalDto.getFloatingRate());
        if (null != activityDetailPlanItem.getTotalFeeAmount() && null != activityPlanItemTerminalDto.getFloatingRate()) {
            activityDetailPlanItem.setFloatingAmount(activityDetailPlanItem.getTotalFeeAmount().multiply(BigDecimal.ONE.add(activityPlanItemTerminalDto.getFloatingRate())));
        }
        activityPlanItemTerminalDto.setDetailPlanItemCode(activityDetailPlanItem.getDetailPlanItemCode());
        calculateItemData(activityDetailPlanItem, item, toDay);
        //垂直 岗店分摊的我方承担金额=门店明细的费用总和
        if (BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlan.getBusinessUnitCode()) && StringUtils.isNotEmpty(activityPlanItemTerminalDto.getEmployeeCode())) {
            activityDetailPlanItem.setRegionAutomaticFeeAmount(activityDetailPlanItem.getFeeAmount());
        }

        //期间促销金额=促销售价*期间促销件数
        if (null != activityDetailPlanItem.getPeriodPromotionalNumber() && null != activityDetailPlanItem.getPromotionPriceTax()) {
            activityDetailPlanItem.setPeriodPromotionalAmount(new BigDecimal(activityDetailPlanItem.getPeriodPromotionalNumber()).multiply(activityDetailPlanItem.getPromotionPriceTax()));
        }

        List<ActivityDetailPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(item, ActivityPlanItemExtendFieldBase.class, ActivityDetailPlanItemExtendField.class);
        if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
            activityPlanItemExtendFields.forEach(extendField -> {
                extendField.setDetailPlanCode(activityDetailPlanItem.getDetailPlanCode());
                extendField.setDetailPlanItemCode(activityDetailPlanItem.getDetailPlanItemCode());
                extendField.setTenantCode(activityDetailPlanItem.getTenantCode());
            });
            extendFieldSaveList.addAll(activityPlanItemExtendFields);
        }
        return activityDetailPlanItem;
    }

    private Collection<ActivityDetailPlanBudget> buildDetailBudget(List<ActivityPlanBudgetDto> budgetList, ActivityPlanItemDto item, ActivityDetailPlanItem activityDetailPlanItem) {
        List<ActivityDetailPlanBudget> activityDetailPlanBudgets = Lists.newArrayList();
        for (ActivityPlanBudgetDto budgetDto : budgetList) {
            ActivityDetailPlanBudget o = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityDetailPlanBudget.class, HashSet.class, ArrayList.class);
            o.setDetailPlanItemCode(activityDetailPlanItem.getDetailPlanItemCode());
            if (o.getOccupyType().equals(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode())) {
                o.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
            }
            o.setRelatePlanCode(budgetDto.getPlanCode());
            o.setRelatePlanItemCode(budgetDto.getPlanItemCode());
            activityDetailPlanBudgets.add(o);
        }
        return activityDetailPlanBudgets;
    }

    private ActivityDetailPlanItem buildDetailItem(ActivityPlanItemDto item, String toDay) {
        ActivityDetailPlanItem activityDetailPlanItem = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItem.class, null, null);
        //设置细案模版
//        ActivityFormVo activityFormVo = activityFormVoMap.get(activityDetailPlanItem.getActivityFormCode());
//        if(activityFormVo!=null) {
//            activityDetailPlanItem.setTemplateConfigCode(activityFormVo.getThinProjectTemplate());
//        }
        //todo 客户编码 ,门店编码 ,零售商,门店数量,单位编码,原品价格,原品数量,赠品价格,赠品数量,陈列类型,门店预计月销售额,上月门店实际月销售额,结案形式,付款方式,竞品情况,是否和价格有关,共用组,物料单位,物料单价,物料数量,合同编码,账期,单场费用,购买方式,月销售任务,目前铺市率,月目标铺市率,是否发起巡查需求,期间促销量（件）,期间促销额（元）,期间渠道促销量（件）,期间渠道促销额（元）,全月回复量（件）,全月回复额（元）,本月投入产出比待定
        //生成code
        // Z-+8位流水
        String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
        List<String> codeList = this.generateCodeService.generateCode(ruleCode, 1, 8, 0, TimeUnit.DAYS);
        activityDetailPlanItem.setDetailPlanItemCode(codeList.get(0));
        activityDetailPlanItem.setRelatePlanCode(item.getPlanCode());
        activityDetailPlanItem.setRelatePlanItemCode(item.getPlanItemCode());
        activityDetailPlanItem.setRemark(item.getRemark());
        activityDetailPlanItem.setActivityDesc(item.getActivityDesc());

        calculateItemData(activityDetailPlanItem, item, toDay);


        //期间促销金额=促销售价*期间促销件数
        if (null != activityDetailPlanItem.getPeriodPromotionalNumber() && null != activityDetailPlanItem.getPromotionPriceTax()) {
            activityDetailPlanItem.setPeriodPromotionalAmount(new BigDecimal(activityDetailPlanItem.getPeriodPromotionalNumber()).multiply(activityDetailPlanItem.getPromotionPriceTax()));
        }
        return activityDetailPlanItem;
    }

    //计算行上的数据
    private <T1 extends ActivityPlanItemBase> void calculateItemData(ActivityDetailPlanItem item, T1 activityPlanItemDto, String toDay) {

        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode("detail_plan_template_map", item.getTemplateConfigCode());
        if (null == dictDataVo) {
            return;
        }
        Validate.notNull(dictDataVo, "请用模版编码【%s】在数据字典detail_plan_template_map中配置模版映射", item.getTemplateConfigCode());
        //促销
        if (ActivityDetailPlanTemplateMapEnum.PROMOTION.getCode().equals(dictDataVo.getDictValue())) {
            //系统承担金额=系统承担比例*费用合计
//            if (Objects.nonNull(item.getSystemAssumeRatio()) && Objects.nonNull(item.getTotalFeeAmount())) {
//                item.setSystemBorneAmount(item.getSystemAssumeRatio().multiply(item.getTotalFeeAmount()));
//            }else {
//                item.setSystemBorneAmount(BigDecimal.ZERO);
//            }
//            //我方承担金额=费用合计-系统承担金额
//            if (Objects.nonNull(item.getTotalFeeAmount()) && Objects.nonNull(item.getSystemBorneAmount())) {
//                item.setFeeAmount(item.getTotalFeeAmount().subtract(item.getSystemBorneAmount()));
//            }

            //门店月计划量 = 根据门店编码+产品+活动结束日期所在年月查询销售计划计划量
            if (StringUtils.isNotEmpty(item.getTerminalCode()) && StringUtils.isNotEmpty(item.getProductCode()) && Objects.nonNull(item.getActivityEndDate())) {
                SalesPlanDto salesPlanDto = new SalesPlanDto();
                salesPlanDto.setTerminalCode(item.getTerminalCode());
                salesPlanDto.setProductCode(item.getProductCode());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                salesPlanDto.setYearMonthLy(sdf.format(item.getActivityEndDate()));
                List<SalesPlanVo> salesPlanVoList = salesPlanService.findByConditions(salesPlanDto);
                if (!CollectionUtils.isEmpty(salesPlanVoList)) {
                    item.setTerminalMonthPlanQuantity(salesPlanVoList.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }
            }
            //门店共用量=默认为期间促销件数
            item.setTerminalTotalQuantity(item.getPeriodPromoteQuantity());
            //门店共用金额=默认为我方承担金额
            item.setTerminalTotalAmount(item.getFeeAmount());
            //浮动量=（1+浮动率）*门店共用量
            if (Objects.nonNull(item.getFloatingRate()) && Objects.nonNull(item.getTerminalTotalQuantity())) {
                item.setFloatingNumber(item.getFloatingRate().add(BigDecimal.ONE).multiply(item.getTerminalTotalQuantity()));
            }
            //浮动金额=（1+浮动率）*门店共用金额
            if (Objects.nonNull(item.getFloatingRate()) && Objects.nonNull(item.getTerminalTotalAmount())) {
                item.setFloatingAmount(item.getFloatingRate().add(BigDecimal.ONE).multiply(item.getTerminalTotalAmount()));
            } else {
                item.setFloatingAmount(null);
            }
            //陈列 人员 合同
        } else if (ActivityDetailPlanTemplateMapEnum.DISPLAY.getCode().equals(dictDataVo.getDictValue())
                || ActivityDetailPlanTemplateMapEnum.PERSONNEL.getCode().equals(dictDataVo.getDictValue())
                || ActivityDetailPlanTemplateMapEnum.CONTRACT.getCode().equals(dictDataVo.getDictValue())
        ) {
            //系统承担金额=根据细案金额占总金额占比分摊总系统承担金额
//            if(Objects.nonNull(activityPlanItemDto.getSystemBorneAmount())&&Objects.nonNull(activityPlanItemDto.getTotalFeeAmount())
//                &&activityPlanItemDto.getTotalFeeAmount().compareTo(BigDecimal.ZERO)!=0
//                &&Objects.nonNull(item.getTotalFeeAmount())
//            ){
//                item.setSystemBorneAmount(activityPlanItemDto.getSystemBorneAmount().divide(activityPlanItemDto.getTotalFeeAmount(),6,RoundingMode.HALF_UP).multiply(item.getTotalFeeAmount()));
//            }
            //我方承担金额=费用合计-系统承担金额
            if (Objects.nonNull(item.getTotalFeeAmount()) && Objects.nonNull(item.getSystemBorneAmount())) {
                item.setOurAssumeRatio(item.getTotalFeeAmount().subtract(item.getSystemBorneAmount()));
            }
            //行销
        } else if (ActivityDetailPlanTemplateMapEnum.TRADE_SALE.getCode().equals(dictDataVo.getDictValue())) {
            //未税金额=未含税单价*数量
            if (Objects.nonNull(item.getPriceExcludingTax()) && Objects.nonNull(item.getQuantity())) {
                item.setAmountExcludingTax(item.getPriceExcludingTax().multiply(new BigDecimal(item.getQuantity())));
            }
            //含税金额=含税单价*数量
            if (Objects.nonNull(item.getPriceIncludingTax()) && Objects.nonNull(item.getQuantity())) {
                item.setAmountIncludingTax(item.getPriceIncludingTax().multiply(new BigDecimal(item.getQuantity())));
            }
        }
    }

    private List<ActivityDetailPlanBudget> splitBudgetByTerminal(List<ActivityPlanBudgetDto> budgetList, List<ActivityPlanItemTerminalDto> activityPlanItemTerminalList, ActivityPlanItemDto item) {

        List<ActivityDetailPlanBudget> budgets = new ArrayList<>();
        BigDecimal totalUseAmount = budgetList.stream().map(ActivityPlanBudgetDto::getUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        //计算每个门店占比
        for (ActivityPlanItemTerminalDto dto : activityPlanItemTerminalList) {
            BigDecimal feeAmount = dto.getFeeAmount();
            if (null == feeAmount) {
                continue;
            }
            BigDecimal leaveAmount = feeAmount;
            List<ActivityDetailPlanBudget> thisBudgets = Lists.newArrayList();
            //拆分每一条预算
            for (ActivityPlanBudgetDto activityPlanBudgetDto : budgetList) {
                if (null == activityPlanBudgetDto.getUseAmount()) {
                    continue;
                }
                ActivityDetailPlanBudget activityDetailPlanBudget = new ActivityDetailPlanBudget();
                BeanUtils.copyProperties(activityPlanBudgetDto, activityDetailPlanBudget);
                activityDetailPlanBudget.setDetailPlanItemCode(dto.getDetailPlanItemCode());
                activityDetailPlanBudget.setRelatePlanCode(activityPlanBudgetDto.getPlanCode());
                activityDetailPlanBudget.setRelatePlanItemCode(activityPlanBudgetDto.getPlanItemCode());
                BigDecimal thisAmount = feeAmount.multiply(activityPlanBudgetDto.getUseAmount().divide(totalUseAmount, 2, RoundingMode.HALF_UP));
                leaveAmount = leaveAmount.subtract(thisAmount);
                activityDetailPlanBudget.setUseAmount(thisAmount);
                if (activityPlanBudgetDto.getOccupyType().equals(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode())) {
                    activityDetailPlanBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                } else {
                    activityDetailPlanBudget.setOccupyType(activityPlanBudgetDto.getOccupyType());
                }
                thisBudgets.add(activityDetailPlanBudget);
            }
            if (!CollectionUtils.isEmpty(thisBudgets)) {
                if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                    ActivityDetailPlanBudget lastBudget = thisBudgets.get(thisBudgets.size() - 1);
                    lastBudget.setUseAmount(lastBudget.getUseAmount().add(leaveAmount));
                }
                budgets.addAll(thisBudgets);
            }
        }
        return budgets;
    }

    /**
     * 获取总条数
     *
     * @param cacheKey 缓存key
     * @return Integer
     */
    @Override
    public Integer getTotal(String cacheKey) {
        String redisCacheKey = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_CACHE_NEW_KEY_PREFIX + MnPageCacheConstant.REDIS_KEY_ID + cacheKey;
        return redisService.lSize(redisCacheKey).intValue();
    }

    /**
     * 查询所有推送sap且在活动执行中的明细编码及其销售组织编码
     *
     * @param planCode 细案编码
     * @return Map<String, String> key:明细编码，value：销售组织编码
     */
    @Override
    public Map<String, String> findItemCodesByDetailPlanCodes(String planCode) {
        return activityDetailPlanItemRepository.findItemCodesByDetailPlanCodes(planCode);
    }

    @Override
    public ActivityDetailPlanItemVo findDetailPlanItemByItemCode(String detailPlanItemCode) {
        ActivityDetailPlanItem item = activityDetailPlanItemRepository.lambdaQuery().eq(ActivityDetailPlanItem::getDetailPlanItemCode, detailPlanItemCode).one();
        if (item != null) {
            return nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class);
        }
        return null;
    }

    @Override
    public List<String> findApprovedDetailItemCodeListByPlanItemCodeList(List<String> planItemCodeList) {
        return activityDetailPlanItemRepository.findApprovedDetailItemCodeListByPlanItemCodeList(planItemCodeList);
    }

    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param itemNos 方案明细编码
     * @return List<String>
     **/
    @Override
    public List<String> getNoClosePlanItemNo(List<String> itemNos) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Lists.newArrayList();
        }
        return activityDetailPlanItemRepository.getNoClosePlanItemNo(itemNos);
    }


    /**
     * 根据活动号判断同一活动号下面的方案是否都已关闭,存在未关闭的则返回false
     *
     * @param actNo 活动号
     * @return Boolean
     **/
    @Override
    public Boolean getAllColseByActNumber(String actNo) {
        if (StringUtils.isBlank(actNo)) {
            return false;
        }
        int count = this.activityDetailPlanItemRepository.lambdaQuery()
                .eq(ActivityDetailPlanItem::getActivityNumber, actNo)
                .eq(ActivityDetailPlanItem::getIsClose, BooleanEnum.FALSE.getCapital())
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .count();
        return count == 0;
    }

    /**
     * 方案退预算，修改细案明细，修改细案预算明细（方案关闭）
     *
     * @param dto 参数
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editPlanDetailPlanAndBudget(ActivityPlanDetailPlanAndBudgetEditDto dto) {
        if (!CollectionUtils.isEmpty(dto.getDetailPlanList())) {
            activityDetailPlanItemRepository.updateBatchById(dto.getDetailPlanList());
        }
        if (!CollectionUtils.isEmpty(dto.getDetailPlanBudgetList())) {
            activityDetailPlanBudgetVerticalService.operateBudget(dto.getDetailPlanBudgetList());
        }
        if (!CollectionUtils.isEmpty(dto.getPlanOperateList())) {
            activityPlanBudgetVerticalService.operateBudget(dto.getPlanOperateList());
        }
    }

    /**
     * 分页查询，方案未关闭，细案已关闭，细案未回退预算的数据
     *
     * @param pageable                  分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanItemVo> findNoRollBackByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemRepository.findNoRollBackByConditions(pageable, activityDetailPlanItemDto);
    }

    /**
     * 细案退预算，修改细案明细，修改细案预算明细（细案单独关闭）
     *
     * @param dto 参数
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editDetailPlanAndBudget(ActivityPlanDetailPlanAndBudgetEditDto dto) {
        if (!CollectionUtils.isEmpty(dto.getDetailPlanList())) {
            activityDetailPlanItemRepository.updateBatchById(dto.getDetailPlanList());
        }
        if (!CollectionUtils.isEmpty(dto.getDetailPlanBudgetList())) {
            activityDetailPlanBudgetVerticalService.operateBudget(dto.getDetailPlanBudgetList());
        }
        if (!CollectionUtils.isEmpty(dto.getPlanOperateList())) {
            activityPlanBudgetVerticalService.operateBudget(dto.getPlanOperateList());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCost(List<ActivityDetailPlanItemVo> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        Collection<ActivityDetailPlanItem> itemList = nebulaToolkitService.copyCollectionByWhiteList(items, ActivityDetailPlanItemVo.class, ActivityDetailPlanItem.class, HashSet.class, ArrayList.class);
        this.activityDetailPlanItemRepository.updateBatchById(itemList);
    }

    @Override
    public Page<ActivityDetailPlanItemsExportsVo> findExportListByDetailPlanCodes(Pageable pageable, List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return null;
        }
        Page<ActivityDetailPlanItemsExportsVo> page = activityDetailPlanItemRepository.findExportListByDetailPlanCodes(pageable, detailPlanCodes);
        return page;
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Pageable pageable, ActivityDetailPlanItemDto dto) {
        Page<ActivityDetailPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (CollectionUtils.isEmpty(dto.getDetailPlanCodeList()) && CollectionUtils.isEmpty(dto.getRelatePlanItemCodeList())
                && CollectionUtils.isEmpty(dto.getDetailPlanItemCodeList())) {
            return page;
        }
        if (pageable.getPageSize() == 999999) {
            page.setSize(-1);//根据编码查，不分页
        }
        return activityDetailPlanItemRepository.findConditionByPlanCodes(page, dto);
    }


    /**
     * 重复活动细案查看
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-14 23:35
     */
    @Override
    public Page<ActivityDetailPlanItemVo> repeatActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto) {
        Assert.notNull(dto, "查询对象不能为空!");
        String cacheKey = dto.getCacheKey();
        Assert.hasLength(dto.getCacheKey(), "缓存ID[cacheKey]不能为空!");
        Assert.hasLength(dto.getId(), "ID[id]不能为空!");
        String redisCacheDataKey = helper.getRedisCacheDataKey(cacheKey);
        String id = dto.getId();
        if (StringUtil.isEmpty(redisCacheDataKey)) {
            log.error("重复活动细案查看   cacheKey[{}]  缓存的[redisCacheDataKey]为空 ", cacheKey);
            return new Page<>();
        }
        Object data = redisTemplate.opsForHash().get(redisCacheDataKey, id);
        if (Objects.isNull(data)) {
            log.error("重复活动细案查看   cacheKey[{}]  缓存的redisCacheDataKey[{}]  数据ID[{}]未找到数据", redisCacheDataKey, cacheKey, id);
            return new Page<>();
        }
        ActivityDetailPlanItemDto sourceDto = (ActivityDetailPlanItemDto) data;
        //活动形式编码、活动开始时间，活动结束时间，客户编码，产品编码 相同
        if (StringUtil.isEmpty(sourceDto.getActivityFormCode())
                || Objects.isNull(sourceDto.getActivityBeginDate())
                || Objects.isNull(sourceDto.getActivityEndDate())
                || StringUtil.isEmpty(sourceDto.getCustomerCode())
                || StringUtil.isEmpty(sourceDto.getProductCode())) {
            return new Page<>();
        }
        String activityBeginDateStr = DateUtil.date_yyyy_MM_dd.format(sourceDto.getActivityBeginDate());
        String activityEndDateStr = DateUtil.date_yyyy_MM_dd.format(sourceDto.getActivityEndDate());
        sourceDto.setActivityBeginDateStr(activityBeginDateStr);
        sourceDto.setActivityEndDateStr(activityEndDateStr);
        dto.setId("");
        Page<ActivityDetailPlanItemVo> planItemVoPage = activityDetailPlanItemRepository.repeatActivityDetailPlanItemPage(pageable, dto, sourceDto);
        if (CollectionUtil.isEmpty(planItemVoPage.getRecords())) {
            return planItemVoPage;
        }
        List<String> detailPlanItemCodeList = planItemVoPage.getRecords().stream().filter(k -> StringUtil.isNotEmpty(k.getDetailPlanItemCode()))
                .map(ActivityDetailPlanItemVo::getDetailPlanItemCode).distinct().collect(Collectors.toList());
        List<ActivityDetailPlanItemExtend> extendList = activityDetailPlanItemExtendRepository.findByPlanItemCodes(detailPlanItemCodeList);
        if (CollectionUtil.isEmpty(extendList)) {
            return planItemVoPage;
        }
        Map<String, ActivityDetailPlanItemExtend> extendMap = extendList.stream()
                .collect(Collectors.toMap(ActivityDetailPlanItemExtend::getDetailPlanItemCode, v -> v, (n, o) -> n));
        planItemVoPage.getRecords().forEach(item -> {
            ActivityDetailPlanItemExtend extend = extendMap.get(item.getDetailPlanItemCode());
            if (Objects.nonNull(extend)) {
                item.setRetailerChannel(extend.getRetailerChannel());
            }
        });
        activityDetailPlanItemRepository.fillVoListProperties(planItemVoPage.getRecords());
        return planItemVoPage;
    }
}

