package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.enums.CustomerClassEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.log.ActivityDetailPlanLogEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeBudgetDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案接口实现
 * @author wanghaojia
 * @date 2022/11/22 15:47
 */
@Slf4j
@Service
public class ActivityDetailPlanItemTerminalServiceImpl implements ActivityDetailPlanItemTerminalService {

    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalRepository activityDetailPlanItemTerminalRepository;


    @Override
    public List<ActivityDetailPlanReportVo> findTerminalListByDetailPlanItemCode(String detailPlanItemCode) {
        return activityDetailPlanItemTerminalRepository.findTerminalVoListByDetailItemCode(detailPlanItemCode);
    }

    @Override
    public Page<ActivityDetailPlanItemTerminalVo> findTerminalByDetailPlanItemCode(Pageable pageable, String detailPlanItemCode) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        Validate.notBlank(detailPlanItemCode,"活动细案明细编码不能为空！");
        return activityDetailPlanItemTerminalRepository.findTerminalByDetailPlanItemCode(pageable,detailPlanItemCode);
    }

    @Override
    public List<ActivityDetailPlanItemTerminalDto> findTerminalListByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        return activityDetailPlanItemTerminalRepository.findTerminalDtoListByDetailItemCodeList(detailPlanItemCodes);
    }
}
