package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案-关联方案服务
 *
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityDetailPlanPlanServiceImpl implements ActivityDetailPlanPlanService {

    @Autowired(required = false)
    private ActivityDetailPlanPlanRepository activityDetailPlanPlanRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动细案-关联方案数据
     *
     * @param dtoList 活动细案-关联方案数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlanPlanList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanPlanDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }

        Map<String, ActivityDetailPlanPlan> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityDetailPlanPlan> oldList = activityDetailPlanPlanRepository.findListByDetailPlanCode(entity.getDetailPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityDetailPlanPlan::getId, Function.identity()));
        }
        List<ActivityDetailPlanPlan> entityList = (List<ActivityDetailPlanPlan>) nebulaToolkitService.copyCollectionByWhiteList(dtoList, ActivityDetailPlanPlanDto.class, ActivityDetailPlanPlan.class, HashSet.class, ArrayList.class);

        List<ActivityDetailPlanPlan> saveList = Lists.newArrayList();
        List<ActivityDetailPlanPlan> updateList = Lists.newArrayList();
        for (ActivityDetailPlanPlan item : entityList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
            } else {
                item.setDetailPlanCode(entity.getDetailPlanCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            activityDetailPlanPlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            activityDetailPlanPlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            //待删除的数据
            activityDetailPlanPlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public List<ActivityDetailPlanPlanVo> findActPlan(String detailPlanCode) {
        return activityDetailPlanPlanRepository.findListVoByDetailPlanCode(detailPlanCode);
    }


    /**
     * 根据活动方案编码获取活动方案和细案关系
     *
     * @param planCodeList 活动方案编码
     * @return java.util.List<com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.2.26 18:20
     */
    @Override
    public List<ActivityDetailPlanPlan> findDetailPlanAndPlanList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return activityDetailPlanPlanRepository.findDetailPlanAndPlanList(planCodeList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createDetailLinkPlanForOut(ActivityDetailPlan entity, List<ActivityDetailPlanPlanDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<ActivityDetailPlanPlan> entityList = (List<ActivityDetailPlanPlan>) nebulaToolkitService.copyCollectionByWhiteList(dtoList, ActivityDetailPlanPlanDto.class, ActivityDetailPlanPlan.class, HashSet.class, ArrayList.class);
        List<ActivityDetailPlanPlan> saveList = Lists.newArrayList();
        for (ActivityDetailPlanPlan item : entityList) {
            item.setDetailPlanCode(entity.getDetailPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        activityDetailPlanPlanRepository.saveBatch(saveList);
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findForSalesApproval(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanPlanRepository.findForSalesApproval(detailPlanItemCodes);
    }
}
